/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding.snapround;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.noding.NodedSegmentString;
import com.vividsolutions.jts.noding.NodingValidator;
import com.vividsolutions.jts.noding.SegmentString;
import com.vividsolutions.jts.noding.snapround.MCIndexSnapRounder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class GeometryNoder {
    private GeometryFactory geomFact;
    private PrecisionModel pm;
    private boolean isValidityChecked = false;

    public GeometryNoder(PrecisionModel pm) {
        this.pm = pm;
    }

    public void setValidate(boolean isValidityChecked) {
        this.isValidityChecked = isValidityChecked;
    }

    public List node(Collection geoms) {
        Geometry geom0 = (Geometry)geoms.iterator().next();
        this.geomFact = geom0.getFactory();
        List segStrings = this.toSegmentStrings(this.extractLines(geoms));
        MCIndexSnapRounder sr = new MCIndexSnapRounder(this.pm);
        sr.computeNodes(segStrings);
        Collection nodedLines = sr.getNodedSubstrings();
        if (this.isValidityChecked) {
            NodingValidator nv = new NodingValidator(nodedLines);
            nv.checkValid();
        }
        return this.toLineStrings(nodedLines);
    }

    private List toLineStrings(Collection segStrings) {
        ArrayList<LineString> lines = new ArrayList<LineString>();
        Iterator it = segStrings.iterator();
        while (it.hasNext()) {
            SegmentString ss = (SegmentString)it.next();
            if (ss.size() < 2) continue;
            lines.add(this.geomFact.createLineString(ss.getCoordinates()));
        }
        return lines;
    }

    private List extractLines(Collection geoms) {
        ArrayList lines = new ArrayList();
        LinearComponentExtracter lce = new LinearComponentExtracter(lines);
        Iterator it = geoms.iterator();
        while (it.hasNext()) {
            Geometry geom = (Geometry)it.next();
            geom.apply(lce);
        }
        return lines;
    }

    private List toSegmentStrings(Collection lines) {
        ArrayList<NodedSegmentString> segStrings = new ArrayList<NodedSegmentString>();
        Iterator it = lines.iterator();
        while (it.hasNext()) {
            LineString line = (LineString)it.next();
            segStrings.add(new NodedSegmentString(line.getCoordinates(), null));
        }
        return segStrings;
    }
}

