/*
 * Decompiled with CFR 0.152.
 */
package rescuecore;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import rescuecore.CannotFindLocationException;
import rescuecore.Handy;
import rescuecore.RescueConstants;
import rescuecore.RescueObject;
import rescuecore.commands.KASense;
import rescuecore.commands.Update;
import rescuecore.event.MemoryListener;
import rescuecore.event.ObjectAddedEvent;
import rescuecore.event.ObjectChangedEvent;
import rescuecore.event.PropertyChangedEvent;
import rescuecore.event.PropertyListener;
import rescuecore.objects.Building;
import rescuecore.objects.Edge;
import rescuecore.objects.Humanoid;
import rescuecore.objects.MotionlessObject;
import rescuecore.objects.MovingObject;
import rescuecore.objects.Node;
import rescuecore.objects.River;
import rescuecore.objects.RiverNode;
import rescuecore.objects.Road;
import rescuecore.objects.Vertex;

public abstract class Memory
implements Serializable {
    private int minX;
    private int maxX;
    private int width = -1;
    private int minY;
    private int maxY;
    private int height;
    private transient Collection<MemoryListener> listeners;
    private final Object LOCK = new Integer(0);
    private final PropertyListener PROPERTY_LISTENER = new InternalPropertyListener();

    protected Memory() {
        this.listeners = new HashSet<MemoryListener>();
    }

    public abstract Memory copy();

    public int getMinX() {
        if (this.width == -1) {
            this.calculateDimensions();
        }
        return this.minX;
    }

    public int getMaxX() {
        if (this.width == -1) {
            this.calculateDimensions();
        }
        return this.maxX;
    }

    public int getMinY() {
        if (this.width == -1) {
            this.calculateDimensions();
        }
        return this.minY;
    }

    public int getMaxY() {
        if (this.width == -1) {
            this.calculateDimensions();
        }
        return this.maxY;
    }

    public int getWidth() {
        if (this.width == -1) {
            this.calculateDimensions();
        }
        return this.width;
    }

    public int getHeight() {
        if (this.width == -1) {
            this.calculateDimensions();
        }
        return this.height;
    }

    private void calculateDimensions() {
        Collection<RescueObject> allNodes = this.getObjectsOfType(4);
        if (allNodes.size() == 0) {
            this.minX = 0;
            this.maxX = 1;
            this.minY = 0;
            this.maxY = 1;
        } else {
            Iterator<RescueObject> it = allNodes.iterator();
            Node n = (Node)it.next();
            this.minX = n.getX();
            this.minY = n.getY();
            this.maxX = this.minX;
            this.maxY = this.minY;
            while (it.hasNext()) {
                n = (Node)it.next();
                int x = n.getX();
                this.minX = Math.min(this.minX, x);
                this.maxX = Math.max(this.maxX, x);
                int y = n.getY();
                this.minY = Math.min(this.minY, y);
                this.maxY = Math.max(this.maxY, y);
            }
        }
        this.width = this.maxX - this.minX;
        this.height = this.maxY - this.minY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMemoryListener(MemoryListener l) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.listeners == null) {
                this.listeners = new HashSet<MemoryListener>();
            }
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMemoryListener(MemoryListener l) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.listeners == null) {
                this.listeners = new HashSet<MemoryListener>();
            }
            this.listeners.remove(l);
        }
    }

    public abstract RescueObject lookup(int var1);

    public abstract Collection<RescueObject> getAllObjects();

    public abstract void getObjectsOfType(Collection<RescueObject> var1, int ... var2);

    public Collection<RescueObject> getObjectsOfType(int ... types) {
        HashSet<RescueObject> result = new HashSet<RescueObject>();
        this.getObjectsOfType(result, types);
        return result;
    }

    public void add(RescueObject o, int timestamp) {
        this.add(o, timestamp, null);
    }

    public void add(RescueObject o, int timestamp, Object source) {
        this.fireObjectAdded(o, timestamp, source);
        o.addPropertyListener(this.PROPERTY_LISTENER);
    }

    public void remove(RescueObject o) {
        o.removePropertyListener(this.PROPERTY_LISTENER);
    }

    public void update(KASense sense) {
        this.update(sense.getUpdatedObjects(), sense.getTime(), RescueConstants.SOURCE_SENSE);
    }

    public void update(Update update) {
        this.update(update.getUpdatedObjects(), update.getTime(), RescueConstants.SOURCE_UPDATE);
    }

    public void update(RescueObject[] changed, int time, Object source) {
        for (int i = 0; i < changed.length; ++i) {
            RescueObject current = this.lookup(changed[i].getID());
            if (current == null) {
                RescueObject copy = changed[i].copy();
                this.add(copy, time, source);
                continue;
            }
            current.merge(changed[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireObjectAdded(RescueObject o, int timestep, Object source) {
        ObjectAddedEvent event = new ObjectAddedEvent(o, timestep, source);
        Object object = this.LOCK;
        synchronized (object) {
            if (this.listeners == null) {
                this.listeners = new HashSet<MemoryListener>();
            }
            Iterator<MemoryListener> it = this.listeners.iterator();
            while (it.hasNext()) {
                it.next().objectAdded(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireObjectChanged(RescueObject o, int property, int timestep, Object source) {
        ObjectChangedEvent event = new ObjectChangedEvent(o, property, timestep, source);
        Object object = this.LOCK;
        synchronized (object) {
            if (this.listeners == null) {
                this.listeners = new HashSet<MemoryListener>();
            }
            Iterator<MemoryListener> it = this.listeners.iterator();
            while (it.hasNext()) {
                it.next().objectChanged(event);
            }
        }
    }

    public double getDistance(RescueObject o1, RescueObject o2) throws CannotFindLocationException {
        int[] xy = this.getXY(o1);
        int x1 = xy[0];
        int y1 = xy[1];
        xy = this.getXY(o2);
        int x2 = xy[0];
        int y2 = xy[1];
        double x = x2 - x1;
        x *= x;
        double y = y2 - y1;
        y *= y;
        return Math.sqrt(x + y);
    }

    public int getAngle(RescueObject from, RescueObject to) throws CannotFindLocationException {
        int y2;
        int dy;
        int[] xy = this.getXY(from);
        int x1 = xy[0];
        int y1 = xy[1];
        xy = this.getXY(to);
        int x2 = xy[0];
        int dx = x2 - x1;
        double theta = Math.atan2(-dx, dy = (y2 = xy[1]) - y1);
        if (theta < 0.0) {
            theta += Math.PI * 2;
        }
        return (int)(theta * 360.0 * 60.0 * 60.0 / (Math.PI * 2));
    }

    public int[] getXY(RescueObject o) throws CannotFindLocationException {
        int x = 0;
        int y = 0;
        block0 : switch (o.getType()) {
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                RescueObject location = this.lookup(((Humanoid)o).getPosition());
                if (location == null) {
                    throw new CannotFindLocationException();
                }
                switch (location.getType()) {
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: {
                        x = ((Building)location).getX();
                        y = ((Building)location).getY();
                        break block0;
                    }
                    case 4: {
                        x = ((Node)location).getX();
                        y = ((Node)location).getY();
                        break block0;
                    }
                    case 5: {
                        x = ((RiverNode)location).getX();
                        y = ((RiverNode)location).getY();
                        break block0;
                    }
                    case 2: {
                        Node roadHead = (Node)this.lookup(((Road)location).getHead());
                        Node roadTail = (Node)this.lookup(((Road)location).getTail());
                        int roadLength = ((Road)location).getLength();
                        double d = (double)((Humanoid)o).getPositionExtra() / (double)roadLength;
                        int xDelta = roadTail.getX() - roadHead.getX();
                        int yDelta = roadTail.getY() - roadHead.getY();
                        x = (int)((double)roadHead.getX() + d * (double)xDelta);
                        y = (int)((double)roadHead.getY() + d * (double)yDelta);
                        break block0;
                    }
                    case 67: {
                        return this.getXY(location);
                    }
                }
                System.err.println("Can't find location for a humanoid that lives in " + Handy.getTypeName(location.getType()));
                throw new CannotFindLocationException(o + " is located at " + location + " but I don't know how to handle that");
            }
            case 4: {
                x = ((Node)o).getX();
                y = ((Node)o).getY();
                break;
            }
            case 5: {
                x = ((RiverNode)o).getX();
                y = ((RiverNode)o).getY();
                break;
            }
            case 2: {
                Node head = (Node)this.lookup(((Road)o).getHead());
                Node tail = (Node)this.lookup(((Road)o).getTail());
                if (head == null) {
                    System.err.println("Can't find head of this road: " + o.toLongString());
                }
                if (tail == null) {
                    System.err.println("Can't find tail of this road: " + o.toLongString());
                }
                x = (head.getX() + tail.getX()) / 2;
                y = (head.getY() + tail.getY()) / 2;
                break;
            }
            case 3: {
                RiverNode head_ = (RiverNode)this.lookup(((River)o).getHead());
                RiverNode tail_ = (RiverNode)this.lookup(((River)o).getTail());
                x = (head_.getX() + tail_.getX()) / 2;
                y = (head_.getY() + tail_.getY()) / 2;
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                x = ((Building)o).getX();
                y = ((Building)o).getY();
                break;
            }
            case 1: {
                throw new CannotFindLocationException("Tried to find the position of a TYPE_WORLD object");
            }
        }
        return new int[]{x, y};
    }

    public RescueObject getPosition(MovingObject o) {
        RescueObject result = this.lookup(o.getPosition());
        return result;
    }

    public MotionlessObject getMotionlessPosition(RescueObject o) {
        switch (o.getType()) {
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                RescueObject position = this.lookup(((Humanoid)o).getPosition());
                if (position == null) {
                    return null;
                }
                return this.getMotionlessPosition(position);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                return (MotionlessObject)o;
            }
        }
        return null;
    }

    public Node getClosestNode(RescueObject o) {
        switch (o.getType()) {
            case 4: {
                return (Node)o;
            }
            case 2: {
                return (Node)this.lookup(((Road)o).getHead());
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                int[] entrances = ((Building)o).getEntrances();
                int best = -1;
                double bestDistance = Double.MAX_VALUE;
                for (int i = 0; i < entrances.length; ++i) {
                    try {
                        double d = this.getDistance(o, this.lookup(entrances[i]));
                        if (!(d < bestDistance)) continue;
                        best = i;
                        bestDistance = d;
                        continue;
                    }
                    catch (CannotFindLocationException e) {
                        // empty catch block
                    }
                }
                if (best == -1) {
                    return null;
                }
                return (Node)this.lookup(entrances[best]);
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                RescueObject location = this.lookup(((Humanoid)o).getPosition());
                if (location == null) {
                    return null;
                }
                switch (location.getType()) {
                    case 4: {
                        return (Node)location;
                    }
                    case 2: {
                        int length = ((Road)location).getLength();
                        int pos = ((Humanoid)o).getPositionExtra();
                        if (pos < length / 2) {
                            return (Node)this.lookup(((Road)location).getHead());
                        }
                        return (Node)this.lookup(((Road)location).getTail());
                    }
                }
                return this.getClosestNode(location);
            }
        }
        return null;
    }

    public Node getClosestNode(Road road, int positionExtra) {
        if (positionExtra < road.getLength() / 2) {
            return (Node)this.lookup(road.getHead());
        }
        return (Node)this.lookup(road.getTail());
    }

    public RescueObject[] findNeighbours(RescueObject o) {
        switch (o.getType()) {
            case 4: {
                return this.findNodeNeighbours((Node)o);
            }
            case 2: {
                return this.findRoadNeighbours((Road)o);
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                return this.findBuildingNeighbours((Building)o);
            }
        }
        System.out.println("Cannot find neighbours of a " + Handy.getTypeName(o.getType()));
        return null;
    }

    public RescueObject[] findNodeNeighbours(Node node) {
        int[] edges = node.getEdges();
        RescueObject[] all = new RescueObject[edges.length];
        boolean count = false;
        for (int i = 0; i < edges.length; ++i) {
            all[i] = this.lookup(edges[i]);
        }
        return all;
    }

    public RescueObject[] findRoadNeighbours(Road road) {
        RescueObject head = this.lookup(road.getHead());
        RescueObject tail = this.lookup(road.getTail());
        return new RescueObject[]{head, tail};
    }

    public Node getHead(Road r) {
        return (Node)this.lookup(r.getHead());
    }

    public Node getTail(Road r) {
        return (Node)this.lookup(r.getTail());
    }

    public Road getRoadBetween(Node n1, Node n2) {
        RescueObject[] neighbours = this.findNodeNeighbours(n1);
        for (int i = 0; i < neighbours.length; ++i) {
            Road r;
            if (!(neighbours[i] instanceof Road) || ((r = (Road)neighbours[i]).getHead() != n1.getID() || r.getTail() != n2.getID()) && (r.getHead() != n2.getID() || r.getTail() != n1.getID())) continue;
            return r;
        }
        return null;
    }

    public boolean neighbours(RescueObject o1, RescueObject o2) {
        Edge e;
        int id = o2.getID();
        if (o1 instanceof Building) {
            int[] entrances = ((Building)o1).getEntrances();
            for (int i = 0; i < entrances.length; ++i) {
                if (entrances[i] != id) continue;
                return true;
            }
        }
        if (o1 instanceof Edge && ((e = (Edge)o1).getHead() == id || e.getTail() == id)) {
            return true;
        }
        if (o1 instanceof Vertex) {
            return this.isEdge(id, (Vertex)o1);
        }
        return false;
    }

    public boolean isEdge(int id, Vertex v) {
        int[] edges = v.getEdges();
        for (int i = 0; i < edges.length; ++i) {
            if (edges[i] != id) continue;
            return true;
        }
        return false;
    }

    public boolean isEdge(RescueObject o, Node node) {
        return this.isEdge(o.getID(), (Vertex)node);
    }

    public boolean isEntrance(int id, Building b) {
        int[] entrances = b.getEntrances();
        for (int i = 0; i < entrances.length; ++i) {
            if (entrances[i] != id) continue;
            return true;
        }
        return false;
    }

    public boolean isEntrance(RescueObject o, Building b) {
        return this.isEntrance(o.getID(), b);
    }

    public RescueObject[] findBuildingNeighbours(Building b) {
        int[] entrances = b.getEntrances();
        RescueObject[] all = new RescueObject[entrances.length];
        boolean count = false;
        for (int i = 0; i < entrances.length; ++i) {
            all[i] = this.lookup(entrances[i]);
        }
        return all;
    }

    private class InternalPropertyListener
    implements PropertyListener,
    Serializable {
        private InternalPropertyListener() {
        }

        @Override
        public void propertyChanged(PropertyChangedEvent event) {
            Memory.this.fireObjectChanged(event.getObject(), event.getProperty(), event.getTimestamp(), event.getSource());
        }
    }
}

