/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.log;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import rescuecore.log.InvalidLogException;
import rescuecore.log.Log;

public class ConvertLog {
    public static void main(String[] args) {
        String inFile = args[0];
        String outFile = args[1];
        try {
            DataInputStream input = new DataInputStream(new BufferedInputStream(new FileInputStream(new File(inFile))));
            byte[] preamble = new byte[Log.HEADER_LENGTH];
            input.read(preamble, 0, preamble.length);
            String preambleString = new String(preamble);
            if ("RoboCup-Rescue Prototype Log 00\u0000".equals(preambleString)) {
                System.out.println("Original log version 0");
            } else if ("RoboCup-Rescue Prototype Log 01\u0000".equals(preambleString)) {
                System.out.println("Original log version 1");
                int length = input.readInt();
                input.skip(length);
            } else {
                throw new InvalidLogException("Unknown log version: " + preambleString);
            }
            DataOutputStream out = new DataOutputStream(new FileOutputStream(new File(outFile)));
            preamble = "RoboCup-Rescue Prototype Log 00\u0000".getBytes();
            out.write(preamble);
            byte[] buffer = new byte[1024];
            int received = 0;
            do {
                if ((received = input.read(buffer)) <= 0) continue;
                out.write(buffer, 0, received);
            } while (received > 0);
            out.flush();
            out.close();
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

