/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.tools.mapgenerator;

import java.util.Random;
import rescuecore.tools.mapgenerator.RescueMap;

public class RescueMapToolkit {
    public static void randomise(RescueMap m, int uniformity, int density, int removal, int movement, boolean nooneway, Random rand) {
        int nodeCount = m.getNodeCount();
        System.out.println("Adjusting nodes by up to " + movement + "m.");
        for (int i = 0; i < nodeCount; ++i) {
            if (!(rand.nextDouble() * 100.0 > (double)uniformity)) continue;
            m.setX(i, m.getX(i) + (int)((rand.nextDouble() - 0.5) * (double)movement * 2000.0));
            m.setY(i, m.getY(i) + (int)((rand.nextDouble() - 0.5) * (double)movement * 2000.0));
        }
        double thresh = 0.01 * (double)removal;
        System.out.println("Removing about " + (int)(thresh * 100.0) + "% of roads.");
        int[][] roads = m.getRoads();
        for (int i = 0; i < roads.length; ++i) {
            if (rand.nextDouble() < thresh) {
                m.setRoad(roads[i][0], roads[i][1], 0);
                m.setRoad(roads[i][1], roads[i][0], 0);
                if (!m.pathExists(roads[i][1], roads[i][0])) {
                    m.setRoad(roads[i][1], roads[i][0], 1);
                    if (m.pathExists(roads[i][0], roads[i][1])) continue;
                    m.setRoad(roads[i][0], roads[i][1], 1);
                    continue;
                }
                if (m.pathExists(roads[i][0], roads[i][1])) continue;
                m.setRoad(roads[i][0], roads[i][1], 1);
                continue;
            }
            if (nooneway || !(rand.nextDouble() < thresh * 0.2)) continue;
            m.setRoad(roads[i][0], roads[i][1], 0);
            if (m.pathExists(roads[i][0], roads[i][1])) continue;
            m.setRoad(roads[i][0], roads[i][1], 1);
        }
    }

    public static void rotate(RescueMap m, double radians) {
        int width = m.getWidth();
        int height = m.getHeight();
        int nodeCount = m.getNodeCount();
        for (int i = 0; i < nodeCount; ++i) {
            double x = m.getX(i) - width / 2;
            double y = m.getY(i) - height / 2;
            double radius = Math.sqrt(x * x + y * y);
            double theta = Math.acos(x / radius);
            if (y > 0.0) {
                theta = Math.PI * 2 - theta;
            }
            x = radius * Math.cos(theta + radians);
            y = radius * Math.sin(theta + radians);
            m.setX(i, (int)x + width / 2);
            m.setY(i, (int)y + height / 2);
        }
    }

    public static void findIntersections(RescueMap m) {
        int[][] rs = m.getRoads();
        block0: for (int i = 0; i < rs.length; ++i) {
            int n1 = rs[i][0];
            int n2 = rs[i][1];
            for (int j = 0; j < rs.length; ++j) {
                int n3 = rs[j][0];
                int n4 = rs[j][1];
                if (n1 == n3 || n1 == n4 || n2 == n3 || n2 == n4) continue;
                int x1 = m.getX(n1);
                int x2 = m.getX(n2);
                int x3 = m.getX(n3);
                int x4 = m.getX(n4);
                int y1 = m.getY(n1);
                int y2 = m.getY(n2);
                int y3 = m.getY(n3);
                int y4 = m.getY(n4);
                int d = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
                if (d == 0) continue;
                double a = (double)((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) * 1.0 / (double)d;
                int x = x1 + (int)(a * (double)(x2 - x1));
                int y = y1 + (int)(a * (double)(y2 - y1));
                if (x <= Math.min(x1, x2) || x >= Math.max(x1, x2) || x >= Math.max(x3, x4) || x <= Math.min(x3, x4) || y <= Math.min(y1, y2) || y >= Math.max(y1, y2) || y >= Math.max(y3, y4) || y <= Math.min(y3, y4)) continue;
                RescueMapToolkit.intersect(m, n1, n2, n3, n4, x, y);
                rs = m.getRoads();
                i = Math.max(0, i - 4);
                j = 0;
                continue block0;
            }
        }
    }

    private static void intersect(RescueMap m, int n1, int n2, int n3, int n4, int x, int y) {
        m.addNode();
        int nodeCount = m.getNodeCount();
        m.setX(nodeCount - 1, x);
        m.setY(nodeCount - 1, y);
        m.setRoad(n1, nodeCount - 1, m.getRoad(n1, n2));
        m.setRoad(n2, nodeCount - 1, m.getRoad(n2, n1));
        m.setRoad(n3, nodeCount - 1, m.getRoad(n3, n4));
        m.setRoad(n4, nodeCount - 1, m.getRoad(n4, n3));
        m.setRoad(nodeCount - 1, n1, m.getRoad(n2, n1));
        m.setRoad(nodeCount - 1, n2, m.getRoad(n1, n2));
        m.setRoad(nodeCount - 1, n3, m.getRoad(n4, n3));
        m.setRoad(nodeCount - 1, n4, m.getRoad(n3, n4));
        m.setRoad(n1, n2, 0);
        m.setRoad(n2, n1, 0);
        m.setRoad(n3, n4, 0);
        m.setRoad(n4, n3, 0);
    }

    public static void smoothRoads(RescueMap m, int size) {
        int max = m.getNodeCount();
        for (int i = 0; i < max; ++i) {
            if (m.getOutDegree(i) < 2 || m.getInDegree(i) < 2) continue;
            int n1 = -1;
            int n3 = -1;
            for (int j = 0; j < m.getNodeCount(); ++j) {
                if (m.getRoad(i, j) + m.getRoad(j, i) < size) continue;
                if (n1 == -1) {
                    n1 = j;
                    continue;
                }
                if (n3 == -1) {
                    n3 = j;
                    continue;
                }
                n1 = -1;
                n3 = -1;
                break;
            }
            if (n1 == -1 || n3 == -1) continue;
            RescueMapToolkit.smooth(m, n1, i, n3);
        }
    }

    private static void smooth(RescueMap m, int n1, int n2, int n3) {
        int x = (m.getX(n1) + m.getX(n3)) / 2;
        int y = (m.getY(n1) + m.getY(n3)) / 2;
        m.addNode();
        m.addNode();
        int nodeCount = m.getNodeCount();
        m.setX(nodeCount - 2, (m.getX(n1) + m.getX(n2)) / 2);
        m.setY(nodeCount - 2, (m.getY(n1) + m.getY(n2)) / 2);
        m.setX(nodeCount - 1, (m.getX(n3) + m.getX(n2)) / 2);
        m.setY(nodeCount - 1, (m.getY(n3) + m.getY(n2)) / 2);
        m.setX(nodeCount - 2, (int)((double)m.getX(nodeCount - 2) * 0.75 + (double)x * 0.25));
        m.setY(nodeCount - 2, (int)((double)m.getY(nodeCount - 2) * 0.75 + (double)y * 0.25));
        m.setX(nodeCount - 1, (int)((double)m.getX(nodeCount - 1) * 0.75 + (double)x * 0.25));
        m.setY(nodeCount - 1, (int)((double)m.getY(nodeCount - 1) * 0.75 + (double)y * 0.25));
        m.setRoad(n1, nodeCount - 2, m.getRoad(n1, n2));
        m.setRoad(nodeCount - 2, n1, m.getRoad(n2, n1));
        m.setRoad(n2, nodeCount - 2, m.getRoad(n2, n1));
        m.setRoad(nodeCount - 2, n2, m.getRoad(n1, n2));
        m.setRoad(n3, nodeCount - 1, m.getRoad(n3, n2));
        m.setRoad(nodeCount - 1, n3, m.getRoad(n2, n3));
        m.setRoad(n2, nodeCount - 1, m.getRoad(n2, n3));
        m.setRoad(nodeCount - 1, n2, m.getRoad(n3, n2));
        m.setRoad(n1, n2, 0);
        m.setRoad(n2, n1, 0);
        m.setRoad(n3, n2, 0);
        m.setRoad(n2, n3, 0);
        x = (m.getX(nodeCount - 2) + m.getX(nodeCount - 1)) / 2;
        y = (m.getY(nodeCount - 2) + m.getY(nodeCount - 1)) / 2;
        m.setX(n2, (int)((double)m.getX(n2) * 0.25 + (double)x * 0.75));
        m.setY(n2, (int)((double)m.getY(n2) * 0.25 + (double)y * 0.75));
    }

    public static double angle(RescueMap m, int n1, int n2, int n3) {
        double theta;
        double x1 = m.getX(n2) - m.getX(n1);
        double y1 = m.getY(n2) - m.getY(n1);
        double x2 = m.getX(n3) - m.getX(n2);
        double y2 = m.getY(n3) - m.getY(n2);
        double mag1 = Math.sqrt(x1 * x1 + y1 * y1);
        double mag2 = Math.sqrt(x2 * x2 + y2 * y2);
        double theta1 = Math.acos(x1 / mag1);
        double theta2 = Math.acos(x2 / mag2);
        if (y1 < 0.0) {
            theta1 = Math.PI * 2 - theta1;
        }
        if (y2 < 0.0) {
            theta2 = Math.PI * 2 - theta2;
        }
        if ((theta = theta2 - theta1) < 0.0) {
            theta += Math.PI * 2;
        }
        theta = theta > Math.PI ? Math.PI * 2 - theta : -theta;
        return theta;
    }

    public static int[] centre(int[][] api) {
        int[] centre = new int[2];
        for (int i = 0; i < api.length - 1; ++i) {
            centre[0] = centre[0] + api[i][0];
            centre[1] = centre[1] + api[i][1];
        }
        centre[0] = centre[0] / (api.length - 1);
        centre[1] = centre[1] / (api.length - 1);
        return centre;
    }

    public static int area(int[][] api) {
        int i;
        long area = 0L;
        long[] distances = new long[api.length];
        for (i = 0; i < api.length; ++i) {
            long a = api[i][0];
            long b = api[i][1];
            distances[i] = (long)Math.sqrt(a * a + b * b);
        }
        for (i = 0; i < api.length - 1; ++i) {
            long ar = RescueMapToolkit.tArea(api[i][0], api[i][1], distances[i], api[i + 1][0], api[i + 1][1], distances[i + 1]);
            if (RescueMapToolkit.isLeft(0, 0, api[i][0], api[i][1], api[i + 1][0], api[i + 1][1])) {
                area -= ar;
                continue;
            }
            area += ar;
        }
        return (int)(area /= 10000L);
    }

    public static long tArea(int x1, int y1, long m1, int x2, int y2, long m2) {
        double theta1 = 0.0;
        double theta2 = 0.0;
        if (m1 != 0L) {
            theta1 = Math.asin((double)y1 * 1.0 / (double)m1);
        }
        if (m2 != 0L) {
            theta2 = Math.asin((double)y2 * 1.0 / (double)m2);
        }
        if (theta1 - theta2 == 0.0) {
            return 0L;
        }
        double a = (double)(m1 * m2) * Math.sin(theta1 - theta2) / 2.0;
        return (long)Math.abs(a);
    }

    public static boolean isLeft(int x, int y, int ax, int ay, int bx, int by) {
        long m;
        long nx = -(by -= ay);
        long ny = bx -= ax;
        return (m = nx * (long)(x -= ax) + ny * (long)(y -= by)) > 0L;
    }

    public static int[] nearestPoint(RescueMap m, int x, int y, int n1, int n2) {
        int d;
        long x2 = m.getX(n2) - m.getX(n1);
        long y2 = m.getY(n2) - m.getY(n1);
        int len = (int)(((long)(x -= m.getX(n1)) * x2 + (long)(y -= m.getY(n1)) * y2) / (long)(d = (int)Math.sqrt(x2 * x2 + y2 * y2)));
        if (len >= d) {
            return new int[]{m.getX(n2), m.getY(n2)};
        }
        if (len <= 0) {
            return new int[]{m.getX(n1), m.getY(n1)};
        }
        double alt = (double)len * 1.0 / (double)d;
        return new int[]{(int)((double)x2 * alt) + m.getX(n1), (int)((double)y2 * alt) + m.getY(n1)};
    }

    public static int makeEntrance(RescueMap rm, int[] centre) {
        int[][] roads = rm.getRoads();
        int[] min = null;
        int minD = Integer.MAX_VALUE;
        int ind = -1;
        for (int i = 0; i < roads.length; ++i) {
            long dy;
            int[] p = RescueMapToolkit.nearestPoint(rm, centre[0], centre[1], roads[i][0], roads[i][1]);
            long dx = centre[0] - p[0];
            int d = (int)Math.sqrt(dx * dx + (dy = (long)(centre[1] - p[1])) * dy);
            if (minD <= d) continue;
            min = p;
            minD = d;
            ind = i;
        }
        if (min[0] == rm.getX(roads[ind][0]) && min[1] == rm.getY(roads[ind][0])) {
            return roads[ind][0];
        }
        if (min[0] == rm.getX(roads[ind][1]) && min[1] == rm.getY(roads[ind][1])) {
            return roads[ind][1];
        }
        rm.addNode();
        int nodeCount = rm.getNodeCount();
        rm.setX(nodeCount - 1, (int)min[0]);
        rm.setY(nodeCount - 1, (int)min[1]);
        rm.setRoad(roads[ind][0], nodeCount - 1, rm.getRoad(roads[ind][0], roads[ind][1]));
        rm.setRoad(nodeCount - 1, roads[ind][0], rm.getRoad(roads[ind][1], roads[ind][0]));
        rm.setRoad(roads[ind][1], nodeCount - 1, rm.getRoad(roads[ind][1], roads[ind][0]));
        rm.setRoad(nodeCount - 1, roads[ind][1], rm.getRoad(roads[ind][0], roads[ind][1]));
        rm.setRoad(roads[ind][1], roads[ind][0], 0);
        rm.setRoad(roads[ind][0], roads[ind][1], 0);
        return nodeCount - 1;
    }

    public static int[][][] split(int[][] build, int x1, int y1, int x2, int y2) {
        int i;
        int splitA = -1;
        int splitB = -1;
        int[] spA = null;
        int[] spB = null;
        for (int i2 = 0; i2 < build.length - 1; ++i2) {
            int[] coords = RescueMapToolkit.intersectionI(x1, y1, x2, y2, build[i2][0], build[i2][1], build[i2 + 1][0], build[i2 + 1][1]);
            if (coords[0] == -1) continue;
            if (splitA == -1) {
                splitA = i2;
                spA = coords;
                continue;
            }
            if (splitB != -1) continue;
            splitB = i2;
            spB = coords;
            break;
        }
        if (spB == null) {
            return null;
        }
        int[][][] split = new int[][][]{new int[splitB - splitA + 3][2], new int[build.length - (splitB - splitA) + 2][2]};
        int ind = 0;
        for (i = splitA + 1; i <= splitB; ++i) {
            split[0][ind][0] = build[i][0];
            split[0][ind++][1] = build[i][1];
        }
        split[0][split[0].length - 3] = spB;
        split[0][split[0].length - 2] = spA;
        split[0][split[0].length - 1][0] = split[0][0][0];
        split[0][split[0].length - 1][1] = split[0][0][1];
        for (ind = 0; ind <= splitA; ++ind) {
            split[1][ind][0] = build[ind][0];
            split[1][ind][1] = build[ind][1];
        }
        split[1][ind][0] = spA[0];
        split[1][ind++][1] = spA[1];
        split[1][ind][0] = spB[0];
        split[1][ind++][1] = spB[1];
        for (i = splitB + 1; i < build.length; ++i) {
            split[1][ind][0] = build[i][0];
            split[1][ind++][1] = build[i][1];
        }
        return split;
    }

    public static boolean intersects(int x1, int y1, int x2, int y2, int[][] api) {
        for (int i = 0; i < api.length - 1; ++i) {
            int x3 = api[i][0];
            int y3 = api[i][1];
            int x4 = api[i + 1][0];
            int y4 = api[i + 1][1];
            if (RescueMapToolkit.intersection(x1, y1, x2, y2, x3, y3, x4, y4)[0] == -1) continue;
            return true;
        }
        return false;
    }

    private static int[] intersection(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        long d = (long)(y4 - y3) * (long)(x2 - x1) - (long)(x4 - x3) * (long)(y2 - y1);
        if (d == 0L) {
            return new int[]{-1, -1};
        }
        double a = (double)((long)(x4 - x3) * (long)(y1 - y3) - (long)(y4 - y3) * (long)(x1 - x3)) * 1.0 / (double)d;
        int x = x1 + (int)(a * (double)(x2 - x1));
        int y = y1 + (int)(a * (double)(y2 - y1));
        if (x >= Math.min(x1, x2) && x <= Math.max(x1, x2) && x <= Math.max(x3, x4) && x >= Math.min(x3, x4) && y >= Math.min(y1, y2) && y <= Math.max(y1, y2) && y <= Math.max(y3, y4) && y >= Math.min(y3, y4)) {
            return new int[]{x, y};
        }
        return new int[]{-1, -1};
    }

    private static int[] intersectionI(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        long d = (long)(y4 - y3) * (long)(x2 - x1) - (long)(x4 - x3) * (long)(y2 - y1);
        if (d == 0L) {
            return new int[]{-1, -1};
        }
        double a = (double)((long)(x4 - x3) * (long)(y1 - y3) - (long)(y4 - y3) * (long)(x1 - x3)) * 1.0 / (double)d;
        int x = x1 + (int)(a * (double)(x2 - x1));
        int y = y1 + (int)(a * (double)(y2 - y1));
        if (x <= Math.max(x3, x4) && x >= Math.min(x3, x4) && y <= Math.max(y3, y4) && y >= Math.min(y3, y4)) {
            return new int[]{x, y};
        }
        return new int[]{-1, -1};
    }
}

