/*
 * Decompiled with CFR 0.152.
 */
package collapse;

import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class CollapseSimulatorGUI
extends JPanel {
    private JLabel timeLabel = new JLabel("Not started");
    private JLabel statusLabel = new JLabel("Not started");
    private JProgressBar collapseProgress = new JProgressBar(0, 1);
    private JProgressBar fireProgress = new JProgressBar(0, 1);
    private JProgressBar blockadeProgress = new JProgressBar(0, 1);
    private int collapse;
    private int fire;
    private int block;

    public CollapseSimulatorGUI() {
        super(new GridLayout(0, 2));
        this.collapseProgress.setStringPainted(true);
        this.fireProgress.setStringPainted(true);
        this.blockadeProgress.setStringPainted(true);
        this.add(new JLabel("Timestep"));
        this.add(this.timeLabel);
        this.add(new JLabel("Status"));
        this.add(this.statusLabel);
        this.add(new JLabel("Collapsing buildings"));
        this.add(this.collapseProgress);
        this.add(new JLabel("Fire damage"));
        this.add(this.fireProgress);
        this.add(new JLabel("Creating blockades"));
        this.add(this.blockadeProgress);
    }

    void timestep(final int time) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CollapseSimulatorGUI.this.timeLabel.setText(String.valueOf(time));
                CollapseSimulatorGUI.this.collapseProgress.setValue(0);
                CollapseSimulatorGUI.this.fireProgress.setValue(0);
                CollapseSimulatorGUI.this.blockadeProgress.setValue(0);
                CollapseSimulatorGUI.this.collapse = 0;
                CollapseSimulatorGUI.this.fire = 0;
                CollapseSimulatorGUI.this.block = 0;
            }
        });
    }

    void startCollapse(final int buildingCount) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CollapseSimulatorGUI.this.statusLabel.setText("Collapsing buildings");
                CollapseSimulatorGUI.this.collapseProgress.setMaximum(buildingCount);
                CollapseSimulatorGUI.this.collapseProgress.setValue(0);
                CollapseSimulatorGUI.this.collapse = 0;
            }
        });
    }

    void bumpCollapse() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CollapseSimulatorGUI.this.collapseProgress.setValue(++CollapseSimulatorGUI.this.collapse);
            }
        });
    }

    void endCollapse() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CollapseSimulatorGUI.this.collapseProgress.setValue(CollapseSimulatorGUI.this.collapseProgress.getMaximum());
            }
        });
    }

    void startFire(final int buildingCount) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CollapseSimulatorGUI.this.statusLabel.setText("Fire damage");
                CollapseSimulatorGUI.this.fireProgress.setMaximum(buildingCount);
                CollapseSimulatorGUI.this.fireProgress.setValue(0);
                CollapseSimulatorGUI.this.fire = 0;
            }
        });
    }

    void bumpFire() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CollapseSimulatorGUI.this.fireProgress.setValue(++CollapseSimulatorGUI.this.fire);
            }
        });
    }

    void endFire() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CollapseSimulatorGUI.this.fireProgress.setValue(CollapseSimulatorGUI.this.fireProgress.getMaximum());
            }
        });
    }

    void startBlock(final int buildingCount) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CollapseSimulatorGUI.this.statusLabel.setText("Computing blockades");
                if (buildingCount == 0) {
                    CollapseSimulatorGUI.this.blockadeProgress.setMaximum(1);
                    CollapseSimulatorGUI.this.blockadeProgress.setValue(1);
                } else {
                    CollapseSimulatorGUI.this.blockadeProgress.setMaximum(buildingCount);
                    CollapseSimulatorGUI.this.blockadeProgress.setValue(0);
                    CollapseSimulatorGUI.this.block = 0;
                }
            }
        });
    }

    void bumpBlock() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CollapseSimulatorGUI.this.blockadeProgress.setValue(++CollapseSimulatorGUI.this.block);
            }
        });
    }

    void endBlock() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CollapseSimulatorGUI.this.blockadeProgress.setValue(CollapseSimulatorGUI.this.blockadeProgress.getMaximum());
                CollapseSimulatorGUI.this.statusLabel.setText("Done");
            }
        });
    }
}

