/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.messages.components;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rescuecore2.messages.AbstractMessageComponent;
import rescuecore2.misc.EncodingTools;
import rescuecore2.worldmodel.EntityID;

public class EntityIDListComponent
extends AbstractMessageComponent {
    private List<EntityID> ids;

    public EntityIDListComponent(String name) {
        super(name);
        this.ids = new ArrayList<EntityID>();
    }

    public EntityIDListComponent(String name, List<EntityID> ids) {
        super(name);
        this.ids = new ArrayList<EntityID>(ids);
    }

    public List<EntityID> getIDs() {
        return Collections.unmodifiableList(this.ids);
    }

    public void setIDs(List<EntityID> newIDs) {
        this.ids = new ArrayList<EntityID>(newIDs);
    }

    @Override
    public void write(OutputStream out) throws IOException {
        EncodingTools.writeInt32(this.ids.size(), out);
        for (EntityID next : this.ids) {
            EncodingTools.writeInt32(next.getValue(), out);
        }
    }

    @Override
    public void read(InputStream in) throws IOException {
        this.ids.clear();
        int count = EncodingTools.readInt32(in);
        for (int i = 0; i < count; ++i) {
            this.ids.add(new EntityID(EncodingTools.readInt32(in)));
        }
    }

    public String toString() {
        return this.getName() + " = " + this.ids.toString();
    }
}

