/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.misc.geometry;

import rescuecore2.misc.geometry.Vector2D;
import rescuecore2.misc.geometry.spatialindex.Indexable;
import rescuecore2.misc.geometry.spatialindex.PointRegion;
import rescuecore2.misc.geometry.spatialindex.Region;

public class Point2D
implements Indexable {
    private double x;
    private double y;
    private PointRegion region;

    public Point2D(double x, double y) {
        this.x = x;
        this.y = y;
        this.region = null;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public Point2D translate(double dx, double dy) {
        return new Point2D(this.x + dx, this.y + dy);
    }

    public Vector2D minus(Point2D p) {
        return new Vector2D(this.x - p.x, this.y - p.y);
    }

    public Point2D plus(Vector2D v) {
        return new Point2D(this.x + v.getX(), this.y + v.getY());
    }

    public String toString() {
        return this.x + " , " + this.y;
    }

    @Override
    public Region getBoundingRegion() {
        if (this.region == null) {
            this.region = new PointRegion(this.x, this.y);
        }
        return this.region;
    }
}

