/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.misc.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.Property;

public class ChangeSetComponent
extends JPanel {
    private PropertyTableModel propertiesModel = new PropertyTableModel();
    private EntityListModel changedModel = new EntityListModel();
    private EntityListModel deletedModel = new EntityListModel();
    private ChangeSet changes;

    public ChangeSetComponent() {
        super(new BorderLayout());
        JTable propsTable = new JTable(this.propertiesModel);
        final JList changedList = new JList(this.changedModel);
        JList deletedList = new JList(this.deletedModel);
        JScrollPane scroll = new JScrollPane(propsTable);
        scroll.setBorder(BorderFactory.createTitledBorder("Properties"));
        this.add((Component)scroll, "East");
        scroll = new JScrollPane(changedList);
        scroll.setBorder(BorderFactory.createTitledBorder("Changed entities"));
        this.add((Component)scroll, "Center");
        scroll = new JScrollPane(deletedList);
        scroll.setBorder(BorderFactory.createTitledBorder("Deleted entities"));
        this.add((Component)scroll, "West");
        changedList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                EntityID id = (EntityID)changedList.getSelectedValue();
                if (id != null) {
                    Set<Property> changedProperties = ChangeSetComponent.this.changes.getChangedProperties(id);
                    ChangeSetComponent.this.propertiesModel.show(changedProperties);
                }
            }
        });
    }

    public void show(ChangeSet newChanges) {
        this.changes = newChanges;
        this.propertiesModel.show(new HashSet<Property>());
        this.changedModel.show(this.changes.getChangedEntities());
        this.deletedModel.show(this.changes.getDeletedEntities());
    }

    private static class PropertyTableModel
    extends AbstractTableModel {
        private List<Property> properties = new ArrayList<Property>();

        public void show(Set<Property> p) {
            this.properties.clear();
            this.properties.addAll(p);
        }

        @Override
        public int getRowCount() {
            return this.properties.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < 0 || row >= this.properties.size()) {
                throw new IllegalArgumentException("Illegal row: " + row);
            }
            Property p = this.properties.get(row);
            switch (col) {
                case 0: {
                    return p.getURN();
                }
                case 1: {
                    return p.isDefined() ? "undefined" : p.getValue().toString();
                }
            }
            throw new IllegalArgumentException("Illegal column: " + col);
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "URN";
                }
                case 1: {
                    return "Value";
                }
            }
            throw new IllegalArgumentException("Illegal column: " + col);
        }
    }

    private static class EntityListModel
    extends AbstractListModel {
        private List<EntityID> ids = new ArrayList<EntityID>();

        public void show(Set<EntityID> newIDs) {
            this.ids.clear();
            this.ids.addAll(newIDs);
        }

        @Override
        public int getSize() {
            return this.ids.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.ids.get(index);
        }
    }
}

