/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.misc.java;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import rescuecore2.config.Config;
import rescuecore2.log.Logger;
import rescuecore2.misc.java.JavaTools;
import rescuecore2.misc.java.LoadableType;
import rescuecore2.misc.java.LoadableTypeCallback;
import rescuecore2.registry.EntityFactory;
import rescuecore2.registry.MessageFactory;
import rescuecore2.registry.PropertyFactory;
import rescuecore2.registry.Registry;

public class LoadableTypeProcessor {
    private List<LoadableTypeCallback> callbacks = new ArrayList<LoadableTypeCallback>();
    private Set<LoadableType> types = new HashSet<LoadableType>();
    private boolean deep;
    private String dir;
    private Set<String> ignore;

    public LoadableTypeProcessor(Config config) {
        this.deep = config.getBooleanValue("loadabletypes.inspect.deep", true);
        this.dir = config.getValue("loadabletypes.inspect.dir", "../jars");
        this.ignore = new HashSet<String>();
        this.ignore.addAll(config.getArrayValue("loadabletypes.ignore", "rescuecore2.jar"));
    }

    public void addFactoryRegisterCallbacks(Registry registry) {
        this.addCallback(new MessageFactoryRegisterCallback(registry));
        this.addCallback(new EntityFactoryRegisterCallback(registry));
        this.addCallback(new PropertyFactoryRegisterCallback(registry));
    }

    public void addCallback(LoadableTypeCallback callback) {
        this.callbacks.add(callback);
        this.types.addAll(callback.getTypes());
    }

    public void addConfigUpdater(LoadableType type, Config config, String configKey) {
        this.addCallback(new ConfigCallback(type, config, configKey));
    }

    public void setDeepInspection(boolean newDeep) {
        this.deep = newDeep;
    }

    public void setDirectory(String name) {
        this.dir = name;
    }

    public void process() throws IOException {
        File baseDir = new File(this.dir);
        Logger.info("Processing jar directory: " + baseDir.getAbsolutePath());
        File[] jarFiles = baseDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dirName, String name) {
                return name.endsWith(".jar");
            }
        });
        if (jarFiles == null) {
            return;
        }
        for (File next : jarFiles) {
            JarFile jar = new JarFile(next);
            this.processJarFile(jar);
        }
    }

    public void processJarFile(JarFile jar) throws IOException {
        String name = jar.getName();
        String tail = name.substring(name.lastIndexOf("/") + 1);
        if (this.ignore.contains(tail)) {
            return;
        }
        Logger.info("Processing " + jar.getName());
        Manifest mf = jar.getManifest();
        if (mf != null) {
            Logger.debug("Inspecting manifest...");
            for (LoadableType type : this.types) {
                for (String next : type.processManifest(mf)) {
                    this.fireCallback(type, next);
                }
            }
        }
        if (this.deep) {
            Logger.debug("Looking for likely class names...");
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry next = e.nextElement();
                for (LoadableType type : this.types) {
                    String s = type.processJarEntry(next);
                    if (s == null) continue;
                    this.fireCallback(type, s);
                }
            }
        }
    }

    private void fireCallback(LoadableType type, String classname) {
        for (LoadableTypeCallback next : this.callbacks) {
            if (!next.getTypes().contains(type)) continue;
            next.classFound(type, classname);
        }
    }

    public static final class PropertyFactoryRegisterCallback
    implements LoadableTypeCallback {
        private Registry registry;

        private PropertyFactoryRegisterCallback(Registry registry) {
            this.registry = registry;
        }

        @Override
        public void classFound(LoadableType type, String className) {
            PropertyFactory factory = JavaTools.instantiateFactory(className, PropertyFactory.class);
            if (factory != null) {
                this.registry.registerPropertyFactory(factory);
                Logger.info("Registered property factory '" + className + "' with registry " + this.registry.getName());
            }
        }

        @Override
        public Collection<LoadableType> getTypes() {
            return Collections.singleton(LoadableType.PROPERTY_FACTORY);
        }
    }

    public static final class EntityFactoryRegisterCallback
    implements LoadableTypeCallback {
        private Registry registry;

        private EntityFactoryRegisterCallback(Registry registry) {
            this.registry = registry;
        }

        @Override
        public void classFound(LoadableType type, String className) {
            EntityFactory factory = JavaTools.instantiateFactory(className, EntityFactory.class);
            if (factory != null) {
                this.registry.registerEntityFactory(factory);
                Logger.info("Registered entity factory '" + className + "' with registry " + this.registry.getName());
            }
        }

        @Override
        public Collection<LoadableType> getTypes() {
            return Collections.singleton(LoadableType.ENTITY_FACTORY);
        }
    }

    public static final class MessageFactoryRegisterCallback
    implements LoadableTypeCallback {
        private Registry registry;

        private MessageFactoryRegisterCallback(Registry registry) {
            this.registry = registry;
        }

        @Override
        public void classFound(LoadableType type, String className) {
            MessageFactory factory = JavaTools.instantiateFactory(className, MessageFactory.class);
            if (factory != null) {
                this.registry.registerMessageFactory(factory);
                Logger.info("Registered message factory '" + className + "' with registry " + this.registry.getName());
            }
        }

        @Override
        public Collection<LoadableType> getTypes() {
            return Collections.singleton(LoadableType.MESSAGE_FACTORY);
        }
    }

    private static class ConfigCallback
    implements LoadableTypeCallback {
        private LoadableType type;
        private Config config;
        private String key;

        public ConfigCallback(LoadableType type, Config config, String key) {
            this.type = type;
            this.config = config;
            this.key = key;
        }

        @Override
        public void classFound(LoadableType otherType, String className) {
            Logger.info("Adding " + className + " to " + this.key);
            if (this.config.isDefined(this.key)) {
                List<String> existing = this.config.getArrayValue(this.key);
                if (!existing.contains(className)) {
                    this.config.appendValue(this.key, className);
                }
            } else {
                this.config.setValue(this.key, className);
            }
        }

        @Override
        public Collection<LoadableType> getTypes() {
            return Collections.singleton(this.type);
        }
    }
}

