/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.worldmodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import rescuecore2.misc.EncodingTools;
import rescuecore2.worldmodel.AbstractProperty;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.EntityListener;
import rescuecore2.worldmodel.Property;

public abstract class AbstractEntity
implements Entity {
    private final EntityID id;
    private final Set<EntityListener> listeners;
    private final Set<Property> properties;

    protected AbstractEntity(EntityID id) {
        this.id = id;
        this.listeners = new HashSet<EntityListener>();
        this.properties = new HashSet<Property>();
    }

    protected AbstractEntity(AbstractEntity other) {
        this(other.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEntityListener(EntityListener l) {
        Set<EntityListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEntityListener(EntityListener l) {
        Set<EntityListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    @Override
    public Entity copy() {
        Entity result = this.copyImpl();
        for (Property original : this.getProperties()) {
            Property copy = result.getProperty(original.getURN());
            copy.takeValue(original);
        }
        return result;
    }

    protected abstract Entity copyImpl();

    @Override
    public final Set<Property> getProperties() {
        return this.properties;
    }

    @Override
    public Property getProperty(String propertyURN) {
        return null;
    }

    @Override
    public EntityID getID() {
        return this.id;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        int count = 0;
        for (Property next : this.getProperties()) {
            if (!next.isDefined()) continue;
            ++count;
        }
        EncodingTools.writeInt32(count, out);
        for (Property next : this.getProperties()) {
            if (!next.isDefined()) continue;
            EncodingTools.writeProperty(next, out);
        }
    }

    @Override
    public void read(InputStream in) throws IOException {
        int count = EncodingTools.readInt32(in);
        for (int i = 0; i < count; ++i) {
            Property prop = EncodingTools.readProperty(in);
            if (prop == null) continue;
            Property existing = this.getProperty(prop.getURN());
            existing.takeValue(prop);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getEntityName());
        result.append(" (");
        result.append(this.id);
        result.append(")");
        return result.toString();
    }

    public String getFullDescription() {
        String urn;
        StringBuilder result = new StringBuilder();
        String name = this.getEntityName();
        if (!name.equals(urn = this.getURN())) {
            result.append(name);
            result.append(" [");
            result.append(urn);
            result.append("]");
        } else {
            result.append(name);
        }
        result.append(" (");
        result.append(this.id);
        result.append(") [");
        Iterator<Property> it = this.getProperties().iterator();
        while (it.hasNext()) {
            result.append(it.next().toString());
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        result.append("]");
        return result.toString();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractEntity) {
            AbstractEntity a = (AbstractEntity)o;
            return this.id.equals(a.id);
        }
        return false;
    }

    protected String getEntityName() {
        return this.getURN();
    }

    protected void registerProperties(Property ... props) {
        for (Property p : props) {
            this.properties.add(p);
            if (!(p instanceof AbstractProperty)) continue;
            ((AbstractProperty)p).setEntity(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePropertyChanged(Property p, Object oldValue, Object newValue) {
        HashSet<EntityListener> copy;
        Set<EntityListener> set = this.listeners;
        synchronized (set) {
            copy = new HashSet<EntityListener>(this.listeners);
        }
        for (EntityListener next : copy) {
            next.propertyChanged(this, p, oldValue, newValue);
        }
    }
}

