/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.worldmodel.properties;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import rescuecore2.misc.EncodingTools;
import rescuecore2.worldmodel.AbstractProperty;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.Property;

public class EntityRefProperty
extends AbstractProperty {
    private EntityID value;

    public EntityRefProperty(String urn) {
        super(urn);
    }

    public EntityRefProperty(Enum<?> urn) {
        super(urn);
    }

    public EntityRefProperty(String urn, EntityID value) {
        super(urn, true);
        this.value = value;
    }

    public EntityRefProperty(Enum<?> urn, EntityID value) {
        super(urn, true);
        this.value = value;
    }

    public EntityRefProperty(EntityRefProperty other) {
        super(other);
        this.value = other.value;
    }

    @Override
    public EntityID getValue() {
        if (!this.isDefined()) {
            return null;
        }
        return this.value;
    }

    public void setValue(EntityID value) {
        EntityID old = this.value;
        boolean wasDefined = this.isDefined();
        this.value = value;
        this.setDefined();
        if (!wasDefined || !old.equals(value)) {
            this.fireChange(old, value);
        }
    }

    @Override
    public void takeValue(Property p) {
        if (p instanceof EntityRefProperty) {
            EntityRefProperty e = (EntityRefProperty)p;
            if (e.isDefined()) {
                this.setValue(e.getValue());
            } else {
                this.undefine();
            }
        } else {
            throw new IllegalArgumentException(this + " cannot take value from " + p);
        }
    }

    @Override
    public void write(OutputStream out) throws IOException {
        EncodingTools.writeInt32(this.value.getValue(), out);
    }

    @Override
    public void read(InputStream in) throws IOException {
        this.setValue(new EntityID(EncodingTools.readInt32(in)));
    }

    @Override
    public EntityRefProperty copy() {
        return new EntityRefProperty(this);
    }
}

