package org.util.xml;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.io.*;
import java.net.*;
import javax.swing.*;
import javax.swing.event.*;

import org.util.xml.element.*;
import org.util.xml.parse.*;
import org.util.xml.parse.policy.*;
//import org.util.xml.renderer.html.*;
import org.util.html.objects.*;

import static org.gui.GUITool.alert;
import static org.gui.GUITool.showFrame;

/**
 *
 * @author masaru
 */
public class Main6 {
    
    private JPanel panel_;
    private JTextArea text_area_;
    private String doctype_;
    private JTextField text_;

    private ParserPolicy keep_all_parser_;
    private ParserPolicy body_tag_parser_;
    private ParserPolicy html_tag_parser_;
    private ParserPolicy html_document_parser_;



    public static void main(String[] args) throws Exception {

	final Main6 main = new Main6();
	main.start();
	//	main.openInOtherThread("http://sakura.meijo-u.ac.jp/index.html");
	//main.openInOtherThread("http://sakura.meijo-u.ac.jp/~tatsunootoshigo2008/");
    }

    public Main6() {
	
    }

    public void start() throws Exception {
	//org.gui.GUITool.tryToSetSystemLookAndFeel();

	SwingUtilities.invokeAndWait(new Runnable(){public void run() {
	    text_ = new JTextField();
	    text_.addActionListener(new ActionListener(){
		    public void actionPerformed(ActionEvent e) {
			String url_text = text_.getText();
			openInOtherThread(url_text);
		    }
		});

	    JPanel menu = new JPanel();
	    menu.setLayout(new BoxLayout(menu, BoxLayout.X_AXIS));
	    menu.setPreferredSize(new Dimension(500, 30));
	    menu.add(text_);
	    
	    JPanel contentpane = new JPanel(new BorderLayout());
	    contentpane.setPreferredSize(new Dimension(500, 400));
	    //text_area_ = new JTextArea();
	    //contentpane.add(new JScrollPane(text_area_), BorderLayout.CENTER);
	    panel_ = new JPanel();
	    panel_.setLayout(new BoxLayout(panel_, BoxLayout.Y_AXIS));
	    //panel_.setPreferredSize(new Dimension(500, 400));
	    contentpane.add(menu, BorderLayout.NORTH);
	    contentpane.add(new JScrollPane(panel_), BorderLayout.CENTER);
	    showFrame(contentpane, JFrame.EXIT_ON_CLOSE);
	}});


	
	keep_all_parser_ = new HTMLParserPolicy() {
		@Override
		public boolean throwExceptionIfDocumentHasError() {
		    return false;
		}
		public ParserPolicy getInnerPolicy(Element element) {
		    return this;
		}
		public Element allowElement(Element element) {
		    return element;
		}
	    };


	body_tag_parser_ = new HTMLParserPolicy() {
		@Override
		public boolean throwExceptionIfDocumentHasError() {
		    return false;
		}
		public ParserPolicy getInnerPolicy(Element element) {
		    TagElement tag = (TagElement)element;
		    /*
		    if(tag.getKey().toLowerCase().equals("html"))
			return html_tag_parser;
		    */
		    return this;
		}
		public Element allowElement(Element element) {
		    //panel_.add(new JButton(element.toString()));
		    if(!element.isTagElement()) {
			HTMLText text = new HTMLText(root_);
			text.setText(((TextElement)element).getValue());
			panel_.add(text.getPanel());
		    }else{
			TagElement tag = (TagElement)element;
			String key = tag.getKey().toLowerCase();
			if(key.equals("a")) {

			}else if(key.equals("img")) {
			    try{
				HTMLImg img = new HTMLImg(root_);
				img.setURL(root_.getDocumentBase().toURI().resolve(tag.getAttributeValue("src", "")).toURL());
				panel_.add(img.getPanel());
			    }catch(Exception e) {e.printStackTrace();}
			}else{
			    JLabel label = new JLabel("<html>"+tag.toString()+"</html>");
			    label.setBorder(BorderFactory.createLineBorder(Color.blue));
			    label.setToolTipText(tag.toString());
			    panel_.add(label);
			}
		    }
		    panel_.revalidate();
		    return null;
		}
	    };



	html_tag_parser_ = new HTMLParserPolicy() {
		@Override
		public boolean throwExceptionIfDocumentHasError() {
		    return false;
		}
		public ParserPolicy getInnerPolicy(Element element) {
		    if(!element.isTagElement()) return keep_all_parser_;
		    TagElement tag = ((TagElement)element);
		    if(tag.getKey().toLowerCase().equals("body"))
			return body_tag_parser_;
		    return keep_all_parser_;
		}
		public Element allowElement(Element element) {
		    //panel_.add(new JButton(element.toString()));
		    return element;
		}
	    };

	html_document_parser_ = new HTMLParserPolicy() {
		@Override
		public boolean throwExceptionIfDocumentHasError() {
		    return false;
		}
		public String selectEncoding(String last_tag_key) {
		    return "utf-8";
		}
		public ParserPolicy getInnerPolicy(Element element) {
		    TagElement tag = (TagElement)element;
		    if(tag.getKey().toLowerCase().equals("html"))
			return html_tag_parser_;
		    return keep_all_parser_;
		}
		public Element allowElement(Element element) {
		    if(element.isTextElement()) {
			TextElement text_tag = (TextElement)element;
			String text = text_tag.getValue();
			if(text.toLowerCase().startsWith("doctype")) {
			    doctype_ = text;
			    return null;
			}
		    }
		    return null;
		}
	    };


    }

    public void openInOtherThread(final String url_text) {
	new Thread(new Runnable(){public void run(){
	    try{
		open(url_text);
	    }catch(Exception e){e.printStackTrace();}
	}}, "open url").start();
    }
    
    HTMLDocument root_ = new HTMLDocument();

    public void open(String url_text) throws Exception {
	panel_.removeAll();

	URL url = new URL(url_text);
	root_.setDocumentBase(url);

	ElementParser parser;
	/*
	  parser= new ElementParser(url.openStream());
	  Element[] all = parser.parse();
	for(Element a : all)
	    panel_.add(new JLabel(a.toString()));
	panel_.revalidate();

	alert("now starting parse");
	*/
	parser = new ElementParser(url.openStream());
	parser.setDocumentBase(url.toURI());

	parser.setPolicy(html_document_parser_);
	parser.parse();

	panel_.revalidate();
    }








}
