package org.util.xml.renderer.html;

import org.util.xml.parse.policy.*;
import org.util.xml.parse.*;
import org.util.xml.element.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.*;
import java.awt.font.*;
import java.awt.image.*;

public class HTMLObject implements ParserPolicy {
    
    protected boolean init_ = false;
    private boolean changed_view_ = true;
    private boolean changed_layout_ = true;
    protected double preferred_width_ = 100;
    protected double preferred_height_ = 100;
    protected double preferred_x_ = 100;
    protected double preferred_y_ = 100;
    protected double offset_x_ = 0;
    protected double offset_y_ = 0;
    protected boolean preferred_location_ = false;
    protected double width_ = 100;
    protected double height_ = 100;
    protected double x_ = 100;
    protected double y_ = 100;
    protected Color background_ = Color.white;
    protected Color foreground_ = Color.black;
    public boolean is_mouse_over_;
    private ArrayList<ChangeListener> listener_list_ = new ArrayList<ChangeListener>();
    private ArrayList<HTMLObject> html_object_list_ = new ArrayList<HTMLObject>();
    protected double write_point_x_ = 0;
    protected double write_point_y_ = 0;
    protected double margin_up_ = 1;
    protected double margin_bottom_ = 1;
    protected double margin_right_ = 5;
    protected double margin_left_ = 5;
    //	private ArrayList<HTMLObject> children_ = new ArrayList<HTMLObject>();
    private BufferedImage buf_;
    protected String html_text = "";
    protected double now_y_ = 0;
    
    public Rectangle2D rect_;
    
    public HTMLObject() {
    }
    public static void alert(Object message) {
	alert(null, message);
    }
    public static void alert(JComponent parent, Object message) {
	JOptionPane.showMessageDialog(parent, message);
    }
    public boolean hit(double x, double y) {
	/*
	  System.out.println(x_+","+y_+","+width_+","+height_);
	  System.out.println(x+"x"+y);
	  if(x-x_<0 || x-x_>width_) return false;
	  if(y-y_<0 || y-y_>height_) return false;
	*/
	return true;
    }
    
    public void addChangeListener(ChangeListener listener) {
	listener_list_.add(listener);
    }
    public void fireChanged() {
	ChangeEvent event = new ChangeEvent(this);
	for(int i=0;i<listener_list_.size();i++)
	    listener_list_.get(i).stateChanged(event);
    }
    
    private Thread test_thread = null;
    public void mousePressed(MouseEvent e) {
	/*		
			if(false)
			if(test_thread == null) {
			final double[] c = new double[1];
			test_thread = new Thread(new Runnable(){
			public void run() {
			while(true) {
			try{Thread.sleep(10);}catch(Exception e){}
			long time = System.currentTimeMillis();
			c[0] = (double)time/1000;
			setPreferredLocation(100+50*Math.cos(c[0]), 100+50*Math.sin(c[0]));
			}
			}
			});
			test_thread.start();
			}
	*/
	int x = e.getX();
	int y = e.getY();
	for(int i=0;i<html_object_list_.size();i++) {
	    HTMLObject htmlo = html_object_list_.get(i);
	    if(htmlo.hit(x, y))
		htmlo.mousePressed(e);
	}
	setBackground(Color.blue);
    }
    
    public void mouseReleased(MouseEvent e) {
	int x = e.getX();
	int y = e.getY();
	for(int i=0;i<html_object_list_.size();i++) {
	    HTMLObject htmlo = html_object_list_.get(i);
	    if(htmlo.hit(x, y))
		htmlo.mouseReleased(e);
	}
	setBackground(Color.red);
    }
    public void mouseClicked(MouseEvent e) {
    }
    public void mouseEntered(MouseEvent e) {
	setBackground(Color.red);
    }
    public void mouseExited(MouseEvent e) {
	setBackground(Color.white);
    }
    int count = 0;
    public void mouseMoved(MouseEvent e) {
	for(int i=0;i<html_object_list_.size();i++) {
	    HTMLObject htmlo = html_object_list_.get(i);
	    if(htmlo.hit(e.getX(), e.getY())) {
		htmlo.mouseMoved(e);
		if(!htmlo.is_mouse_over_) {
		    htmlo.is_mouse_over_ = true;
		    htmlo.mouseEntered(e);
		}
	    } else {
		if(htmlo.is_mouse_over_) {
		    htmlo.is_mouse_over_ = false;
		    htmlo.mouseExited(e);
		}
	    }
	}
    }
    public void mouseWheelMoved(MouseWheelEvent e) {
	offset_y_ -= 30*e.getWheelRotation();
	fireChanged();
    }
    public void mouseDragged(MouseEvent e) {}
    
    public void setBackground(Color background) {
	background_ = background;
	changed_view_ = true;
	fireChanged();
    }
    public void setForeground(Color foreground) {
	foreground_ = foreground;
    }
    public void setPreferredSize(double width, double height) {
	preferred_width_ = width;
	preferred_height_ = height;
	fireChanged();
    }
    public void setPreferredLocation(double x, double y) {
	preferred_x_ = x;
	preferred_y_ = y;
	fireChanged();
    }
    public double getPreferredWidth() {
	return preferred_width_;
    }
    public double getPreferredHeight() {
	return preferred_height_;
    }
    public double getPreferredX() {
	return preferred_x_;
    }
    public double getPreferredY() {
	return preferred_y_;
    }
    public double getX() {
	return x_;
    }
    public double getY() {
	return y_;
    }
    public double getWidth() {
	return width_;
    }
    public double getHeight() {
	return height_;
    }
    public void setLocation(double x, double y) {
	x_ = x;
	y_ = y;
    }
    public void setSize(double width, double height) {
	width_ = width;
	height_ = height;
    }
    
    private int paint_count_ = 0;
    public void paint(final Graphics g) {
	debug("paint method start"+(paint_count_++));
	if(buf_ == null) {
	    g.drawString("now rendering...", 10, 15);
	}
	if(changed_view_ || changed_layout_) {
	    //			new Thread(new Runnable(){public void run(){
	    debug("thread start");
	    doLayout();
	    doRenderer();
	    for(int i=0;i<html_object_list_.size();i++) {
		HTMLObject htmlo = html_object_list_.get(i);
	htmlo.paint(g);
	    }
	    //				g.drawImage(buf_, (int)x_, (int)y_, null);
	    debug("thread end");
	    //			}}).start();
	} else {
	    debug("copy start");
	    g.drawImage(buf_, (int)x_, (int)y_, null);
	    debug("copy end");
	}
	debug("paint method end");
    }
    public void doLayout() {
	now_y_ = offset_y_;
	for(int i=0;i<html_object_list_.size();i++) {
	    HTMLObject htmlo = html_object_list_.get(i);
	    double x = htmlo.getPreferredX();
	    double y = htmlo.getPreferredY();
	    double w = htmlo.getPreferredWidth();
	    double h = htmlo.getPreferredHeight();
	    htmlo.setSize(w, h);
	    if(htmlo.preferred_location_) {
		htmlo.setLocation(x, y);
	    } else {
		//			System.out.println("tset");
		htmlo.setLocation(0, now_y_);
		now_y_ += htmlo.getHeight();
	    }
	}
	//		changed_layout_ = false;
    }
    public void doRenderer() {
	if(changed_view_) {
	    debug("rendering start");
	    clearTmpImage();
	    Graphics g = tmp_image_.getGraphics();
	    draw(g);
	    buf_ = tmp_image_.getSubimage((int)x_, (int)y_, (int)preferred_width_, (int)preferred_height_);
	    debug("rendering end");
	}
	changed_view_ = false;
    }
    public void write(HTMLObject html_object) {
	html_object_list_.add(html_object);
    }
    private static void clearTmpImage() {
	for(int i=0;i<tmp_image_.getHeight();i++)
	    for(int j=0;j<tmp_image_.getWidth();j++)
		tmp_image_.setRGB(i, j, 0x00000000);
    }
    private static BufferedImage tmp_image_ = new BufferedImage(500, 500, BufferedImage.TYPE_INT_ARGB);
    public void draw(Graphics g) {
	debug("draw start");
	for(int i=0;i<html_object_list_.size();i++) {
	    HTMLObject htmlo = html_object_list_.get(i);
	    htmlo.paint(g);
	}
	
	//g.drawRect((int)(rect.getX()+x_),(int)(rect.getY()+y_+d),(int)rect.getWidth(),(int)rect.getHeight());
	g.drawRect((int)x_,(int)(y_),(int)(width_-1),(int)(height_-1));
	debug("draw end");
    }
    
    public void debug(String message) {
	//System.out.println(message);
    }






    public boolean throwExceptionIfDocumentHasError() {
	return false;
    }
    public boolean checkEndTag() {
	return false;
    }
    public ParserPolicy getInnerPolicy(Element element) {
	
	return this;
    }
    public String selectEncoding(String last_tag_key) {
	return "shift-jis";//"utf-8";
    }
    public boolean forceEmptyTag(String key) {
	return false;
    }
    public Element startElement(Element element) {
	return element;
    }
    @Override public boolean finished() {
	return false;
    }
    public Element allowElement(Element element) {
	
	if(element.isTagElement()) {
	    TagElement tag = (TagElement)element;
	    if(tag.getKey().equals("img")) {
		HTMLImage hi = new HTMLImage(tag);
		write(hi);
		//				alert("image");
	    } else if(tag.getKey().equals("script")) {
		//				alert(tag.getValue());
		return null;
	    } else if(tag.getKey().equals("link")) {
		//				alert(tag.getValue());
		return null;
	    } else {
		System.out.println("skip tag["+tag.getKey()+"]");
	    }
	} else {
	    TextElement text_element = (TextElement)element;
	    //			System.out.println("text["+element+"]");
	    HTMLText ht = new HTMLText(text_element.getValue());
	    ht.addChangeListener(new ChangeListener(){
		    public void stateChanged(ChangeEvent e){
			fireChanged();
		    }
		});
	    write(ht);
	    return null;
	}
	return element;
    }
}
