﻿//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		Program.cs
 * @brief		Main ファイル
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2013-2014 Takazumi Shirayanagi\n
 * This software is released under the MIT License,
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================


using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace rcsharp
{
	class Program
	{
		/// <summary>
		/// アプリケーションのメイン エントリ ポイントです。
		/// </summary>
		[STAThread]
		static void Main()
		{
			Application.EnableVisualStyles();
			Application.SetCompatibleTextRenderingDefault(false);

            Form2Res ftr = new Form2Res();
			string directory = null;
			string resheader = null;
			string[] args = Environment.GetCommandLineArgs();
			List<string> args2 = new List<string>();
			int IDD = 100;
			int IDC = 1000;
			int IDS = 10000;
			int IDM = 6000;
			#region Parse
			for (int i = 1; i < args.Length; ++i)
			{
				bool option = args[i].IndexOf('-') == 0;
				if (option)
				{
					string value = null;
					#region output_directory
					if ( ParseOption(args[i], "-o", ref value) )
					{
						directory = value;
						if (directory == null || directory.Length == 0)
						{
							if (i < args.Length - 1)
							{
								directory = args[i + 1];
								++i;
							}
						}
						if (directory[0] == '\"')
						{
							directory = directory.Substring(1, directory.Length - 2);
						}
						continue;
					}
					#endregion

					#region resource.h filename
					if (ParseOption(args[i], "-rh", ref value))
					{
						resheader = value;
						if (resheader == null || resheader.Length == 0)
						{
							if (i < args.Length - 1)
							{
								resheader = args[i + 1];
								++i;
							}
						}
						continue;
					}
					#endregion

					#region IDD
					if (ParseOption(args[i], "-idd", ref value))
					{
						if (value == null || value.Length == 0)
						{
							if (i < args.Length - 1)
							{
								value = args[i + 1];
								++i;
							}
						}
						try
						{
							IDD = Int32.Parse(value);
						}
						catch
						{
						}
						continue;
					}
					#endregion
					#region IDC
					if (ParseOption(args[i], "-idc", ref value))
					{
						if (value == null || value.Length == 0)
						{
							if (i < args.Length - 1)
							{
								value = args[i + 1];
								++i;
							}
						}
						try
						{
							IDC = Int32.Parse(value);
						}
						catch
						{
						}
						continue;
					}
					#endregion
					#region IDS
					if (ParseOption(args[i], "-ids", ref value))
					{
						if (value == null || value.Length == 0)
						{
							if (i < args.Length - 1)
							{
								value = args[i + 1];
								++i;
							}
						}
						try
						{
							IDS = Int32.Parse(value);
						}
						catch
						{
						}
						continue;
					}
					#endregion
					#region IDM
					if (ParseOption(args[i], "-idm", ref value))
					{
						if (value == null || value.Length == 0)
						{
							if (i < args.Length - 1)
							{
								value = args[i + 1];
								++i;
							}
						}
						try
						{
							IDM = Int32.Parse(value);
						}
						catch
						{
						}
						continue;
					}
					#endregion
				}
				args2.Add(args[i]);
			}
			#endregion

			CSResID resIDs = new CSResID(IDD, IDC, IDS, IDM);

			if ( directory != null && !System.IO.Directory.Exists(directory))
			{
				System.IO.Directory.CreateDirectory(directory);
			}

			if (args2.Count == 0)
			{
				Console.WriteLine("options");
				Console.WriteLine("-o<output_directory>    : Specifies the output directory.");
				Console.WriteLine("-rh<filename>           : Specifies the output resource.h filename.");
				Console.WriteLine("-idd<number>            : First IDD(IDR, IDI, IDB) Number.");
				Console.WriteLine("-idc<number>            : First IDC Number.");
				Console.WriteLine("-ids<number>            : First IDS Number.");
				Console.WriteLine("-idm<number>            : First IDM Number.");
			}
			else
			{
				if (resheader != null && args2.Count > 1)
				{
					Console.WriteLine("During the conversion of multiple files can be specified. -rh<filename>");
				}
				for (int i = 0; i < args2.Count; ++i)
				{
					ftr.Convert(args2[i], resIDs, directory, resheader);
				}
			}
		}

		public static bool ParseOption(string arg, string option, ref string value)
		{
			if (arg.IndexOf(option) != 0) return false;
			int index = option.Length;
			if (arg.IndexOf('=') == index) ++index;
			value = arg.Substring(index);
			return true;
		}
	}
}
