/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.server.messaging;

/**
 * <p>[概 要]</p>
 * メッセージ受信基底クラス。
 * 
 * <p>[詳 細]</p>
 * メッセージ受信における基本インターフェースを提供します。
 * 
 * <p>[備 考]</p>
 *
 * @author Project Reffi
 */
abstract public class AbstractMessageReceiver {
	/**
	 * <p>[概 要]</p>
	 * メッセージ受信開始。
	 * <p>[詳 細]</p>
	 * <p>[備 考]</p>
	 *
	 */
	abstract public void start(String topic);
	
	/**
	 * <p>[概 要]</p>
	 * メッセージ受信初期処理。
	 * <p>[詳 細]</p>
	 * クライアントからメッセージを受信する都度にて初期処理を実行します。
	 * <p>[備 考]</p>
	 * 必要な場合のみ実装をしてください。
	 */
	protected void handleInitialize() {

	}

	/**
	 * <p>[概 要]</p>
	 * メッセージ受信終了処理。
	 * <p>[詳 細]</p>
	 * クライアントからメッセージを受信する都度にて終了処理を実行します。
	 * <p>[備 考]</p>
	 * 必要な場合のみ実装をしてください。
	 */
	protected void handleFinalize() {

	}

	/**
	 * <p>[概 要]</p>
	 * バリデーション実行処理。
	 * <p>[詳 細]</p>
	 * クライアントからメッセージを受信する都度にてバリデーション処理を実行します。
	 * <p>[備 考]</p>
	 * 必要な場合のみ実装をしてください。
	 * 
	 * @return バリデーション実行結果
	 */
	protected boolean validate() {
		return true;
	}

	/**
	 * <p>[概 要]</p>
	 * エラーハンドリング処理。
	 * <p>[詳 細]</p>
	 * onMessageメソッドにて発生したエラーをハンドリングします。
	 * <p>[備 考]</p>

	 * @param e onMessageメソッド内で発生した実行時例外インスタンス
	 */
	protected void trap(Exception e) {
		e.printStackTrace();
	}

}
