/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * 5. All your rights under this license shall terminate automatically if you fail to
 *    comply  with any of this list of conditions. If your rights under this license terminate,
 *    you agree to cease use and distribution of this software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.flex.validator {
	
	import flash.display.DisplayObject;
	
	/**
	 * <p>[概 要]</p>
	 * 1バリデーションエラーの情報を保持するクラスです.
	 * 
	 * <p>[詳 細]</p>
	 * バリデーションエラー発生時の以下の情報を保持します。
	 * <ul>
	 *   <li>エラーを起こしたコンポーネントの名前</li>
	 *   <li>エラーメッセージ</li>
	 *   <li>エラーを起こしたコンポーネント</li>
	 *   <li>ValidationResult配列（ValidationResultEvent#results）</li>
	 * </ul>
	 * 
	 * <p>[備 考]</p>
	 * 
	 * <p>Copyright (c) 2008-2009 FUJITSU Japan All rights reserved.</p>
	 * 
	 * @see jp.co.fujitsu.reffi.client.flex.validator.ValidateErrors
	 * @author Project Reffi 
	 */
	public class ValidateError {
		
		// エラーを起こしたコンポーネントの名前
		private var _errorSourceName:String;
		
		// エラーメッセージ
		private var _message:String;
		
		// エラーを起こしたコンポーネント
		private var _errorSourceObject:Object;
		
		// ValidationResult配列（ValidationResultEvent#results）
		private var _results:Array;
		

		/**
		 * <p>[概 要]</p>
		 * エラーを起こしたコンポーネントの名前です.
		 * 
		 * <p>[詳 細]</p>
		 * エラーを起こしたコンポーネントのname属性値が保持されます。
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function get errorSourceName():String {
			return this._errorSourceName;
		}
		public function set errorSourceName(errorSourceName:String):void {
			this._errorSourceName = errorSourceName;
		} 
		
		/**
		 * <p>[概 要]</p>
		 * バリデーションエラーに対応するエラーメッセージです.
		 * 
		 * <p>[詳 細]</p>
		 * ValidationResultオブジェクトが保持するerrorMessageと等価です。
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function get message():String {
			return this._message;
		}
		public function set message(message:String):void {
			this._message = message;
		}
		
		/**
		 * <p>[概 要]</p>
		 * バリデーションエラーを発生させたオブジェクトです.
		 * 
		 * <p>[詳 細]</p>
		 * Validator#sourceと等価です。
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function get errorSourceObject():Object {
			return this._errorSourceObject;
		}
		public function set errorSourceObject(errorSourceObject:Object):void {
			this._errorSourceObject = errorSourceObject;
		} 
		
		/**
		 * <p>[概 要]</p>
		 * ValidationResult配列です.
		 * 
		 * <p>[詳 細]</p>
		 * ValidationResultEvent#resultsと等価です。
		 * 
		 * <p>[備 考]</p>
		 * 
		 */
		public function get results():Array {
			return this._results;
		}
		public function set results(results:Array):void {
			this._results = results;
		}
		
		/**
		 * <p>[概 要]</p>
		 * コンストラクタです.
		 * 
		 * <p>[詳 細]</p>
		 * このオブジェクトの初期化を行います。
		 * 
		 * <p>[備 考]</p>
		 * 
		 * @param errorSourceName エラーを発生させたコンポーネントのname属性値
		 * @param messge エラーメッセージ
		 * @param errorSourceObject エラーを発生させたコンポーネントインスタンス
		 * @param results ValidationResult配列
		 */
		public function ValidateError(errorSourceName:String, 
										message:String, 
										errorSourceObject:Object, 
										results:Array) 
		{
			this._errorSourceName = errorSourceName;
			this._message = message;
			this._errorSourceObject = errorSourceObject;
			this._results = results;
		}
	}
}
