/*
 * Copyright (c) 2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * 5. All your rights under this license shall terminate automatically if you fail to
 *    comply  with any of this list of conditions. If your rights under this license terminate,
 *    you agree to cease use and distribution of this software.
 * 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.swing.controller;

import java.awt.Color;
import java.util.Hashtable;

public class ClientConfig {

	/**  */
	private Hashtable<String, String> defaultJmsEnvironment;
	
	/**  */
	private Hashtable<String, String> defaultEjbEnvironment;
	
	/**  */
	private Hashtable<String, String> defaultDatabaseEnvironment;
	
	/**  */
	private Hashtable<String, String> defaultHttpEnvironment;

	/**  */
	private boolean autoWindowDispose = true;
	
	/**  */
	private boolean showErrorDialogOnExceptionTrap = true;
	
	private boolean printStackTraceOnExceptionTrap = true;
	
	/**  */
	private String unexpectedErrorDialogTitle = "Error";
	
	/**  */
	private String unexpectedErrorDialogMessage = "unexpected error occured";
	
	/**  */
	private boolean enableValidationFaultProcessing = true;
	
	/**  */
	private Color componentColorOnValidationFault = Color.YELLOW;
	
	/**  */
	private boolean componentColorChangeOnValidationFault = true;

	/**  */
	private boolean componentTipChangeOnValidationFault = true;
	
	private boolean duplicateActionInvoke = false;
	
	
	
	/**
	 * 
	 * @return
	 */
	public Hashtable<String, String> getDefaultJmsEnvironment() {
		return defaultJmsEnvironment;
	}

	/**
	 * 
	 * @param defaultJmsEnvironment
	 */
	public void setDefaultJmsEnvironment(Hashtable<String, String> defaultJmsEnvironment) {
		this.defaultJmsEnvironment = defaultJmsEnvironment;
	}

	/**
	 * 
	 * @return
	 */
	public Hashtable<String, String> getDefaultEjbEnvironment() {
		return defaultEjbEnvironment;
	}

	/**
	 * 
	 * @param defaultEjbEnvironment
	 */
	public void setDefaultEjbEnvironment(Hashtable<String, String> defaultEjbEnvironment) {
		this.defaultEjbEnvironment = defaultEjbEnvironment;
	}

	/**
	 * 
	 * @return
	 */
	public Hashtable<String, String> getDefaultDatabaseEnvironment() {
		return defaultDatabaseEnvironment;
	}

	/**
	 * 
	 * @param defaultDatabaseEnvironment
	 */
	public void setDefaultDatabaseEnvironment(
			Hashtable<String, String> defaultDatabaseEnvironment) {
		this.defaultDatabaseEnvironment = defaultDatabaseEnvironment;
	}
	
	/**
	 * 
	 * @return
	 */
	public Hashtable<String, String> getDefaultHttpEnvironment() {
		return defaultHttpEnvironment;
	}

	/**
	 * 
	 * @param defaultHttpEnvironment
	 */
	public void setDefaultHttpEnvironment(
			Hashtable<String, String> defaultHttpEnvironment) {
		this.defaultHttpEnvironment = defaultHttpEnvironment;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isAutoWindowDispose() {
		return autoWindowDispose;
	}

	/**
	 * 
	 * @param autoWindowDispose
	 */
	public void setAutoWindowDispose(boolean autoWindowDispose) {
		this.autoWindowDispose = autoWindowDispose;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isShowErrorDialogOnExceptionTrap() {
		return showErrorDialogOnExceptionTrap;
	}

	/**
	 * 
	 * @param showErrorDialogOnExceptionTrap
	 */
	public void setShowErrorDialogOnExceptionTrap(
			boolean showErrorDialogOnExceptionTrap) {
		this.showErrorDialogOnExceptionTrap = showErrorDialogOnExceptionTrap;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isPrintStackTraceOnExceptionTrap() {
		return printStackTraceOnExceptionTrap;
	}

	/**
	 * 
	 * @param printStackTraceOnExceptionTrap
	 */
	public void setPrintStackTraceOnExceptionTrap(
			boolean printStackTraceOnExceptionTrap) {
		this.printStackTraceOnExceptionTrap = printStackTraceOnExceptionTrap;
	}

	/**
	 * 
	 * @return
	 */
	public String getUnexpectedErrorDialogTitle() {
		return unexpectedErrorDialogTitle;
	}

	/**
	 * 
	 * @param unexpectedErrorDialogTitle
	 */
	public void setUnexpectedErrorDialogTitle(String unexpectedErrorDialogTitle) {
		this.unexpectedErrorDialogTitle = unexpectedErrorDialogTitle;
	}

	/**
	 * 
	 * @return
	 */
	public String getUnexpectedErrorDialogMessage() {
		return unexpectedErrorDialogMessage;
	}

	/**
	 * 
	 * @param unexpectedErrorDialogMessage
	 */
	public void setUnexpectedErrorDialogMessage(String unexpectedErrorDialogMessage) {
		this.unexpectedErrorDialogMessage = unexpectedErrorDialogMessage;
	}

	/**
	 * 
	 * @return
	 */
	public Color getComponentColorOnValidationFault() {
		return componentColorOnValidationFault;
	}

	/**
	 * 
	 * @param componentColorOnValidationFault
	 */
	public void setComponentColorOnValidationFault(
			Color componentColorOnValidationFault) {
		this.componentColorOnValidationFault = componentColorOnValidationFault;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isEnableValidationFaultProcessing() {
		return enableValidationFaultProcessing;
	}

	/**
	 * 
	 * @param enableValidationFaultProcessing
	 */
	public void setEnableValidationFaultProcessing(
			boolean enableValidationFaultProcessing) {
		this.enableValidationFaultProcessing = enableValidationFaultProcessing;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isComponentColorChangeOnValidationFault() {
		return componentColorChangeOnValidationFault;
	}

	/**
	 * 
	 * @param componentColorChangeOnValidationFault
	 */
	public void setComponentColorChangeOnValidationFault(
			boolean componentColorChangeOnValidationFault) {
		this.componentColorChangeOnValidationFault = componentColorChangeOnValidationFault;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isComponentTipChangeOnValidationFault() {
		return componentTipChangeOnValidationFault;
	}

	/**
	 * 
	 * @param componentTipChangeOnValidationFault
	 */
	public void setComponentTipChangeOnValidationFault(
			boolean componentTipChangeOnValidationFault) {
		this.componentTipChangeOnValidationFault = componentTipChangeOnValidationFault;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isDuplicateActionInvoke() {
		return duplicateActionInvoke;
	}

	/**
	 * 
	 * @param duplicateActionInvoke
	 */
	public void setDuplicateActionInvoke(boolean duplicateActionInvoke) {
		this.duplicateActionInvoke = duplicateActionInvoke;
	}
}
