/*
 * Copyright (c) 2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * 5. All your rights under this license shall terminate automatically if you fail to
 *    comply  with any of this list of conditions. If your rights under this license terminate,
 *    you agree to cease use and distribution of this software.
 * 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.swing.validator;

import java.awt.Component;


/**
 * <p>[概 要] </p>
 * １バリデーションエラーの情報を保持するクラスです。
 * 
 * <p>[詳 細] </p>
 * <ul>
 *     <li>バリデーションエラーを起こしたコンポーネントのインスタンス</li>
 *     <li>バリデーションエラーメッセージ</li>
 *     <li>エラー見出し文字（設定されない場合はコンポーネントのname属性値）</li>
 * </ul>
 * を保持します。<br>
 * 
 * <p>[備 考] </p>
 * 
 * <p>Copyright (c) 2008-2009 FUJITSU Japan All rights reserved.</p>
 * 
 * @author Project Reffi
 */
public class ValidateError {

	/** バリデーションエラーを起こしたコンポーネントです。 */
	private Component component;
	
	/** バリデータから譲渡されたエラーメッセージです。 */
	private String message;
	
	/** バリデータから譲渡されたエラー見出し文字です。（デフォルトはname属性値） */
	private String headWord;
	
	
	/**
	 * <p>[概 要] </p>
	 * バリデーションエラーを起こしたコンポーネントを返却します。
	 * 
	 * <p>[詳 細] </p>
	 * componentフィールドを返却します。
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @return バリデーションエラーを起こしたコンポーネント
	 */
	public Component getComponent() {
		return component;
	}

	/**
	 * <p>[概 要] </p>
	 * バリデーションエラーを起こしたコンポーネントを設定します。
	 * 
	 * <p>[詳 細] </p>
	 * componentフィールドを引数componentで設定します。
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param component バリデーションエラーを起こしたコンポーネント
	 */
	public void setComponent(Component component) {
		this.component = component;
	}

	/**
	 * <p>[概 要] </p>
	 * バリデータから譲渡されたエラーメッセージを返却します。
	 * 
	 * <p>[詳 細] </p>
	 * messageフィールドを返却します。
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @return バリデータから譲渡されたエラーメッセージ
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * <p>[概 要] </p>
	 * バリデータから譲渡されたエラーメッセージを設定します。
	 * 
	 * <p>[詳 細] </p>
	 * messageフィールドを引数messageで設定します。
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param message バリデータから譲渡されたエラーメッセージ
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * <p>[概 要] </p>
	 * バリデータから譲渡されたエラー見出し文字を返却します。
	 * 
	 * <p>[詳 細] </p>
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @return バリデータから譲渡されたエラー見出し文字
	 */
	public String getHeadWord() {
		return headWord;
	}

	/**
	 * <p>[概 要] </p>
	 * バリデータから譲渡されたエラー見出し文字を設定します。
	 * 
	 * <p>[詳 細] </p>
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param headWord バリデータから譲渡されたエラー見出し文字
	 */
	public void setHeadWord(String headWord) {
		this.headWord = headWord;
	}

	/**
	 * <p>[概 要] </p>
	 * コンストラクタです。
	 * 
	 * <p>[詳 細] </p>
	 * componentフィールドに引数componentを、messageフィールドに引数messageを設定します。
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param component バリデーションエラーを起こしたコンポーネント
	 * @param message バリデータから譲渡されたエラーメッセージ
	 */
	public ValidateError(Component component, String message){
		this.component = component;
		this.message = message;
	}
	
	/**
	 * <p>[概 要] </p>
	 * コンストラクタです。
	 * 
	 * <p>[詳 細] </p>
	 * {@link #ValidateError(Component, String)}オーバーロードコンストラクタをコール後、<br>
	 * headWordフィールドを引数headWordで設定します。
	 * 
	 * <p>[備 考] </p>
	 * 
	 * @param component バリデーションエラーを起こしたコンポーネント
	 * @param message バリデータから譲渡されたエラーメッセージ
	 * @param headWord バリデータから譲渡されたエラー見出し文字
	 */
	public ValidateError(Component component, String message, String headWord){
		this(component, message);
		this.headWord = headWord;
	}
}
