/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.android.action;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.view.View;
import android.widget.Toast;
import java.util.Map;
import jp.co.fujitsu.reffi.client.android.action.Action;
import jp.co.fujitsu.reffi.client.android.controller.AbstractController;
import jp.co.fujitsu.reffi.client.android.controller.NamingRepository;
import jp.co.fujitsu.reffi.client.android.controller.ParameterMapping;
import jp.co.fujitsu.reffi.client.android.parser.ComponentValue;
import jp.co.fujitsu.reffi.client.android.parser.ComponentValueParser;
import jp.co.fujitsu.reffi.client.android.parser.ComponentValues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAction
implements Action {
    private ParameterMapping parameterMapping;
    private AbstractController controller;
    private Activity activity;

    public ParameterMapping getParameterMapping() {
        return this.parameterMapping;
    }

    public void setParameterMapping(ParameterMapping parameterMapping) {
        this.parameterMapping = parameterMapping;
    }

    public AbstractController getController() {
        return this.controller;
    }

    public void setController(AbstractController controller) {
        this.controller = controller;
    }

    public Activity getActivity() {
        return this.activity;
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    @Override
    public ParameterMapping run(ParameterMapping parameterMapping) throws Exception {
        this.parameterMapping = parameterMapping;
        if (parameterMapping.getContext() instanceof Activity) {
            this.activity = (Activity)parameterMapping.getContext();
        }
        return parameterMapping;
    }

    public Map<Object, Object> getPermanent() {
        return this.getController().getPermanent();
    }

    public Object getPermanent(Object key) {
        return this.getController().getPermanent().get(key);
    }

    public void addPermanent(Object key, Object value) {
        this.getController().getPermanent().put(key, value);
    }

    public Object removePermanent(Object key) {
        return this.getController().getPermanent().remove(key);
    }

    protected ComponentValues getComponentValues(String componentName) throws Exception {
        ComponentValues ret = null;
        ComponentValueParser parser = new ComponentValueParser();
        ret = (ComponentValues)parser.parse((View)this.getComponent(componentName));
        return ret;
    }

    protected Object getComponentValue(String componentName) throws Exception {
        Object ret = null;
        ComponentValues componentValues = this.getComponentValues(componentName);
        ComponentValue componentValue = componentValues.getComponentValue(0);
        ret = componentValue.getValue();
        return ret;
    }

    protected String getComponentValueAsString(String componentName) throws Exception {
        String ret = null;
        ComponentValues values = this.getComponentValues(componentName);
        Object value = values.getComponentValue();
        ret = value.toString();
        return ret;
    }

    protected View findViewById(int id) {
        View ret = null;
        if (this.getParameterMapping().getContext() instanceof Activity) {
            ret = ((Activity)this.getParameterMapping().getContext()).findViewById(id);
        }
        return ret;
    }

    protected Object getComponent(String name) {
        Object ret = NamingRepository.get(this.getParameterMapping().getContext(), name);
        return ret;
    }

    protected String getComponentName(Object obj) {
        String name = NamingRepository.get(this.getParameterMapping().getContext(), obj);
        return name;
    }

    protected String getComponentName(int id) {
        View view = this.findViewById(id);
        String name = NamingRepository.get(this.getParameterMapping().getContext(), view);
        return name;
    }

    protected void showToast(String text) {
        Toast.makeText((Context)this.parameterMapping.getContext(), (CharSequence)text, (int)1).show();
    }

    protected void showToast(int id) {
        Toast.makeText((Context)this.parameterMapping.getContext(), (int)id, (int)1).show();
    }

    protected void startActivity(Class<? extends Activity> activityClass) {
        Activity activity = (Activity)this.parameterMapping.getContext();
        Intent intent = new Intent((Context)activity, activityClass);
        this.startActivity(intent);
    }

    protected void startActivity(Intent intent) {
        this.activity.startActivity(intent);
    }

    protected void startActivityForResult(Class<? extends Activity> activityClass, int requestCode) {
        Activity activity = (Activity)this.parameterMapping.getContext();
        Intent intent = new Intent((Context)activity, activityClass);
        this.startActivityForResult(intent, requestCode);
    }

    protected void startActivityForResult(Intent intent, int requestCode) {
        this.activity.startActivityForResult(intent, requestCode);
    }

    protected void setEventHandlerReturn(Object ret) {
        this.getParameterMapping().setEventHandlerReturn(ret);
    }

    protected SharedPreferences getSharedPreferences(String name, int mode) {
        SharedPreferences pref = this.getParameterMapping().getContext().getSharedPreferences(name, mode);
        return pref;
    }

    protected boolean finishActivity() {
        boolean ret = false;
        Context context = this.getParameterMapping().getContext();
        if (context instanceof Activity) {
            ((Activity)context).finish();
            ret = true;
        }
        return ret;
    }

    protected boolean finishActivity(String activityName) {
        boolean ret = false;
        Object obj = NamingRepository.get(this.getParameterMapping().getContext(), activityName);
        if (obj != null && obj instanceof Activity) {
            ((Activity)obj).finish();
            ret = true;
        }
        return ret;
    }
}

