/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.android.manager;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import java.util.HashMap;
import java.util.Map;
import jp.co.fujitsu.reffi.client.android.model.SQLiteCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLiteOpenHelperManager {
    public static final String ON_MEMORY = "ON_MEMORY";
    private static SQLiteOpenHelperManager instance;
    private Map<String, SQLiteOpenHelperImpl> helpers = new HashMap<String, SQLiteOpenHelperImpl>();

    public Map<String, SQLiteOpenHelperImpl> getHelpers() {
        return this.helpers;
    }

    public void setHelpers(Map<String, SQLiteOpenHelperImpl> helpers) {
        this.helpers = helpers;
    }

    private SQLiteOpenHelperManager() {
    }

    public static SQLiteOpenHelperManager getInstance() {
        if (instance == null) {
            instance = new SQLiteOpenHelperManager();
        }
        return instance;
    }

    public boolean isRegist(String dbName) {
        if (dbName == null) {
            dbName = ON_MEMORY;
        }
        return this.getHelpers().containsKey(dbName);
    }

    public SQLiteOpenHelper getHelper(String dbName) {
        if (dbName == null) {
            dbName = ON_MEMORY;
        }
        return this.getHelpers().get(dbName);
    }

    public SQLiteOpenHelper open(SQLiteCore sqliteCore) {
        SQLiteOpenHelperImpl ret = null;
        String dbName = sqliteCore.getDatabaseName();
        if (this.isRegist(sqliteCore.getDatabaseName())) {
            ret = this.getHelpers().get(dbName);
        } else {
            ret = new SQLiteOpenHelperImpl(sqliteCore);
            if (dbName == null) {
                dbName = ON_MEMORY;
            }
            this.getHelpers().put(dbName, ret);
        }
        return ret;
    }

    public boolean close(SQLiteCore sqliteCore) {
        String dbName = sqliteCore.getDatabaseName();
        boolean ret = this.close(dbName);
        return ret;
    }

    public boolean close(String dbName) {
        SQLiteDatabase writableDatabase;
        if (!this.isRegist(dbName)) {
            return false;
        }
        SQLiteOpenHelperImpl helper = (SQLiteOpenHelperImpl)this.getHelper(dbName);
        SQLiteDatabase readableDatabase = helper.getReadDB();
        if (readableDatabase != null && readableDatabase.isOpen()) {
            readableDatabase.close();
        }
        if ((writableDatabase = helper.getWriteDB()) != null && writableDatabase.isOpen()) {
            writableDatabase.close();
        }
        this.getHelpers().remove(dbName);
        return true;
    }

    public class SQLiteOpenHelperImpl
    extends SQLiteOpenHelper {
        private SQLiteCore sqliteCore;
        private SQLiteDatabase readDB;
        private SQLiteDatabase writeDB;

        protected SQLiteDatabase getReadDB() {
            return this.readDB;
        }

        protected SQLiteDatabase getWriteDB() {
            return this.writeDB;
        }

        public SQLiteOpenHelperImpl(SQLiteCore sqliteCore) {
            super(sqliteCore.getParameterMapping().getContext(), sqliteCore.getDatabaseName(), sqliteCore.getCursorFactory(), sqliteCore.getDatabaseVersion());
            this.sqliteCore = sqliteCore;
        }

        public SQLiteDatabase getReadableDatabase() {
            if (this.readDB == null) {
                SQLiteDatabase readableDatabase;
                this.readDB = readableDatabase = super.getReadableDatabase();
            }
            return this.readDB;
        }

        public SQLiteDatabase getWritableDatabase() {
            if (this.writeDB == null) {
                SQLiteDatabase writableDatabase;
                this.writeDB = writableDatabase = super.getWritableDatabase();
            }
            return this.writeDB;
        }

        public void onCreate(SQLiteDatabase db) {
            db.beginTransaction();
            if (this.sqliteCore.getOnCreateSql() != null) {
                for (String ddl : this.sqliteCore.getOnCreateSql()) {
                    db.execSQL(ddl);
                }
            }
            db.setTransactionSuccessful();
            db.endTransaction();
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            db.beginTransaction();
            if (this.sqliteCore.getOnUpdateSql() != null) {
                for (String ddl : this.sqliteCore.getOnUpdateSql()) {
                    db.execSQL(ddl);
                }
            }
            db.setTransactionSuccessful();
            db.endTransaction();
        }
    }
}

