/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.nexaweb.util;

import com.nexaweb.xml.Document;
import com.nexaweb.xml.Element;
import com.nexaweb.xml.Parser;
import com.nexaweb.xml.ParserException;
import com.nexaweb.xml.ParserFactory;
import com.nexaweb.xml.events.ChangeRejectedException;
import com.nexaweb.xml.events.StructureChangeEvent;
import com.nexaweb.xml.events.StructureChangeListener;
import com.nexaweb.xml.xpath.XPath;
import com.nexaweb.xml.xpath.XPathFactory;
import jp.co.fujitsu.reffi.common.nexaweb.dialog.CoreDialog;
import jp.co.fujitsu.reffi.common.nexaweb.dialog.CoreDialogIF;

public class DialogUtil {
    private static final String ROOT_PANE = "rootPane";
    public static final String MODAL_BACKGROUND_ID = "reffi.modaldaialogback";
    private static Document _uiDoc;

    private DialogUtil() {
    }

    private static Document getUiDocument() {
        return _uiDoc;
    }

    public static void messageAlert(Document uiDoc, CoreDialogIF cdi) {
        _uiDoc = uiDoc;
        CoreDialog modalBackCdi = new CoreDialog.Builder("", "").bgColor("transparent").bgImage("/images/modalBgImage.gif").maximized(Boolean.valueOf(true)).showTitleBar(Boolean.valueOf(false)).messageDialogFlg(Boolean.valueOf(false)).id(MODAL_BACKGROUND_ID).build();
        Element dialog = DialogUtil.getElement(cdi);
        String modal = dialog.getAttribute("modal");
        if (Boolean.parseBoolean(modal)) {
            uiDoc.addStructureChangeListener(new StructureChangeListener(){

                public void beforeChildAdded(StructureChangeEvent structurechangeevent) throws ChangeRejectedException {
                }

                public void beforeChildRemoved(StructureChangeEvent evt) throws ChangeRejectedException {
                    if (evt.getChange() instanceof Element) {
                        Element element;
                        Element source = (Element)evt.getChange();
                        String id = source.getAttribute("id");
                        if (("dialog".equals(source.getLocalName()) || "messageDialog".equals(source.getLocalName())) && !DialogUtil.MODAL_BACKGROUND_ID.equals(id) && (element = DialogUtil.getUiDocument().getElementById(DialogUtil.MODAL_BACKGROUND_ID)) != null) {
                            Element rootPane = DialogUtil.getRootPane(DialogUtil.getUiDocument());
                            rootPane.removeChild(element);
                        }
                    }
                }

                public void onChildAdded(StructureChangeEvent structurechangeevent) {
                }

                public void onChildRemoved(StructureChangeEvent structurechangeevent) {
                }
            });
            DialogUtil.showDialog(uiDoc, DialogUtil.getElement((CoreDialogIF)modalBackCdi));
        }
        DialogUtil.showDialog(uiDoc, DialogUtil.getElement(cdi));
    }

    public static Element getElement(CoreDialogIF cdi) {
        Element element = null;
        try {
            Parser parser = ParserFactory.getParser();
            Document doc = parser.parseXml(cdi.getTagXml());
            element = doc.getRootElement();
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        return element;
    }

    public static Element getRootPane(Document uiDoc) {
        Element rootElement = uiDoc.getRootElement();
        XPath xpath = XPathFactory.createXPath((String)"/ui/rootPane");
        Element rootPane = xpath.evaluateAsElement((Object)rootElement);
        if (rootPane == null) {
            rootPane = uiDoc.createElement(ROOT_PANE);
            rootElement.appendChild(rootPane);
        }
        return rootPane;
    }

    private static void showDialog(Document uiDoc, Element msgDialogElement) {
        if (msgDialogElement != null) {
            Element rootPane = DialogUtil.getRootPane(uiDoc);
            rootPane.appendChild(msgDialogElement);
        }
    }
}

