/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.swing.controller;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import jp.co.fujitsu.reffi.client.swing.controller.AbstractController;

public class EventInvocationHandler
implements InvocationHandler {
    private AbstractController controller;
    private Class<? extends EventListener> listenerType;
    private List<String> eventTypes;
    private static Method hashCodeMethod;
    private static Method equalsMethod;
    private static Method toStringMethod;

    public AbstractController getController() {
        return this.controller;
    }

    public void setController(AbstractController controller) {
        this.controller = controller;
    }

    public Class<? extends EventListener> getListenerType() {
        return this.listenerType;
    }

    public void setListenerType(Class<? extends EventListener> listenerType) {
        this.listenerType = listenerType;
    }

    public List<String> getEventTypes() {
        return this.eventTypes;
    }

    public void setEventTypes(List<String> eventTypes) {
        this.eventTypes = eventTypes;
    }

    public EventInvocationHandler(AbstractController controller, Class<? extends EventListener> listenerType, List<String> eventTypes) {
        this.controller = controller;
        this.listenerType = listenerType;
        this.eventTypes = eventTypes;
    }

    @Override
    public Object invoke(Object eventListenerProxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass == Object.class) {
            if (method.equals(hashCodeMethod)) {
                return this.proxyHashCode(eventListenerProxy);
            }
            if (method.equals(equalsMethod)) {
                return this.proxyEquals(eventListenerProxy, args[0]);
            }
            if (method.equals(toStringMethod)) {
                return this.proxyToString(eventListenerProxy);
            }
            throw new InternalError("unexpected Object method dispatched: " + method);
        }
        if (this.eventTypes.contains(method.getName())) {
            this.controller.handlerFacade((EventObject)args[0], this.listenerType, method.getName(), (EventListener)eventListenerProxy);
        }
        return result;
    }

    protected Integer proxyHashCode(Object proxy) {
        return new Integer(System.identityHashCode(proxy));
    }

    protected Boolean proxyEquals(Object proxy, Object other) {
        return proxy == other ? Boolean.TRUE : Boolean.FALSE;
    }

    protected String proxyToString(Object proxy) {
        return proxy.getClass().getName() + '@' + Integer.toHexString(proxy.hashCode());
    }

    static {
        try {
            hashCodeMethod = Object.class.getMethod("hashCode", null);
            equalsMethod = Object.class.getMethod("equals", Object.class);
            toStringMethod = Object.class.getMethod("toString", null);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }
}

