/*
 * Decompiled with CFR 0.152.
 */
package jp.co.fujitsu.reffi.client.swing.model;

import java.util.Hashtable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import jp.co.fujitsu.reffi.client.swing.event.ModelProcessEvent;
import jp.co.fujitsu.reffi.client.swing.model.BaseModel;

public class JMSProduceCore
extends BaseModel {
    private Hashtable<String, String> environment;
    private String connectionFactoryName = "ConnectionFactory";
    private QueueConnection queueConnection;
    private QueueSession queueSession;
    private Queue queue;
    private String queueName;
    private MessageProducer producer;
    private String textMessage;
    private Message message;

    public Hashtable<String, String> getEnvironment() {
        if (this.environment == null) {
            this.environment = this.getController().getClientConfig().getDefaultJmsEnvironment();
        }
        return this.environment;
    }

    public void setEnvironment(Hashtable<String, String> environment) {
        this.environment = environment;
    }

    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public void setConnectionFactoryName(String connectionFactoryName) {
        this.connectionFactoryName = connectionFactoryName;
    }

    public QueueConnection getQueueConnection() {
        return this.queueConnection;
    }

    public void setQueueConnection(QueueConnection queueConnection) {
        this.queueConnection = queueConnection;
    }

    public QueueSession getQueueSession() {
        return this.queueSession;
    }

    public void setQueueSession(QueueSession queueSession) {
        this.queueSession = queueSession;
    }

    public Queue getQueue() {
        return this.queue;
    }

    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public MessageProducer getProducer() {
        return this.producer;
    }

    public void setProducer(MessageProducer producer) {
        this.producer = producer;
    }

    public String getTextMessage() {
        return this.textMessage;
    }

    public void setTextMessage(String textMessage) {
        this.textMessage = textMessage;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public void createSession() throws NamingException, JMSException {
        InitialContext context = new InitialContext(this.getEnvironment());
        QueueConnectionFactory qcf = (QueueConnectionFactory)context.lookup(this.getConnectionFactoryName());
        this.setQueueConnection(qcf.createQueueConnection());
        this.setQueue((Queue)context.lookup(this.getQueueName()));
        this.setQueueSession(this.getQueueConnection().createQueueSession(false, 1));
    }

    @Override
    protected void mainproc() throws JMSException {
        this.getQueueConnection().start();
        this.setProducer(this.getQueueSession().createProducer((Destination)this.getQueue()));
        if (this.getTextMessage() != null) {
            this.setMessage((Message)this.getQueueSession().createTextMessage(this.getTextMessage()));
        }
        this.getProducer().send(this.getMessage());
    }

    @Override
    protected void postproc() throws Exception {
        ModelProcessEvent successEvent = new ModelProcessEvent(this);
        successEvent.setResult(this.getResult());
        this.fireModelSuccess(successEvent);
        this.fireModelFinished(new ModelProcessEvent(this));
    }

    @Override
    public void done() throws Exception {
        this.stop();
    }

    public void stop() throws JMSException {
        this.getProducer().close();
        this.getQueueConnection().stop();
        this.getQueueSession().close();
        this.getQueueConnection().close();
    }

    public TextMessage createTextMessage() throws JMSException {
        TextMessage msg = this.getQueueSession().createTextMessage();
        return msg;
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        ObjectMessage msg = this.getQueueSession().createObjectMessage();
        return msg;
    }

    public MapMessage createMapMessage() throws JMSException {
        MapMessage msg = this.getQueueSession().createMapMessage();
        return msg;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        StreamMessage msg = this.getQueueSession().createStreamMessage();
        return msg;
    }
}

