/* 
 * Copyright (c) 2008-2010, FUJITSU LIMITED
 * All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation and/or
 *    other materials provided with the distribution.
 * 
 * 3. Redistributions with modification must carry prominent notices stating that you changed 
 *    the files and the date of any change.
 * 
 * 4. Neither the name of FUJITSU LIMITED nor the names of its contributors may be used
 *    to endorse or promote products derived from this software without specific prior
 *    written permission.
 * 
 * 5. All your rights under this license shall terminate automatically if you fail to
 *    comply  with any of this list of conditions. If your rights under this license terminate,
 *    you agree to cease use and distribution of this software.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES;LOSS OF USE,DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.co.fujitsu.reffi.client.flex.validator{
	
	import mx.validators.ValidationResult;
	import mx.validators.Validator;

	/**
	 * <p>[概 要]</p>
	 * 入力されたIPアドレスをチェックするクラスです.
	 * 
	 * <p>[詳 細]</p>
	 * 呼び出し元で指定された入力チェック条件に従い、入力文字のチェック処理を実施します。
	 * 
	 * <p>[備 考]</p>
	 * 
	 * 
	 * <p>Copyright (c) 2008-2009 FUJITSU Japan All rights reserved.</p>
	 * @author Project Reffi
	 */
	public class NetAddressValidator extends Validator {

		private static const ERROR_MESSAGE :String ="フィールドが無効です。"; 
		
		private var results:Array;

		/**
		* <p>[概 要]</p>
		* 入力文字のチェック結果を返却します.
		* 
		* <p>[詳 細]</p>
		* 入力文字をチェックし、"0～255.0～255.0～255.0～255"の形式以外の場合は、<BR>
		* 指定されたエラーメッセージを結果配列に設定します。
		* 
		* <p>[備 考]</p>
		 * 
		* @param value 入力文字列
		* @return チェック結果配列
		* 
		*/
		override protected function doValidation(value:Object):Array {

			//検証結果 Array の初期化
			results = [];
			results = super.doValidation(value);

			if (value.toString() == "") {
				return results;
			}

			//半角空白を除去
			var netAddress:String="";
			var matchList : Array = value.toString().split(" ");
			for(var i:int=0;i<matchList.length;i++){
				if(matchList[i].toString().length>0){
					netAddress += matchList[i].toString();
				}
			}

			//NetAddress形式チェックパターンの生成
			var pattern_Address:RegExp = /^(?:0|1\d{0,2}|2(?:[0-4]\d?|5[0-5]?|[6-9])?|[3-9]\d?)(?:\.(?:0|1\d{0,2}|2(?:[0-4]\d?|5[0-5]?|[6-9])?|[3-9]\d?)){3}$/;
			//パターンチェック
			if ( !pattern_Address.test(netAddress) ) {
				results.push(new ValidationResult(true, null, "NaN", ERROR_MESSAGE));
				return results;
			}

			return results;
		}
	}
}

