/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.runtime.AdapterFactoryProxy;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;

public final class AdapterManager
implements IAdapterManager,
IRegistryChangeListener {
    protected HashMap adapterLookup = null;
    protected HashMap classLookup;
    protected HashMap classSearchOrderLookup;
    protected final HashMap factories = new HashMap(5);

    public AdapterManager() {
        this.registerFactoryProxies();
        Platform.getExtensionRegistry().addRegistryChangeListener(this);
    }

    private void addFactoriesFor(String typeName, Map table) {
        List factoryList = (List)this.factories.get(typeName);
        if (factoryList == null) {
            return;
        }
        int i = 0;
        int imax = factoryList.size();
        while (i < imax) {
            int j;
            Object[] adapters;
            IAdapterFactory factory = (IAdapterFactory)factoryList.get(i);
            if (factory instanceof AdapterFactoryProxy) {
                adapters = ((AdapterFactoryProxy)factory).getAdapterNames();
                j = 0;
                while (j < adapters.length) {
                    if (table.get(adapters[j]) == null) {
                        table.put(adapters[j], factory);
                    }
                    ++j;
                }
            } else {
                adapters = factory.getAdapterList();
                j = 0;
                while (j < adapters.length) {
                    String adapterName = ((Class)adapters[j]).getName();
                    if (table.get(adapterName) == null) {
                        table.put(adapterName, factory);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void cacheClassLookup(IAdapterFactory factory, Class clazz) {
        HashMap<String, Class> classes;
        HashMap<IAdapterFactory, HashMap<String, Class>> lookup = this.classLookup;
        if (lookup == null) {
            this.classLookup = lookup = new HashMap<IAdapterFactory, HashMap<String, Class>>(4);
        }
        if ((classes = (HashMap<String, Class>)lookup.get(factory)) == null) {
            classes = new HashMap<String, Class>(4);
            lookup.put(factory, classes);
        }
        classes.put(clazz.getName(), clazz);
    }

    private Class cachedClassForName(IAdapterFactory factory, String typeName) {
        HashMap classes;
        Class clazz = null;
        HashMap lookup = this.classLookup;
        if (lookup != null && (classes = (HashMap)lookup.get(factory)) != null) {
            clazz = (Class)classes.get(typeName);
        }
        return clazz;
    }

    private Class classForName(IAdapterFactory factory, String typeName) {
        Class<?> clazz = this.cachedClassForName(factory, typeName);
        if (clazz == null) {
            try {
                if (factory instanceof AdapterFactoryProxy) {
                    factory = ((AdapterFactoryProxy)factory).loadFactory(false);
                }
                if (factory != null) {
                    clazz = factory.getClass().getClassLoader().loadClass(typeName);
                    this.cacheClassLookup(factory, clazz);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return clazz;
    }

    public String[] computeAdapterTypes(Class adaptable) {
        Set types2 = this.getFactories(adaptable).keySet();
        return types2.toArray(new String[types2.size()]);
    }

    private Map getFactories(Class adaptable) {
        HashMap table;
        HashMap lookup = this.adapterLookup;
        if (lookup == null) {
            this.adapterLookup = lookup = new HashMap(30);
        }
        if ((table = (HashMap)lookup.get(adaptable.getName())) == null) {
            table = new HashMap(4);
            Class[] classes = this.computeClassOrder(adaptable);
            int i = 0;
            while (i < classes.length) {
                this.addFactoriesFor(classes[i].getName(), table);
                ++i;
            }
            lookup.put(adaptable.getName(), table);
        }
        return table;
    }

    public Class[] computeClassOrder(Class adaptable) {
        ArrayList classes = null;
        HashMap lookup = this.classSearchOrderLookup;
        if (lookup != null) {
            classes = (ArrayList)lookup.get(adaptable);
        }
        if (classes == null) {
            classes = new ArrayList();
            this.computeClassOrder(adaptable, classes);
            if (lookup == null) {
                this.classSearchOrderLookup = lookup = new HashMap();
            }
            lookup.put(adaptable, classes);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private void computeClassOrder(Class adaptable, Collection classes) {
        Class clazz = adaptable;
        HashSet seen = new HashSet(4);
        while (clazz != null) {
            classes.add(clazz);
            this.computeInterfaceOrder(clazz.getInterfaces(), classes, seen);
            clazz = clazz.getSuperclass();
        }
    }

    private void computeInterfaceOrder(Class[] interfaces, Collection classes, Set seen) {
        ArrayList<Class> newInterfaces = new ArrayList<Class>(interfaces.length);
        int i = 0;
        while (i < interfaces.length) {
            Class interfac = interfaces[i];
            if (seen.add(interfac)) {
                classes.add(interfac);
                newInterfaces.add(interfac);
            }
            ++i;
        }
        Iterator it = newInterfaces.iterator();
        while (it.hasNext()) {
            this.computeInterfaceOrder(((Class)it.next()).getInterfaces(), classes, seen);
        }
    }

    public synchronized void flushLookup() {
        this.adapterLookup = null;
        this.classLookup = null;
        this.classSearchOrderLookup = null;
    }

    public Object getAdapter(Object adaptable, Class adapterType) {
        IAdapterFactory factory = (IAdapterFactory)this.getFactories(adaptable.getClass()).get(adapterType.getName());
        Object result = null;
        if (factory != null) {
            result = factory.getAdapter(adaptable, adapterType);
        }
        if (result == null && adapterType.isInstance(adaptable)) {
            return adaptable;
        }
        return result;
    }

    public Object getAdapter(Object adaptable, String adapterType) {
        return this.getAdapter(adaptable, adapterType, false);
    }

    private Object getAdapter(Object adaptable, String adapterType, boolean force) {
        Class clazz;
        IAdapterFactory factory = (IAdapterFactory)this.getFactories(adaptable.getClass()).get(adapterType);
        if (force && factory instanceof AdapterFactoryProxy) {
            factory = ((AdapterFactoryProxy)factory).loadFactory(true);
        }
        Object result = null;
        if (factory != null && (clazz = this.classForName(factory, adapterType)) != null) {
            result = factory.getAdapter(adaptable, clazz);
        }
        if (result == null && adaptable.getClass().getName().equals(adapterType)) {
            return adaptable;
        }
        return result;
    }

    public boolean hasAdapter(Object adaptable, String adapterTypeName) {
        return this.getFactories(adaptable.getClass()).get(adapterTypeName) != null;
    }

    public Object loadAdapter(Object adaptable, String adapterTypeName) {
        return this.getAdapter(adaptable, adapterTypeName, true);
    }

    public synchronized void registerAdapters(IAdapterFactory factory, Class adaptable) {
        this.registerFactory(factory, adaptable.getName());
        this.flushLookup();
    }

    private void registerExtension(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int j = 0;
        while (j < elements.length) {
            AdapterFactoryProxy proxy = AdapterFactoryProxy.createProxy(elements[j]);
            if (proxy != null) {
                this.registerFactory(proxy, proxy.getAdaptableType());
            }
            ++j;
        }
    }

    private void registerFactory(IAdapterFactory factory, String adaptableType) {
        ArrayList<IAdapterFactory> list = (ArrayList<IAdapterFactory>)this.factories.get(adaptableType);
        if (list == null) {
            list = new ArrayList<IAdapterFactory>(5);
            this.factories.put(adaptableType, list);
        }
        list.add(factory);
    }

    private void registerFactoryProxies() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.core.runtime", "adapters");
        if (point == null) {
            return;
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            this.registerExtension(extensions[i]);
            ++i;
        }
    }

    public synchronized void registryChanged(IRegistryChangeEvent event) {
        HashSet<IExtension> toRemove = null;
        IExtensionDelta[] deltas = event.getExtensionDeltas();
        String adapterId = "org.eclipse.core.runtime.adapters";
        boolean found = false;
        int i = 0;
        while (i < deltas.length) {
            if (adapterId.equals(deltas[i].getExtensionPoint().getUniqueIdentifier())) {
                found = true;
                if (deltas[i].getKind() == 1) {
                    this.registerExtension(deltas[i].getExtension());
                } else {
                    if (toRemove == null) {
                        toRemove = new HashSet<IExtension>();
                    }
                    toRemove.add(deltas[i].getExtension());
                }
            }
            ++i;
        }
        if (found) {
            this.flushLookup();
        }
        if (toRemove == null) {
            return;
        }
        Iterator it = this.factories.values().iterator();
        while (it.hasNext()) {
            Iterator it2 = ((List)it.next()).iterator();
            while (it2.hasNext()) {
                IExtension ext;
                IAdapterFactory factory = (IAdapterFactory)it2.next();
                if (!(factory instanceof AdapterFactoryProxy) || !toRemove.contains(ext = ((AdapterFactoryProxy)factory).getExtension())) continue;
                it2.remove();
            }
        }
    }

    public synchronized void unregisterAdapters(IAdapterFactory factory) {
        Iterator it = this.factories.values().iterator();
        while (it.hasNext()) {
            ((List)it.next()).remove(factory);
        }
        this.flushLookup();
    }

    public synchronized void unregisterAdapters(IAdapterFactory factory, Class adaptable) {
        List factoryList = (List)this.factories.get(adaptable.getName());
        if (factoryList == null) {
            return;
        }
        factoryList.remove(factory);
        this.flushLookup();
    }

    public synchronized void unregisterAllAdapters() {
        this.factories.clear();
        this.flushLookup();
        Platform.getExtensionRegistry().removeRegistryChangeListener(this);
    }
}

