/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.internal.runtime.CipherInputStream;
import org.eclipse.core.internal.runtime.CipherOutputStream;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.internal.runtime.URLTool;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class AuthorizationDatabase {
    private static final int KEYRING_FILE_VERSION = 1;
    private Hashtable authorizationInfo = new Hashtable(5);
    private Hashtable protectionSpace = new Hashtable(5);
    private File file = null;
    private String password = null;
    private boolean needsSaving = true;

    public AuthorizationDatabase() {
    }

    public AuthorizationDatabase(String filename, String password) throws CoreException {
        Assert.isNotNull(filename);
        Assert.isNotNull(password);
        this.password = password;
        this.file = new File(filename);
        this.load();
    }

    public void addAuthorizationInfo(URL serverUrl, String realm, String authScheme, Map info) {
        Hashtable<String, Map> authSchemeToInfo;
        Assert.isNotNull(serverUrl);
        Assert.isNotNull(realm);
        Assert.isNotNull(authScheme);
        Assert.isNotNull(info);
        String url = serverUrl.toString();
        Hashtable<String, Hashtable<String, Map>> realmToAuthScheme = (Hashtable<String, Hashtable<String, Map>>)this.authorizationInfo.get(url);
        if (realmToAuthScheme == null) {
            realmToAuthScheme = new Hashtable<String, Hashtable<String, Map>>(5);
            this.authorizationInfo.put(url, realmToAuthScheme);
        }
        if ((authSchemeToInfo = (Hashtable<String, Map>)realmToAuthScheme.get(realm)) == null) {
            authSchemeToInfo = new Hashtable<String, Map>(5);
            realmToAuthScheme.put(realm, authSchemeToInfo);
        }
        authSchemeToInfo.put(authScheme.toLowerCase(), info);
        this.needsSaving = true;
    }

    public void addProtectionSpace(URL resourceUrl, String realm) {
        String oldRealm;
        Assert.isNotNull(resourceUrl);
        Assert.isNotNull(realm);
        if (!resourceUrl.getFile().endsWith("/")) {
            resourceUrl = URLTool.getParent(resourceUrl);
        }
        if ((oldRealm = this.getProtectionSpace(resourceUrl)) != null && oldRealm.equals(realm)) {
            return;
        }
        String url1 = resourceUrl.toString();
        Enumeration urls = this.protectionSpace.keys();
        while (urls.hasMoreElements()) {
            String url2 = (String)urls.nextElement();
            if (!url1.startsWith(url2) && !url2.startsWith(url1)) continue;
            this.protectionSpace.remove(url2);
            break;
        }
        this.protectionSpace.put(url1, realm);
        this.needsSaving = true;
    }

    public void flushAuthorizationInfo(URL serverUrl, String realm, String authScheme) {
        Hashtable realmToAuthScheme = (Hashtable)this.authorizationInfo.get(serverUrl.toString());
        if (realmToAuthScheme == null) {
            return;
        }
        Hashtable authSchemeToInfo = (Hashtable)realmToAuthScheme.get(realm);
        if (authSchemeToInfo == null) {
            return;
        }
        authSchemeToInfo.remove(authScheme.toLowerCase());
        this.needsSaving = true;
    }

    public Map getAuthorizationInfo(URL serverUrl, String realm, String authScheme) {
        Hashtable realmToAuthScheme = (Hashtable)this.authorizationInfo.get(serverUrl.toString());
        if (realmToAuthScheme == null) {
            return null;
        }
        Hashtable authSchemeToInfo = (Hashtable)realmToAuthScheme.get(realm);
        if (authSchemeToInfo == null) {
            return null;
        }
        return (Map)authSchemeToInfo.get(authScheme.toLowerCase());
    }

    public String getProtectionSpace(URL resourceUrl) {
        while (resourceUrl != null) {
            String realm = (String)this.protectionSpace.get(resourceUrl.toString());
            if (realm != null) {
                return realm;
            }
            resourceUrl = URLTool.getParent(resourceUrl);
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void load() throws CoreException {
        if (this.file == null) {
            return;
        }
        if (!this.file.exists()) {
            this.save();
            return;
        }
        try {
            FileInputStream input = new FileInputStream(this.file);
            try {
                this.load(input);
            }
            catch (Throwable throwable) {
                Object var2_5 = null;
                ((InputStream)input).close();
                throw throwable;
            }
            {
                Object var2_6 = null;
                ((InputStream)input).close();
                return;
            }
        }
        catch (IOException e) {
            throw new CoreException(new Status(4, "org.eclipse.core.runtime", 4, NLS.bind((String)Messages.meta_unableToReadAuthorization, (Object)this.file), e));
        }
        catch (ClassNotFoundException e) {
            throw new CoreException(new Status(4, "org.eclipse.core.runtime", 4, NLS.bind((String)Messages.meta_unableToReadAuthorization, (Object)this.file), e));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void load(InputStream is) throws IOException, ClassNotFoundException, CoreException {
        int version = is.read();
        if (version == 1) {
            CipherInputStream cis = new CipherInputStream(is, this.password);
            ObjectInputStream ois = new ObjectInputStream(cis);
            try {
                this.authorizationInfo = (Hashtable)ois.readObject();
                this.protectionSpace = (Hashtable)ois.readObject();
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                ois.close();
                throw throwable;
            }
            {
                Object var5_7 = null;
                ois.close();
                return;
            }
        }
        InternalPlatform.getDefault().log(new Status(2, "org.eclipse.core.runtime", 4, Messages.meta_authFormatChanged, null));
        try {
            is.close();
        }
        catch (IOException iOException) {}
        this.needsSaving = true;
        this.save();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save() throws CoreException {
        if (!this.needsSaving || this.file == null) {
            return;
        }
        try {
            this.file.delete();
            if (!this.file.getParentFile().exists() && !this.file.getParentFile().mkdirs() || !AuthorizationDatabase.canWrite(this.file.getParentFile())) {
                throw new CoreException(new Status(4, "org.eclipse.core.runtime", 5, NLS.bind((String)Messages.meta_unableToWriteAuthorization, (Object)this.file), null));
            }
            this.file.createNewFile();
            FileOutputStream out = new FileOutputStream(this.file);
            try {
                this.save(out);
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                out.close();
                throw throwable;
            }
            {
                Object var2_5 = null;
                out.close();
            }
        }
        catch (IOException e) {
            throw new CoreException(new Status(4, "org.eclipse.core.runtime", 5, NLS.bind((String)Messages.meta_unableToWriteAuthorization, (Object)this.file), e));
        }
        this.needsSaving = false;
    }

    /*
     * Exception decompiling
     */
    private static boolean canWrite(File installDir) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 56->59)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void save(FileOutputStream os2) throws IOException {
        os2.write(1);
        CipherOutputStream cos = new CipherOutputStream(os2, this.password);
        ObjectOutputStream oos = new ObjectOutputStream(cos);
        try {
            oos.writeObject(this.authorizationInfo);
            oos.writeObject(this.protectionSpace);
            os2.flush();
            os2.getFD().sync();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            oos.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        oos.close();
    }

    public boolean setPassword(String oldValue, String newValue) {
        if (!oldValue.equals(this.password)) {
            return false;
        }
        this.password = newValue;
        this.needsSaving = true;
        return true;
    }
}

