/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.HDITEM;
import org.eclipse.swt.internal.win32.HDLAYOUT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMHEADER;
import org.eclipse.swt.internal.win32.NMRGINFO;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.NMTVCUSTOMDRAW;
import org.eclipse.swt.internal.win32.NMTVDISPINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.TVHITTESTINFO;
import org.eclipse.swt.internal.win32.TVINSERTSTRUCT;
import org.eclipse.swt.internal.win32.TVITEM;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tree
extends Composite {
    TreeItem[] items;
    TreeColumn[] columns;
    int hwndParent;
    int hwndHeader;
    int hAnchor;
    int hInsert;
    ImageList imageList;
    boolean dragStarted;
    boolean gestureCompleted;
    boolean insertAfter;
    boolean ignoreSelect;
    boolean ignoreExpand;
    boolean ignoreDeselect;
    boolean ignoreResize;
    boolean lockSelection;
    boolean oldSelected;
    boolean newSelected;
    boolean linesVisible;
    boolean customDraw;
    boolean printClient;
    static final int INSET = 3;
    static final int GRID_WIDTH = 1;
    static final int HEADER_MARGIN = 10;
    static final int TreeProc;
    static final TCHAR TreeClass;
    static final char[] BUTTON;

    static {
        TreeClass = new TCHAR(0, "SysTreeView32", true);
        char[] cArray = new char[7];
        cArray[0] = 66;
        cArray[1] = 85;
        cArray[2] = 84;
        cArray[3] = 84;
        cArray[4] = 79;
        cArray[5] = 78;
        BUTTON = cArray;
        WNDCLASS lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0, TreeClass, lpWndClass);
        TreeProc = lpWndClass.lpfnWndProc;
    }

    public Tree(Composite parent, int style) {
        super(parent, Tree.checkStyle(style));
    }

    static int checkStyle(int style) {
        return Tree.checkBits(style |= 0x300, 4, 2, 0, 0, 0, 0);
    }

    int _getBackgroundPixel() {
        if (OS.IsWinCE) {
            return OS.GetSysColor(OS.COLOR_WINDOW);
        }
        int pixel = OS.SendMessage(this.handle, 4383, 0, 0);
        if (pixel == -1) {
            return OS.GetSysColor(OS.COLOR_WINDOW);
        }
        return pixel;
    }

    void _setBackgroundPixel(int pixel) {
        int oldPixel = OS.SendMessage(this.handle, 4383, 0, 0);
        if (oldPixel != -1) {
            OS.SendMessage(this.handle, 4381, 0, -1);
        }
        OS.SendMessage(this.handle, 4381, 0, pixel);
        if ((this.style & 0x20) != 0) {
            this.setCheckboxImageList();
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    int borderHandle() {
        return this.hwndParent != 0 ? this.hwndParent : this.handle;
    }

    int callWindowProc(int hwnd, int msg, int wParam, int lParam) {
        if (this.handle == 0) {
            return 0;
        }
        if (this.hwndParent != 0 && hwnd == this.hwndParent) {
            return OS.DefWindowProc(hwnd, msg, wParam, lParam);
        }
        switch (msg) {
            case 513: 
            case 516: 
            case 519: 
            case 523: {
                Display display = this.display;
                display.ignoreMsgFilter = true;
                int code = OS.CallWindowProc(TreeProc, hwnd, msg, wParam, lParam);
                display.ignoreMsgFilter = false;
                return code;
            }
            case 522: {
                int code = OS.CallWindowProc(TreeProc, hwnd, msg, wParam, lParam);
                this.updateScrollBar();
                return code;
            }
        }
        return OS.CallWindowProc(TreeProc, hwnd, msg, wParam, lParam);
    }

    boolean checkHandle(int hwnd) {
        return hwnd == this.handle || this.hwndParent != 0 && hwnd == this.hwndParent;
    }

    boolean checkScroll(int hItem) {
        if (this.drawCount == 0) {
            return false;
        }
        int hRoot = OS.SendMessage(this.handle, 4362, 0, 0);
        int hParent = OS.SendMessage(this.handle, 4362, 3, hItem);
        while (hParent != hRoot && hParent != 0) {
            hParent = OS.SendMessage(this.handle, 4362, 3, hParent);
        }
        return hParent == 0;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (this.hwndHeader != 0) {
            HDITEM hdItem = new HDITEM();
            hdItem.mask = 1;
            int count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
            int i = 0;
            while (i < count) {
                OS.SendMessage(this.hwndHeader, OS.HDM_GETITEM, i, hdItem);
                width += hdItem.cxy;
                ++i;
            }
            RECT rect = new RECT();
            OS.GetWindowRect(this.hwndHeader, rect);
            height += rect.bottom - rect.top;
        }
        RECT rect = new RECT();
        int hItem = OS.SendMessage(this.handle, 4362, 0, 0);
        while (hItem != 0) {
            rect.left = hItem;
            if (OS.SendMessage(this.handle, 4356, 1, rect) != 0) {
                width = Math.max(width, rect.right);
                height += rect.bottom - rect.top;
            }
            hItem = OS.SendMessage(this.handle, 4362, 1, hItem);
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        width += border * 2;
        height += border * 2;
        if ((this.style & 0x200) != 0) {
            width += OS.GetSystemMetrics(2);
        }
        if ((this.style & 0x100) != 0) {
            height += OS.GetSystemMetrics(3);
        }
        return new Point(width, height);
    }

    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFFFD;
        if (!OS.IsWinCE && OS.COMCTL32_MAJOR < 6) {
            OS.SendMessage(this.handle, 8199, 5, 0);
        }
        if ((this.style & 0x20) != 0) {
            this.setCheckboxImageList();
        }
        int hFont = OS.GetStockObject(13);
        OS.SendMessage(this.handle, 48, hFont, 0);
    }

    void createItem(TreeColumn column, int index) {
        if (this.hwndHeader == 0) {
            this.createParent();
        }
        int columnCount = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
        if (index < 0 || index > columnCount) {
            this.error(6);
        }
        if (columnCount == this.columns.length) {
            TreeColumn[] newColumns = new TreeColumn[this.columns.length + 4];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columns.length);
            this.columns = newColumns;
        }
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null) {
                int[] temp;
                Image[] images;
                String[] strings = item.strings;
                if (strings != null) {
                    String[] temp2 = new String[columnCount + 1];
                    System.arraycopy(strings, 0, temp2, 0, index);
                    System.arraycopy(strings, index, temp2, index + 1, columnCount - index);
                    item.strings = temp2;
                }
                if ((images = item.images) != null) {
                    Image[] temp3 = new Image[columnCount + 1];
                    System.arraycopy(images, 0, temp3, 0, index);
                    System.arraycopy(images, index, temp3, index + 1, columnCount - index);
                    item.images = temp3;
                }
                if (index == 0 && columnCount != 0) {
                    if (strings == null) {
                        item.strings = new String[columnCount + 1];
                        item.strings[1] = item.text;
                    }
                    item.text = "";
                    if (images == null) {
                        item.images = new Image[columnCount + 1];
                        item.images[1] = item.image;
                    }
                    item.image = null;
                }
                if (item.cellBackground != null) {
                    int[] cellBackground = item.cellBackground;
                    temp = new int[columnCount + 1];
                    System.arraycopy(cellBackground, 0, temp, 0, index);
                    System.arraycopy(cellBackground, index, temp, index + 1, columnCount - index);
                    temp[index] = -1;
                    item.cellBackground = temp;
                }
                if (item.cellForeground != null) {
                    int[] cellForeground = item.cellForeground;
                    temp = new int[columnCount + 1];
                    System.arraycopy(cellForeground, 0, temp, 0, index);
                    System.arraycopy(cellForeground, index, temp, index + 1, columnCount - index);
                    temp[index] = -1;
                    item.cellForeground = temp;
                }
                if (item.cellFont != null) {
                    int[] cellFont = item.cellFont;
                    temp = new int[columnCount + 1];
                    System.arraycopy(cellFont, 0, temp, 0, index);
                    System.arraycopy(cellFont, index, temp, index + 1, columnCount - index);
                    temp[index] = -1;
                    item.cellFont = temp;
                }
            }
            ++i;
        }
        System.arraycopy(this.columns, index, this.columns, index + 1, columnCount - index);
        this.columns[index] = column;
        int hHeap = OS.GetProcessHeap();
        int pszText = OS.HeapAlloc(hHeap, 8, TCHAR.sizeof);
        HDITEM hdItem = new HDITEM();
        hdItem.mask = 6;
        hdItem.pszText = pszText;
        if ((column.style & 0x4000) == 16384) {
            hdItem.fmt = 0;
        }
        if ((column.style & 0x1000000) == 0x1000000) {
            hdItem.fmt = 2;
        }
        if ((column.style & 0x20000) == 131072) {
            hdItem.fmt = 1;
        }
        OS.SendMessage(this.hwndHeader, OS.HDM_INSERTITEM, index, hdItem);
        if (pszText != 0) {
            OS.HeapFree(hHeap, 0, pszText);
        }
        if (columnCount == 0) {
            int bits = OS.GetWindowLong(this.handle, -16);
            OS.SetWindowLong(this.handle, -16, bits |= 0x8000);
        }
        this.setScrollWidth();
        this.updateScrollBar();
        if (columnCount == 0 && OS.SendMessage(this.handle, 4357, 0, 0) != 0) {
            OS.InvalidateRect(this.handle, null, true);
        }
    }

    void createItem(TreeItem item, int hParent, int hInsertAfter) {
        int hChild;
        int hItem;
        int id = 0;
        while (id < this.items.length && this.items[id] != null) {
            ++id;
        }
        if (id == this.items.length) {
            TreeItem[] newItems = new TreeItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        TVINSERTSTRUCT tvInsert = new TVINSERTSTRUCT();
        tvInsert.hParent = hParent;
        tvInsert.hInsertAfter = hInsertAfter;
        tvInsert.lParam = id;
        tvInsert.pszText = -1;
        tvInsert.iSelectedImage = -1;
        tvInsert.iImage = -1;
        tvInsert.mask = 55;
        if ((this.style & 0x20) != 0) {
            tvInsert.mask |= 8;
            tvInsert.state = 4096;
            tvInsert.stateMask = 61440;
        }
        if ((hItem = OS.SendMessage(this.handle, OS.TVM_INSERTITEM, 0, tvInsert)) == 0) {
            this.error(14);
        }
        item.handle = hItem;
        this.items[id] = item;
        if (OS.IsWindowVisible(this.handle) && this.drawCount == 0 && (hChild = OS.SendMessage(this.handle, 4362, 4, hParent)) != 0 && OS.SendMessage(this.handle, 4362, 1, hChild) == 0) {
            RECT rect = new RECT();
            rect.left = hParent;
            if (OS.SendMessage(this.handle, 4356, 0, rect) != 0) {
                OS.InvalidateRect(this.handle, rect, true);
            }
        }
        this.updateScrollBar();
    }

    void createParent() {
        int hwndFocus;
        int hImageList;
        int hFont;
        this.forceResize();
        RECT rect = new RECT();
        OS.GetWindowRect(this.handle, rect);
        OS.MapWindowPoints(0, this.parent.handle, rect, 2);
        int oldStyle = OS.GetWindowLong(this.handle, -16);
        int newStyle = super.widgetStyle() & 0xEFFFFFFF;
        if ((oldStyle & 0x4000000) != 0) {
            newStyle |= 0x4000000;
        }
        this.hwndParent = OS.CreateWindowEx(super.widgetExtStyle(), super.windowClass(), null, newStyle, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, this.parent.handle, 0, OS.GetModuleHandle(null), null);
        if (this.hwndParent == 0) {
            this.error(2);
        }
        OS.SetWindowLong(this.hwndParent, -12, this.hwndParent);
        int bits = 0;
        if (OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            bits |= 0x100000;
            if ((this.style & 0x4000000) != 0) {
                bits |= 0x400000;
            }
        }
        this.hwndHeader = OS.CreateWindowEx(bits, new TCHAR(0, "SysHeader32", true), null, 1140850826, 0, 0, 0, 0, this.hwndParent, 0, OS.GetModuleHandle(null), null);
        if (this.hwndHeader == 0) {
            this.error(2);
        }
        OS.SetWindowLong(this.hwndHeader, -12, this.hwndHeader);
        if (OS.IsDBLocale) {
            int hIMC = OS.ImmGetContext(this.handle);
            OS.ImmAssociateContext(this.hwndParent, hIMC);
            OS.ImmAssociateContext(this.hwndHeader, hIMC);
            OS.ImmReleaseContext(this.handle, hIMC);
        }
        if (!OS.IsPPC && (this.style & 0x800) != 0) {
            int oldExStyle = OS.GetWindowLong(this.handle, -20);
            OS.SetWindowLong(this.handle, -20, oldExStyle &= 0xFFFFFDFF);
        }
        if ((hFont = OS.SendMessage(this.handle, 49, 0, 0)) != 0) {
            OS.SendMessage(this.hwndHeader, 48, hFont, 0);
        }
        if ((hImageList = OS.SendMessage(this.handle, 4360, 0, 0)) != 0) {
            OS.SendMessage(this.hwndHeader, 4616, 0, hImageList);
        }
        int hwndInsertAfter = OS.GetWindow(this.handle, 3);
        int flags = 19;
        this.SetWindowPos(this.hwndParent, hwndInsertAfter, 0, 0, 0, 0, flags);
        SCROLLINFO info = new SCROLLINFO();
        info.cbSize = 28;
        info.fMask = 3;
        OS.GetScrollInfo(this.hwndParent, 0, info);
        info.nPage = info.nMax + 1;
        OS.SetScrollInfo(this.hwndParent, 0, info, true);
        OS.GetScrollInfo(this.hwndParent, 1, info);
        info.nPage = info.nMax + 1;
        OS.SetScrollInfo(this.hwndParent, 1, info, true);
        this.customDraw = true;
        this.deregister();
        if ((oldStyle & 0x10000000) != 0) {
            OS.ShowWindow(this.hwndParent, 5);
        }
        if ((hwndFocus = OS.GetFocus()) == this.handle) {
            OS.SetFocus(this.hwndParent);
        }
        OS.SetParent(this.handle, this.hwndParent);
        if (hwndFocus == this.handle) {
            OS.SetFocus(this.handle);
        }
        this.register();
    }

    void createWidget() {
        super.createWidget();
        this.items = new TreeItem[4];
        this.columns = new TreeColumn[4];
    }

    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    void deregister() {
        super.deregister();
        if (this.hwndParent != 0) {
            this.display.removeControl(this.hwndParent);
        }
    }

    public void deselectAll() {
        this.checkWidget();
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 8;
        tvItem.stateMask = 2;
        if ((this.style & 4) != 0) {
            int hItem = OS.SendMessage(this.handle, 4362, 9, 0);
            if (hItem != 0) {
                tvItem.hItem = hItem;
                OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
            }
        } else {
            int oldProc = OS.GetWindowLong(this.handle, -4);
            OS.SetWindowLong(this.handle, -4, TreeProc);
            int i = 0;
            while (i < this.items.length) {
                TreeItem item = this.items[i];
                if (item != null) {
                    tvItem.hItem = item.handle;
                    OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                }
                ++i;
            }
            OS.SetWindowLong(this.handle, -4, oldProc);
        }
    }

    void destroyItem(TreeColumn column) {
        if (this.hwndHeader == 0) {
            this.error(15);
        }
        int columnCount = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
        int index = 0;
        while (index < columnCount) {
            if (this.columns[index] == column) break;
            ++index;
        }
        if (OS.SendMessage(this.hwndHeader, 4610, index, 0) == 0) {
            this.error(15);
        }
        System.arraycopy(this.columns, index + 1, this.columns, index, --columnCount - index);
        this.columns[columnCount] = null;
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null) {
                if (columnCount == 0) {
                    item.strings = null;
                    item.images = null;
                    item.cellBackground = null;
                    item.cellForeground = null;
                    item.cellFont = null;
                } else {
                    Object[] temp;
                    if (item.strings != null) {
                        String[] strings = item.strings;
                        if (index == 0) {
                            item.text = strings[1] != null ? strings[1] : "";
                        }
                        temp = new String[columnCount];
                        System.arraycopy(strings, 0, temp, 0, index);
                        System.arraycopy(strings, index + 1, temp, index, columnCount - index);
                        item.strings = temp;
                    } else if (index == 0) {
                        item.text = "";
                    }
                    if (item.images != null) {
                        Image[] images = item.images;
                        if (index == 0) {
                            item.image = images[1];
                        }
                        temp = new Image[columnCount];
                        System.arraycopy(images, 0, temp, 0, index);
                        System.arraycopy(images, index + 1, temp, index, columnCount - index);
                        item.images = temp;
                    } else if (index == 0) {
                        item.image = null;
                    }
                    if (item.cellBackground != null) {
                        int[] cellBackground = item.cellBackground;
                        temp = new int[columnCount];
                        System.arraycopy(cellBackground, 0, temp, 0, index);
                        System.arraycopy(cellBackground, index + 1, temp, index, columnCount - index);
                        item.cellBackground = (int[])temp;
                    }
                    if (item.cellForeground != null) {
                        int[] cellForeground = item.cellForeground;
                        temp = new int[columnCount];
                        System.arraycopy(cellForeground, 0, temp, 0, index);
                        System.arraycopy(cellForeground, index + 1, temp, index, columnCount - index);
                        item.cellForeground = (int[])temp;
                    }
                    if (item.cellFont != null) {
                        int[] cellFont = item.cellFont;
                        temp = new int[columnCount];
                        System.arraycopy(cellFont, 0, temp, 0, index);
                        System.arraycopy(cellFont, index + 1, temp, index, columnCount - index);
                        item.cellFont = (int[])temp;
                    }
                }
            }
            ++i;
        }
        if (columnCount == 0) {
            int bits = OS.GetWindowLong(this.handle, -16);
            OS.SetWindowLong(this.handle, -16, bits &= 0xFFFF7FFF);
            OS.InvalidateRect(this.handle, null, true);
        } else {
            if (index == 0) {
                this.columns[0].style &= 0xFEFDBFFF;
                this.columns[0].style |= 0x4000;
                HDITEM hdItem = new HDITEM();
                hdItem.mask = 36;
                OS.SendMessage(this.hwndHeader, OS.HDM_GETITEM, index, hdItem);
                hdItem.fmt &= 0xFFFFFFFC;
                hdItem.fmt |= 0;
                OS.SendMessage(this.hwndHeader, OS.HDM_SETITEM, index, hdItem);
            }
            RECT rect = new RECT();
            RECT itemRect = new RECT();
            OS.GetClientRect(this.handle, rect);
            OS.SendMessage(this.hwndHeader, 4615, index - 1, itemRect);
            rect.left = itemRect.right;
            OS.InvalidateRect(this.handle, rect, true);
        }
        this.setScrollWidth();
        i = index;
        while (i < columnCount) {
            this.columns[i].sendEvent(10);
            ++i;
        }
    }

    void destroyItem(TreeItem item) {
        int count;
        int hItem = item.handle;
        int hParent = 0;
        boolean fixRedraw = false;
        if (this.drawCount == 0 && OS.IsWindowVisible(this.handle)) {
            RECT rect = new RECT();
            rect.left = hItem;
            boolean bl = fixRedraw = OS.SendMessage(this.handle, 4356, 0, rect) == 0;
        }
        if (fixRedraw) {
            hParent = OS.SendMessage(this.handle, 4362, 3, hItem);
            OS.UpdateWindow(this.handle);
            OS.SendMessage(this.handle, 11, 0, 0);
        }
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 20;
        this.releaseItems(item.getItems(), tvItem);
        this.releaseItem(item, tvItem);
        if ((this.style & 2) != 0) {
            this.lockSelection = true;
            this.ignoreSelect = true;
            this.ignoreDeselect = true;
        }
        OS.SendMessage(this.handle, 4353, 0, hItem);
        if ((this.style & 2) != 0) {
            this.lockSelection = false;
            this.ignoreSelect = false;
            this.ignoreDeselect = false;
        }
        if (fixRedraw) {
            OS.SendMessage(this.handle, 11, 1, 0);
            OS.ValidateRect(this.handle, null);
            if (OS.SendMessage(this.handle, 4362, 4, hParent) == 0) {
                RECT rect = new RECT();
                rect.left = hParent;
                if (OS.SendMessage(this.handle, 4356, 0, rect) != 0) {
                    OS.InvalidateRect(this.handle, rect, true);
                }
            }
        }
        if ((count = OS.SendMessage(this.handle, 4357, 0, 0)) == 0) {
            if (this.imageList != null) {
                OS.SendMessage(this.handle, 4361, 0, 0);
                if (this.hwndHeader != 0) {
                    OS.SendMessage(this.hwndHeader, 4616, 0, 0);
                }
                this.display.releaseImageList(this.imageList);
            }
            this.imageList = null;
            if (this.hwndParent == 0) {
                this.customDraw = false;
            }
            this.items = new TreeItem[4];
        }
        this.updateScrollBar();
    }

    void enableWidget(boolean enabled) {
        super.enableWidget(enabled);
        if (this.background != -1) {
            this._setBackgroundPixel(enabled ? this.background : -1);
        }
        if (this.hwndParent != 0) {
            OS.EnableWindow(this.hwndParent, enabled);
        }
    }

    Widget findItem(int id) {
        int lParam;
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 20;
        tvItem.hItem = id;
        if (OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem) != 0 && (lParam = tvItem.lParam) >= 0 && lParam < this.items.length) {
            return this.items[lParam];
        }
        return null;
    }

    int getBackgroundPixel() {
        if (!OS.IsWinCE) {
            return this._getBackgroundPixel();
        }
        if (!OS.IsWindowEnabled(this.handle) && this.background != -1) {
            return this.background;
        }
        return this._getBackgroundPixel();
    }

    int getForegroundPixel() {
        if (OS.IsWinCE) {
            return OS.GetSysColor(OS.COLOR_WINDOWTEXT);
        }
        int pixel = OS.SendMessage(this.handle, 4384, 0, 0);
        if (pixel == -1) {
            return OS.GetSysColor(OS.COLOR_WINDOWTEXT);
        }
        return pixel;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 1;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        if (this.hwndHeader == 0) {
            return 0;
        }
        RECT rect = new RECT();
        OS.GetWindowRect(this.hwndHeader, rect);
        return rect.bottom - rect.top;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        if (this.hwndHeader == 0) {
            return false;
        }
        int bits = OS.GetWindowLong(this.hwndHeader, -16);
        return (bits & 0x10000000) != 0;
    }

    Point getImageSize() {
        if (this.imageList != null) {
            return this.imageList.getImageSize();
        }
        return new Point(0, this.getItemHeight());
    }

    public TreeColumn getColumn(int index) {
        this.checkWidget();
        if (this.hwndHeader == 0) {
            this.error(6);
        }
        int count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
        if (index < 0 || index >= count) {
            this.error(6);
        }
        return this.columns[index];
    }

    public int getColumnCount() {
        this.checkWidget();
        if (this.hwndHeader == 0) {
            return 0;
        }
        return OS.SendMessage(this.hwndHeader, 4608, 0, 0);
    }

    public TreeColumn[] getColumns() {
        this.checkWidget();
        if (this.hwndHeader == 0) {
            return new TreeColumn[0];
        }
        int count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
        TreeColumn[] result = new TreeColumn[count];
        System.arraycopy(this.columns, 0, result, 0, count);
        return result;
    }

    public TreeItem getItem(int index) {
        this.checkWidget();
        if (index < 0) {
            this.error(6);
        }
        int hItem = OS.SendMessage(this.handle, 4362, 0, 0);
        while (index-- > 0 && hItem != 0) {
            hItem = OS.SendMessage(this.handle, 4362, 1, hItem);
        }
        if (hItem == 0) {
            this.error(6);
        }
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 20;
        tvItem.hItem = hItem;
        OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
        return this.items[tvItem.lParam];
    }

    public TreeItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        TVHITTESTINFO lpht = new TVHITTESTINFO();
        lpht.x = point.x;
        lpht.y = point.y;
        OS.SendMessage(this.handle, 4369, 0, lpht);
        if (lpht.hItem != 0 && ((this.style & 0x10000) != 0 || (lpht.flags & 0x46) != 0)) {
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 20;
            tvItem.hItem = lpht.hItem;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            return this.items[tvItem.lParam];
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        int hItem = OS.SendMessage(this.handle, 4362, 0, 0);
        if (hItem == 0) {
            return 0;
        }
        return this.getItemCount(hItem);
    }

    int getItemCount(int hItem) {
        int count = 0;
        while (hItem != 0) {
            hItem = OS.SendMessage(this.handle, 4362, 1, hItem);
            ++count;
        }
        return count;
    }

    public int getItemHeight() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 4380, 0, 0);
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        int hItem = OS.SendMessage(this.handle, 4362, 0, 0);
        if (hItem == 0) {
            return new TreeItem[0];
        }
        return this.getItems(hItem);
    }

    TreeItem[] getItems(int hTreeItem) {
        int count = 0;
        int hItem = hTreeItem;
        while (hItem != 0) {
            hItem = OS.SendMessage(this.handle, 4362, 1, hItem);
            ++count;
        }
        int index = 0;
        TreeItem[] result = new TreeItem[count];
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 20;
        tvItem.hItem = hTreeItem;
        while (tvItem.hItem != 0) {
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            TreeItem item = this.items[tvItem.lParam];
            if (item != null) {
                result[index++] = item;
            }
            tvItem.hItem = OS.SendMessage(this.handle, 4362, 1, tvItem.hItem);
        }
        if (index != count) {
            TreeItem[] newResult = new TreeItem[index];
            System.arraycopy(result, 0, newResult, 0, index);
            result = newResult;
        }
        return result;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return this.linesVisible;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    public TreeItem[] getSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int hItem = OS.SendMessage(this.handle, 4362, 9, 0);
            if (hItem == 0) {
                return new TreeItem[0];
            }
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 12;
            tvItem.hItem = hItem;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            if ((tvItem.state & 2) == 0) {
                return new TreeItem[0];
            }
            return new TreeItem[]{this.items[tvItem.lParam]};
        }
        int count = 0;
        TreeItem[] guess = new TreeItem[8];
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 12;
        int oldProc = OS.GetWindowLong(this.handle, -4);
        OS.SetWindowLong(this.handle, -4, TreeProc);
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null) {
                tvItem.hItem = item.handle;
                OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                if ((tvItem.state & 2) != 0) {
                    if (count < guess.length) {
                        guess[count] = item;
                    }
                    ++count;
                }
            }
            ++i;
        }
        OS.SetWindowLong(this.handle, -4, oldProc);
        if (count == 0) {
            return new TreeItem[0];
        }
        if (count == guess.length) {
            return guess;
        }
        TreeItem[] result = new TreeItem[count];
        if (count < guess.length) {
            System.arraycopy(guess, 0, result, 0, count);
            return result;
        }
        OS.SetWindowLong(this.handle, -4, TreeProc);
        int index = 0;
        int i2 = 0;
        while (i2 < this.items.length) {
            TreeItem item = this.items[i2];
            if (item != null) {
                tvItem.hItem = item.handle;
                OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                if ((tvItem.state & 2) != 0) {
                    result[index++] = item;
                }
            }
            ++i2;
        }
        OS.SetWindowLong(this.handle, -4, oldProc);
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int hItem = OS.SendMessage(this.handle, 4362, 9, 0);
            if (hItem == 0) {
                return 0;
            }
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 8;
            tvItem.hItem = hItem;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            if ((tvItem.state & 2) == 0) {
                return 0;
            }
            return 1;
        }
        int count = 0;
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 8;
        int oldProc = OS.GetWindowLong(this.handle, -4);
        OS.SetWindowLong(this.handle, -4, TreeProc);
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null) {
                tvItem.hItem = item.handle;
                OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                if ((tvItem.state & 2) != 0) {
                    ++count;
                }
            }
            ++i;
        }
        OS.SetWindowLong(this.handle, -4, oldProc);
        return count;
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        int hItem = OS.SendMessage(this.handle, 4362, 5, 0);
        if (hItem == 0) {
            return null;
        }
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 4;
        tvItem.hItem = hItem;
        if (OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem) == 0) {
            return null;
        }
        return this.items[tvItem.lParam];
    }

    int imageIndex(Image image) {
        if (image == null) {
            return -2;
        }
        if (this.imageList == null) {
            int hOldList = OS.SendMessage(this.handle, 4360, 0, 0);
            if (hOldList != 0) {
                OS.ImageList_Destroy(hOldList);
            }
            Rectangle bounds = image.getBounds();
            this.imageList = this.display.getImageList(this.style & 0x4000000, bounds.width, bounds.height);
            int index = this.imageList.indexOf(image);
            if (index == -1) {
                index = this.imageList.add(image);
            }
            int hImageList = this.imageList.getHandle();
            OS.SendMessage(this.handle, 4361, 0, hImageList);
            if (this.hwndHeader != 0) {
                OS.SendMessage(this.hwndHeader, 4616, 0, hImageList);
            }
            this.updateScrollBar();
            return index;
        }
        int index = this.imageList.indexOf(image);
        if (index != -1) {
            return index;
        }
        return this.imageList.add(image);
    }

    int indexOf(int hItem, int hChild) {
        int index = 0;
        while (hItem != 0 && hItem != hChild) {
            hItem = OS.SendMessage(this.handle, 4362, 1, hItem);
            ++index;
        }
        return hItem == hChild ? index : -1;
    }

    public int indexOf(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (this.hwndHeader == 0) {
            return -1;
        }
        int count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
        int i = 0;
        while (i < count) {
            if (this.columns[i] == column) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(TreeItem item) {
        int hItem;
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        return (hItem = OS.SendMessage(this.handle, 4362, 0, 0)) == 0 ? -1 : this.indexOf(hItem, item.handle);
    }

    void register() {
        super.register();
        if (this.hwndParent != 0) {
            this.display.addControl(this.hwndParent, this);
        }
    }

    boolean releaseItem(TreeItem item, TVITEM tvItem) {
        int hItem = item.handle;
        if (hItem == this.hAnchor) {
            this.hAnchor = 0;
        }
        if (hItem == this.hInsert) {
            this.hInsert = 0;
        }
        if (item.isDisposed()) {
            return false;
        }
        tvItem.hItem = hItem;
        OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
        this.items[tvItem.lParam] = null;
        return true;
    }

    void releaseItems(TreeItem[] nodes, TVITEM tvItem) {
        int i = 0;
        while (i < nodes.length) {
            TreeItem item = nodes[i];
            TreeItem[] sons = item.getItems();
            if (sons.length != 0) {
                this.releaseItems(sons, tvItem);
            }
            if (this.releaseItem(item, tvItem)) {
                item.releaseResources();
            }
            ++i;
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.hwndHeader = 0;
        this.hwndParent = 0;
    }

    void releaseWidget() {
        int hOldList;
        int columnCount = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.releaseResources();
            }
            ++i;
        }
        this.items = null;
        i = 0;
        while (i < columnCount) {
            TreeColumn column = this.columns[i];
            if (!column.isDisposed()) {
                column.releaseResources();
            }
            ++i;
        }
        this.columns = null;
        this.customDraw = false;
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 4361, 0, 0);
            OS.SendMessage(this.hwndHeader, 4616, 0, 0);
            this.display.releaseImageList(this.imageList);
        } else {
            hOldList = OS.SendMessage(this.handle, 4360, 0, 0);
            OS.SendMessage(this.handle, 4361, 0, 0);
            OS.SendMessage(this.hwndHeader, 4616, 0, 0);
            if (hOldList != 0) {
                OS.ImageList_Destroy(hOldList);
            }
        }
        this.imageList = null;
        hOldList = OS.SendMessage(this.handle, 4360, 2, 0);
        OS.SendMessage(this.handle, 4361, 2, 0);
        if (hOldList != 0) {
            OS.ImageList_Destroy(hOldList);
        }
        super.releaseWidget();
    }

    public void removeAll() {
        boolean redraw;
        this.checkWidget();
        this.ignoreSelect = true;
        this.ignoreDeselect = true;
        boolean bl = redraw = this.drawCount == 0 && OS.IsWindowVisible(this.handle);
        if (redraw) {
            OS.DefWindowProc(this.handle, 11, 0, 0);
        }
        int result = OS.SendMessage(this.handle, 4353, 0, -65536);
        if (redraw) {
            OS.DefWindowProc(this.handle, 11, 1, 0);
            OS.InvalidateRect(this.handle, null, true);
        }
        this.ignoreSelect = false;
        this.ignoreDeselect = false;
        if (result == 0) {
            this.error(15);
        }
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.releaseResources();
            }
            ++i;
        }
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 4361, 0, 0);
            if (this.hwndHeader != 0) {
                OS.SendMessage(this.hwndHeader, 4616, 0, 0);
            }
            this.display.releaseImageList(this.imageList);
        }
        this.imageList = null;
        if (this.hwndParent == 0) {
            this.customDraw = false;
        }
        this.items = new TreeItem[4];
        this.hInsert = 0;
        this.hAnchor = 0;
        this.updateScrollBar();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, listener);
        this.eventTable.unhook(18, listener);
    }

    public void setInsertMark(TreeItem item, boolean before) {
        this.checkWidget();
        int hItem = 0;
        if (item != null) {
            if (item.isDisposed()) {
                this.error(5);
            }
            hItem = item.handle;
        }
        this.hInsert = hItem;
        this.insertAfter = !before;
        OS.SendMessage(this.handle, 4378, this.insertAfter ? 1 : 0, this.hInsert);
    }

    public void setLinesVisible(boolean show) {
        this.checkWidget();
        if (this.linesVisible == show) {
            return;
        }
        this.linesVisible = show;
        OS.InvalidateRect(this.handle, null, true);
    }

    int scrolledHandle() {
        if (this.hwndHeader == 0) {
            return this.handle;
        }
        int count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
        return count == 0 ? this.handle : this.hwndParent;
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 8;
        tvItem.state = 2;
        tvItem.stateMask = 2;
        int oldProc = OS.GetWindowLong(this.handle, -4);
        OS.SetWindowLong(this.handle, -4, TreeProc);
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null) {
                tvItem.hItem = item.handle;
                OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
            }
            ++i;
        }
        OS.SetWindowLong(this.handle, -4, oldProc);
    }

    void setBackgroundPixel(int pixel) {
        if (this.background == pixel) {
            return;
        }
        this.background = pixel;
        if (OS.IsWindowEnabled(this.handle)) {
            this._setBackgroundPixel(pixel);
        }
    }

    void setBounds(int x, int y, int width, int height, int flags) {
        int hItem;
        boolean fixSelection = false;
        if ((flags & 1) == 0 && (width != 0 || height != 0) && OS.SendMessage(this.handle, 4368, 0, 0) == 0) {
            fixSelection = true;
        }
        super.setBounds(x, y, width, height, flags);
        if (fixSelection && (hItem = OS.SendMessage(this.handle, 4362, 9, 0)) != 0) {
            this.showItem(hItem);
        }
    }

    void setCursor() {
        Cursor cursor = this.findCursor();
        int hCursor = cursor == null ? OS.LoadCursor(0, 32512) : cursor.handle;
        OS.SetCursor(hCursor);
    }

    void setCheckboxImageList() {
        int height;
        if ((this.style & 0x20) == 0) {
            return;
        }
        int count = 5;
        int width = height = OS.SendMessage(this.handle, 4380, 0, 0);
        int flags = ImageList.COLOR_FLAGS;
        if ((this.style & 0x4000000) != 0) {
            flags |= 0x2000;
        }
        if (OS.COMCTL32_MAJOR < 6 || !OS.IsAppThemed()) {
            flags |= 1;
        }
        int hImageList = OS.ImageList_Create(width, height, flags, count, count);
        int hDC = OS.GetDC(this.handle);
        int memDC = OS.CreateCompatibleDC(hDC);
        int hBitmap = OS.CreateCompatibleBitmap(hDC, width * count, height);
        int hOldBitmap = OS.SelectObject(memDC, hBitmap);
        RECT rect = new RECT();
        OS.SetRect(rect, 0, 0, width * count, height);
        int clrBackground = this._getBackgroundPixel();
        int hBrush = OS.CreateSolidBrush(clrBackground);
        OS.FillRect(memDC, rect, hBrush);
        OS.DeleteObject(hBrush);
        int oldFont = OS.SelectObject(hDC, this.defaultFont());
        TEXTMETRIC tm = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(hDC, tm);
        OS.SelectObject(hDC, oldFont);
        int itemWidth = Math.min(tm.tmHeight, width);
        int itemHeight = Math.min(tm.tmHeight, height);
        int left = (width - itemWidth) / 2;
        int top = (height - itemHeight) / 2 + 1;
        OS.SetRect(rect, left + width, top, left + width + itemWidth, top + itemHeight);
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int hTheme = OS.OpenThemeData(this.handle, BUTTON);
            OS.DrawThemeBackground(hTheme, memDC, 3, 1, rect, null);
            rect.left += width;
            rect.right += width;
            OS.DrawThemeBackground(hTheme, memDC, 3, 5, rect, null);
            rect.left += width;
            rect.right += width;
            OS.DrawThemeBackground(hTheme, memDC, 3, 1, rect, null);
            rect.left += width;
            rect.right += width;
            OS.DrawThemeBackground(hTheme, memDC, 3, 9, rect, null);
            OS.CloseThemeData(hTheme);
        } else {
            OS.DrawFrameControl(memDC, rect, 4, 16384);
            rect.left += width;
            rect.right += width;
            OS.DrawFrameControl(memDC, rect, 4, 17408);
            rect.left += width;
            rect.right += width;
            OS.DrawFrameControl(memDC, rect, 4, 16640);
            rect.left += width;
            rect.right += width;
            OS.DrawFrameControl(memDC, rect, 4, 17664);
        }
        OS.SelectObject(memDC, hOldBitmap);
        OS.DeleteDC(memDC);
        OS.ReleaseDC(this.handle, hDC);
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            OS.ImageList_Add(hImageList, hBitmap, 0);
        } else {
            OS.ImageList_AddMasked(hImageList, hBitmap, clrBackground);
        }
        OS.DeleteObject(hBitmap);
        int hOldList = OS.SendMessage(this.handle, 4360, 2, 0);
        OS.SendMessage(this.handle, 4361, 2, hImageList);
        if (hOldList != 0) {
            OS.ImageList_Destroy(hOldList);
        }
    }

    void setForegroundPixel(int pixel) {
        if (this.foreground == pixel) {
            return;
        }
        this.foreground = pixel;
        OS.SendMessage(this.handle, 4382, 0, pixel);
    }

    public void setHeaderVisible(boolean show) {
        this.checkWidget();
        if (this.hwndHeader == 0) {
            if (!show) {
                return;
            }
            this.createParent();
        }
        int bits = OS.GetWindowLong(this.hwndHeader, -16);
        if (show) {
            if ((bits & 8) == 0) {
                return;
            }
            OS.SetWindowLong(this.hwndHeader, -16, bits &= 0xFFFFFFF7);
            OS.ShowWindow(this.hwndHeader, 5);
        } else {
            if ((bits & 8) != 0) {
                return;
            }
            OS.SetWindowLong(this.hwndHeader, -16, bits |= 8);
            OS.ShowWindow(this.hwndHeader, 0);
        }
        this.setScrollWidth();
        this.updateScrollBar();
    }

    public void setRedraw(boolean redraw) {
        int count;
        this.checkWidget();
        int hItem = 0;
        if (redraw && this.drawCount == 1 && (count = OS.SendMessage(this.handle, 4357, 0, 0)) == 0) {
            TVINSERTSTRUCT tvInsert = new TVINSERTSTRUCT();
            tvInsert.hInsertAfter = -65535;
            hItem = OS.SendMessage(this.handle, OS.TVM_INSERTITEM, 0, tvInsert);
        }
        super.setRedraw(redraw);
        if (hItem != 0) {
            OS.SendMessage(this.handle, 4353, 0, hItem);
        }
    }

    void setScrollWidth() {
        if (this.hwndHeader == 0 || this.hwndParent == 0) {
            return;
        }
        int width = 0;
        HDITEM hdItem = new HDITEM();
        int count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
        int i = 0;
        while (i < count) {
            hdItem.mask = 1;
            OS.SendMessage(this.hwndHeader, OS.HDM_GETITEM, i, hdItem);
            width += hdItem.cxy;
            ++i;
        }
        int left = 0;
        RECT rect = new RECT();
        SCROLLINFO info = new SCROLLINFO();
        info.cbSize = 28;
        info.fMask = 3;
        if (count == 0) {
            OS.GetScrollInfo(this.hwndParent, 0, info);
            info.nPage = info.nMax + 1;
            OS.SetScrollInfo(this.hwndParent, 0, info, true);
            OS.GetScrollInfo(this.hwndParent, 1, info);
            info.nPage = info.nMax + 1;
            OS.SetScrollInfo(this.hwndParent, 1, info, true);
        } else {
            OS.GetClientRect(this.hwndParent, rect);
            OS.GetScrollInfo(this.hwndParent, 0, info);
            info.nMax = width;
            info.nPage = rect.right - rect.left;
            OS.SetScrollInfo(this.hwndParent, 0, info, true);
            info.fMask = 4;
            OS.GetScrollInfo(this.hwndParent, 0, info);
            left = info.nPos;
        }
        OS.GetClientRect(this.hwndParent, rect);
        int hHeap = OS.GetProcessHeap();
        HDLAYOUT playout = new HDLAYOUT();
        playout.prc = OS.HeapAlloc(hHeap, 8, 16);
        playout.pwpos = OS.HeapAlloc(hHeap, 8, 28);
        OS.MoveMemory(playout.prc, rect, 16);
        OS.SendMessage(this.hwndHeader, 4613, 0, playout);
        WINDOWPOS pos = new WINDOWPOS();
        OS.MoveMemory(pos, playout.pwpos, 28);
        if (playout.prc != 0) {
            OS.HeapFree(hHeap, 0, playout.prc);
        }
        if (playout.pwpos != 0) {
            OS.HeapFree(hHeap, 0, playout.pwpos);
        }
        this.SetWindowPos(this.hwndHeader, 0, pos.x - left, pos.y, pos.cx + left, pos.cy, 16);
        int w = pos.cx + (count == 0 ? 0 : OS.GetSystemMetrics(2));
        int h = rect.bottom - rect.top - pos.cy;
        boolean oldIgnore = this.ignoreResize;
        this.ignoreResize = true;
        this.SetWindowPos(this.handle, 0, pos.x - left, pos.y + pos.cy, w + left, h, 20);
        this.ignoreResize = oldIgnore;
    }

    public void setSelection(TreeItem[] items) {
        int length;
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        if ((length = items.length) == 0 || (this.style & 4) != 0 && length > 1) {
            this.deselectAll();
            return;
        }
        TreeItem item = items[0];
        if (item != null) {
            if (item.isDisposed()) {
                this.error(5);
            }
            int hOldItem = OS.SendMessage(this.handle, 4362, 9, 0);
            this.hAnchor = item.handle;
            int hNewItem = this.hAnchor;
            boolean fixScroll = this.checkScroll(hNewItem);
            if (fixScroll) {
                OS.SendMessage(this.handle, 11, 1, 0);
                OS.DefWindowProc(this.handle, 11, 0, 0);
            }
            this.ignoreSelect = true;
            OS.SendMessage(this.handle, 4363, 9, hNewItem);
            this.ignoreSelect = false;
            if (OS.SendMessage(this.handle, 4368, 0, 0) == 0) {
                OS.SendMessage(this.handle, 4363, 5, hNewItem);
            }
            if (fixScroll) {
                OS.DefWindowProc(this.handle, 11, 1, 0);
                OS.SendMessage(this.handle, 11, 0, 0);
            }
            if (hOldItem == hNewItem) {
                TVITEM tvItem = new TVITEM();
                tvItem.mask = 8;
                tvItem.state = 2;
                tvItem.stateMask = 2;
                tvItem.hItem = hNewItem;
                OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                this.showItem(hNewItem);
            }
        }
        if ((this.style & 4) != 0) {
            return;
        }
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 8;
        tvItem.stateMask = 2;
        int oldProc = OS.GetWindowLong(this.handle, -4);
        OS.SetWindowLong(this.handle, -4, TreeProc);
        int i = 0;
        while (i < this.items.length) {
            item = this.items[i];
            if (item != null) {
                int index = 0;
                while (index < length) {
                    if (items[index] == item) break;
                    ++index;
                }
                tvItem.hItem = item.handle;
                OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                if ((tvItem.state & 2) != 0) {
                    if (index == length) {
                        tvItem.state = 0;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                    }
                } else if (index != length) {
                    tvItem.state = 2;
                    OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                }
            }
            ++i;
        }
        OS.SetWindowLong(this.handle, -4, oldProc);
    }

    public void setTopItem(TreeItem item) {
        int hItem;
        boolean fixScroll;
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        if (item.isDisposed()) {
            SWT.error(5);
        }
        if (fixScroll = this.checkScroll(hItem = item.handle)) {
            OS.SendMessage(this.handle, 11, 1, 0);
            OS.DefWindowProc(this.handle, 11, 0, 0);
        }
        OS.SendMessage(this.handle, 4363, 5, hItem);
        if (fixScroll) {
            OS.DefWindowProc(this.handle, 11, 1, 0);
            OS.SendMessage(this.handle, 11, 0, 0);
        }
        this.updateScrollBar();
    }

    void showItem(int hItem) {
        if (OS.SendMessage(this.handle, 4368, 0, 0) == 0) {
            boolean fixScroll = this.checkScroll(hItem);
            if (fixScroll) {
                OS.SendMessage(this.handle, 11, 1, 0);
                OS.DefWindowProc(this.handle, 11, 0, 0);
            }
            OS.SendMessage(this.handle, 4363, 5, hItem);
            OS.SendMessage(this.handle, 276, 6, 0);
            if (fixScroll) {
                OS.DefWindowProc(this.handle, 11, 1, 0);
                OS.SendMessage(this.handle, 11, 0, 0);
            }
        } else {
            boolean scroll = true;
            RECT itemRect = new RECT();
            itemRect.left = hItem;
            if (OS.SendMessage(this.handle, 4356, 1, itemRect) != 0) {
                this.forceResize();
                RECT rect = new RECT();
                OS.GetClientRect(this.handle, rect);
                POINT pt = new POINT();
                pt.x = itemRect.left;
                pt.y = itemRect.top;
                if (OS.PtInRect(rect, pt)) {
                    pt.y = itemRect.bottom;
                    if (OS.PtInRect(rect, pt)) {
                        scroll = false;
                    }
                }
            }
            if (scroll) {
                boolean fixScroll = this.checkScroll(hItem);
                if (fixScroll) {
                    OS.SendMessage(this.handle, 11, 1, 0);
                    OS.DefWindowProc(this.handle, 11, 0, 0);
                }
                OS.SendMessage(this.handle, 4372, 0, hItem);
                if (fixScroll) {
                    OS.DefWindowProc(this.handle, 11, 1, 0);
                    OS.SendMessage(this.handle, 11, 0, 0);
                }
            }
        }
        if (this.hwndParent != 0) {
            RECT itemRect = new RECT();
            itemRect.left = hItem;
            if (OS.SendMessage(this.handle, 4356, 1, itemRect) != 0) {
                this.forceResize();
                RECT rect = new RECT();
                OS.GetClientRect(this.hwndParent, rect);
                OS.MapWindowPoints(this.hwndParent, this.handle, rect, 2);
                POINT pt = new POINT();
                pt.x = itemRect.left;
                pt.y = itemRect.top;
                if (!OS.PtInRect(rect, pt)) {
                    pt.y = itemRect.bottom;
                    if (!OS.PtInRect(rect, pt)) {
                        SCROLLINFO info = new SCROLLINFO();
                        info.cbSize = 28;
                        info.fMask = 4;
                        info.nPos = Math.max(0, pt.x - 1);
                        OS.SetScrollInfo(this.hwndParent, 0, info, true);
                        this.setScrollWidth();
                    }
                }
            }
        }
        this.updateScrollBar();
    }

    public void showColumn(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (column.parent != this) {
            return;
        }
        int index = this.indexOf(column);
        if (index == -1) {
            return;
        }
        int count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
        if (index >= 0 && index < count && this.hwndParent != 0) {
            this.forceResize();
            RECT rect = new RECT();
            OS.GetClientRect(this.hwndParent, rect);
            OS.MapWindowPoints(this.hwndParent, this.handle, rect, 2);
            int x = 0;
            HDITEM hdItem = new HDITEM();
            int i = 0;
            while (i < index) {
                hdItem.mask = 1;
                OS.SendMessage(this.hwndHeader, OS.HDM_GETITEM, i, hdItem);
                x += hdItem.cxy;
                ++i;
            }
            POINT pt = new POINT();
            pt.x = x;
            pt.y = rect.top;
            if (!OS.PtInRect(rect, pt)) {
                SCROLLINFO info = new SCROLLINFO();
                info.cbSize = 28;
                info.fMask = 4;
                info.nPos = Math.max(0, pt.x - 1);
                OS.SetScrollInfo(this.hwndParent, 0, info, true);
                this.setScrollWidth();
            }
        }
    }

    public void showItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        this.showItem(item.handle);
    }

    public void showSelection() {
        this.checkWidget();
        int hItem = 0;
        if ((this.style & 4) != 0) {
            hItem = OS.SendMessage(this.handle, 4362, 9, 0);
            if (hItem == 0) {
                return;
            }
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 8;
            tvItem.hItem = hItem;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            if ((tvItem.state & 2) == 0) {
                return;
            }
        } else {
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 8;
            int oldProc = OS.GetWindowLong(this.handle, -4);
            OS.SetWindowLong(this.handle, -4, TreeProc);
            int index = 0;
            while (index < this.items.length) {
                TreeItem item = this.items[index];
                if (item != null) {
                    tvItem.hItem = item.handle;
                    OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                    if ((tvItem.state & 2) != 0) {
                        hItem = tvItem.hItem;
                        break;
                    }
                }
                ++index;
            }
            OS.SetWindowLong(this.handle, -4, oldProc);
        }
        if (hItem != 0) {
            this.showItem(hItem);
        }
    }

    void showWidget(boolean visible) {
        super.showWidget(visible);
        if (this.hwndParent != 0) {
            OS.ShowWindow(this.hwndParent, visible ? 5 : 0);
        }
    }

    String toolTipText(NMTTDISPINFO hdr) {
        int hwndToolTip = OS.SendMessage(this.handle, 4377, 0, 0);
        if (hwndToolTip == hdr.hwndFrom && this.toolTipText != null) {
            return "";
        }
        return super.toolTipText(hdr);
    }

    int topHandle() {
        return this.hwndParent != 0 ? this.hwndParent : this.handle;
    }

    void updateScrollBar() {
        int columnCount;
        if (this.hwndParent != 0 && (columnCount = OS.SendMessage(this.hwndHeader, 4608, 0, 0)) != 0) {
            SCROLLINFO info = new SCROLLINFO();
            info.cbSize = 28;
            info.fMask = 23;
            int itemCount = OS.SendMessage(this.handle, 4357, 0, 0);
            if (itemCount == 0) {
                OS.GetScrollInfo(this.hwndParent, 1, info);
                info.nPage = info.nMax + 1;
                OS.SetScrollInfo(this.hwndParent, 1, info, true);
            } else {
                OS.GetScrollInfo(this.handle, 1, info);
                OS.SetScrollInfo(this.hwndParent, 1, info, true);
            }
        }
    }

    int widgetStyle() {
        int bits = super.widgetStyle() | 0x20 | 4 | 1;
        bits = (this.style & 0x10000) != 0 ? (bits |= 0x1000) : (bits |= 2);
        return bits;
    }

    TCHAR windowClass() {
        return TreeClass;
    }

    int windowProc() {
        return TreeProc;
    }

    int windowProc(int hwnd, int msg, int wParam, int lParam) {
        if (this.hwndParent != 0 && hwnd == this.hwndParent) {
            switch (msg) {
                case 3: {
                    this.sendEvent(10);
                    return 0;
                }
                case 5: {
                    this.setScrollWidth();
                    if (this.ignoreResize) {
                        return 0;
                    }
                    this.setResizeChildren(false);
                    int code = this.callWindowProc(hwnd, 5, wParam, lParam);
                    this.sendEvent(11);
                    if (this.isDisposed()) {
                        return 0;
                    }
                    if (this.layout != null) {
                        this.markLayout(false, false);
                        this.updateLayout(false, false);
                    }
                    this.setResizeChildren(true);
                    return code;
                }
                case 21: 
                case 78: 
                case 273: {
                    return OS.SendMessage(this.handle, msg, wParam, lParam);
                }
                case 277: {
                    SCROLLINFO info = new SCROLLINFO();
                    info.cbSize = 28;
                    info.fMask = 23;
                    OS.GetScrollInfo(this.hwndParent, 1, info);
                    OS.SetScrollInfo(this.handle, 1, info, true);
                    int code = OS.SendMessage(this.handle, 277, wParam, lParam);
                    OS.GetScrollInfo(this.handle, 1, info);
                    OS.SetScrollInfo(this.hwndParent, 1, info, true);
                    return code;
                }
                case 276: {
                    if (this.horizontalBar != null && (lParam == 0 || lParam == this.hwndParent)) {
                        this.wmScroll(this.horizontalBar, true, this.hwndParent, 276, wParam, lParam);
                    }
                    this.setScrollWidth();
                }
            }
            return this.callWindowProc(hwnd, msg, wParam, lParam);
        }
        int code = super.windowProc(this.handle, msg, wParam, lParam);
        switch (msg) {
            case 5: 
            case 48: 
            case 256: 
            case 257: 
            case 258: 
            case 260: 
            case 261: 
            case 262: 
            case 275: 
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 646: 
            case 673: 
            case 675: {
                this.updateScrollBar();
            }
        }
        return code;
    }

    LRESULT WM_CHAR(int wParam, int lParam) {
        LRESULT result = super.WM_CHAR(wParam, lParam);
        if (result != null) {
            return result;
        }
        switch (wParam) {
            case 32: {
                int hItem = OS.SendMessage(this.handle, 4362, 9, 0);
                if (hItem != 0) {
                    this.hAnchor = hItem;
                    OS.SendMessage(this.handle, 4372, 0, hItem);
                    TVITEM tvItem = new TVITEM();
                    tvItem.mask = 12;
                    tvItem.hItem = hItem;
                    if ((this.style & 0x20) != 0) {
                        tvItem.stateMask = 61440;
                        OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                        int state = tvItem.state >> 12;
                        state = (state & 1) != 0 ? ++state : --state;
                        tvItem.state = state << 12;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                        if (!OS.IsWinCE) {
                            int id = hItem;
                            if (OS.COMCTL32_MAJOR >= 6) {
                                id = OS.SendMessage(this.handle, 4395, hItem, 0);
                            }
                            OS.NotifyWinEvent(32773, this.handle, -4, id);
                        }
                    }
                    tvItem.stateMask = 2;
                    OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                    tvItem.state = (this.style & 2) != 0 && OS.GetKeyState(17) < 0 ? ((tvItem.state & 2) != 0 ? (tvItem.state &= 0xFFFFFFFD) : (tvItem.state |= 2)) : (tvItem.state |= 2);
                    OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                    Event event = new Event();
                    event.item = this.items[tvItem.lParam];
                    this.postEvent(13, event);
                    if ((this.style & 0x20) != 0) {
                        event = new Event();
                        event.item = this.items[tvItem.lParam];
                        event.detail = 32;
                        this.postEvent(13, event);
                    }
                }
                return LRESULT.ZERO;
            }
            case 13: {
                Event event = new Event();
                int hItem = OS.SendMessage(this.handle, 4362, 9, 0);
                if (hItem != 0) {
                    TVITEM tvItem = new TVITEM();
                    tvItem.hItem = hItem;
                    tvItem.mask = 4;
                    OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                    event.item = this.items[tvItem.lParam];
                }
                this.postEvent(14, event);
                return LRESULT.ZERO;
            }
            case 27: {
                return LRESULT.ZERO;
            }
        }
        return result;
    }

    LRESULT WM_GETOBJECT(int wParam, int lParam) {
        if (((this.style & 0x20) != 0 || this.hwndParent != 0) && this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return super.WM_GETOBJECT(wParam, lParam);
    }

    LRESULT WM_KEYDOWN(int wParam, int lParam) {
        LRESULT result = super.WM_KEYDOWN(wParam, lParam);
        if (result != null) {
            return result;
        }
        switch (wParam) {
            case 32: {
                return LRESULT.ZERO;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 40: {
                int hItem;
                OS.SendMessage(this.handle, 295, 3, 0);
                if ((this.style & 4) != 0) break;
                if (OS.GetKeyState(16) < 0 && (hItem = OS.SendMessage(this.handle, 4362, 9, 0)) != 0) {
                    if (this.hAnchor == 0) {
                        this.hAnchor = hItem;
                    }
                    this.ignoreDeselect = true;
                    this.ignoreSelect = true;
                    int code = this.callWindowProc(this.handle, 256, wParam, lParam);
                    this.ignoreDeselect = false;
                    this.ignoreSelect = false;
                    int hNewItem = OS.SendMessage(this.handle, 4362, 9, 0);
                    TVITEM tvItem = new TVITEM();
                    tvItem.mask = 8;
                    tvItem.stateMask = 2;
                    int hDeselectItem = hItem;
                    RECT rect1 = new RECT();
                    rect1.left = this.hAnchor;
                    OS.SendMessage(this.handle, 4356, 1, rect1);
                    RECT rect2 = new RECT();
                    rect2.left = hDeselectItem;
                    OS.SendMessage(this.handle, 4356, 1, rect2);
                    int flags = rect1.top < rect2.top ? 7 : 6;
                    while (hDeselectItem != this.hAnchor) {
                        tvItem.hItem = hDeselectItem;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                        hDeselectItem = OS.SendMessage(this.handle, 4362, flags, hDeselectItem);
                    }
                    int hSelectItem = this.hAnchor;
                    rect1.left = hNewItem;
                    OS.SendMessage(this.handle, 4356, 1, rect1);
                    rect2.left = hSelectItem;
                    OS.SendMessage(this.handle, 4356, 1, rect2);
                    tvItem.state = 2;
                    flags = rect1.top < rect2.top ? 7 : 6;
                    while (hSelectItem != hNewItem) {
                        tvItem.hItem = hSelectItem;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                        hSelectItem = OS.SendMessage(this.handle, 4362, flags, hSelectItem);
                    }
                    tvItem.hItem = hNewItem;
                    OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                    tvItem.mask = 4;
                    tvItem.hItem = hNewItem;
                    OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                    Event event = new Event();
                    event.item = this.items[tvItem.lParam];
                    this.postEvent(13, event);
                    return new LRESULT(code);
                }
                if (OS.GetKeyState(17) < 0 && (hItem = OS.SendMessage(this.handle, 4362, 9, 0)) != 0) {
                    TVITEM tvItem = new TVITEM();
                    tvItem.mask = 8;
                    tvItem.stateMask = 2;
                    tvItem.hItem = hItem;
                    OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                    boolean oldSelected = (tvItem.state & 2) != 0;
                    int hNewItem = 0;
                    block4 : switch (wParam) {
                        case 38: {
                            hNewItem = OS.SendMessage(this.handle, 4362, 7, hItem);
                            break;
                        }
                        case 40: {
                            hNewItem = OS.SendMessage(this.handle, 4362, 6, hItem);
                            break;
                        }
                        case 36: {
                            hNewItem = OS.SendMessage(this.handle, 4362, 0, 0);
                            break;
                        }
                        case 33: {
                            hNewItem = OS.SendMessage(this.handle, 4362, 5, 0);
                            if (hNewItem != hItem) break;
                            OS.SendMessage(this.handle, 277, 2, 0);
                            hNewItem = OS.SendMessage(this.handle, 4362, 5, 0);
                            break;
                        }
                        case 34: {
                            int hVisible;
                            RECT rect = new RECT();
                            RECT clientRect = new RECT();
                            OS.GetClientRect(this.handle, clientRect);
                            hNewItem = OS.SendMessage(this.handle, 4362, 5, 0);
                            while ((hVisible = OS.SendMessage(this.handle, 4362, 6, hNewItem)) != 0) {
                                rect.left = hVisible;
                                OS.SendMessage(this.handle, 4356, 1, rect);
                                if (rect.bottom > clientRect.bottom) break block4;
                                hNewItem = hVisible;
                                if (hNewItem == hItem) {
                                    OS.SendMessage(this.handle, 277, 3, 0);
                                }
                                if (hNewItem != 0) continue;
                                break block4;
                            }
                            break;
                        }
                        case 35: {
                            hNewItem = OS.SendMessage(this.handle, 4362, 10, 0);
                        }
                    }
                    if (hNewItem != 0) {
                        boolean newSelected;
                        OS.SendMessage(this.handle, 4372, 0, hNewItem);
                        tvItem.hItem = hNewItem;
                        OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                        boolean bl = newSelected = (tvItem.state & 2) != 0;
                        if (!newSelected && this.drawCount == 0) {
                            OS.UpdateWindow(this.handle);
                            OS.DefWindowProc(this.handle, 11, 0, 0);
                        }
                        this.ignoreSelect = true;
                        OS.SendMessage(this.handle, 4363, 9, hNewItem);
                        this.ignoreSelect = false;
                        if (oldSelected) {
                            tvItem.state = 2;
                            tvItem.hItem = hItem;
                            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                        }
                        if (!newSelected) {
                            tvItem.state = 0;
                            tvItem.hItem = hNewItem;
                            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                        }
                        if (!newSelected && this.drawCount == 0) {
                            RECT rect1 = new RECT();
                            RECT rect2 = new RECT();
                            rect1.left = hItem;
                            rect2.left = hNewItem;
                            int bits = OS.GetWindowLong(this.handle, -16);
                            int fItemRect = (bits & 0x1000) != 0 ? 0 : 1;
                            OS.SendMessage(this.handle, 4356, fItemRect, rect1);
                            OS.SendMessage(this.handle, 4356, fItemRect, rect2);
                            OS.DefWindowProc(this.handle, 11, 1, 0);
                            if (OS.IsWinCE) {
                                OS.InvalidateRect(this.handle, rect1, false);
                                OS.InvalidateRect(this.handle, rect2, false);
                                OS.UpdateWindow(this.handle);
                            } else {
                                int flags = 257;
                                OS.RedrawWindow(this.handle, rect1, 0, flags);
                                OS.RedrawWindow(this.handle, rect2, 0, flags);
                            }
                        }
                        return LRESULT.ZERO;
                    }
                }
                int code = this.callWindowProc(this.handle, 256, wParam, lParam);
                this.hAnchor = OS.SendMessage(this.handle, 4362, 9, 0);
                return new LRESULT(code);
            }
        }
        return result;
    }

    LRESULT WM_KILLFOCUS(int wParam, int lParam) {
        LRESULT result = super.WM_KILLFOCUS(wParam, lParam);
        if ((this.style & 4) != 0) {
            return result;
        }
        OS.InvalidateRect(this.handle, null, false);
        return result;
    }

    LRESULT WM_LBUTTONDBLCLK(int wParam, int lParam) {
        TVHITTESTINFO lpht = new TVHITTESTINFO();
        lpht.x = (short)(lParam & 0xFFFF);
        lpht.y = (short)(lParam >> 16);
        OS.SendMessage(this.handle, 4369, 0, lpht);
        if ((this.style & 0x20) != 0 && (lpht.flags & 0x40) != 0) {
            this.sendMouseEvent(3, 1, this.handle, 513, wParam, lParam);
            this.sendMouseEvent(8, 1, this.handle, 515, wParam, lParam);
            if (OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            TVITEM tvItem = new TVITEM();
            tvItem.hItem = lpht.hItem;
            tvItem.mask = 12;
            tvItem.stateMask = 61440;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            int state = tvItem.state >> 12;
            state = (state & 1) != 0 ? ++state : --state;
            tvItem.state = state << 12;
            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
            if (!OS.IsWinCE) {
                int id = tvItem.hItem;
                if (OS.COMCTL32_MAJOR >= 6) {
                    id = OS.SendMessage(this.handle, 4395, tvItem.hItem, 0);
                }
                OS.NotifyWinEvent(32773, this.handle, -4, id);
            }
            Event event = new Event();
            event.item = this.items[tvItem.lParam];
            event.detail = 32;
            this.postEvent(13, event);
            return LRESULT.ZERO;
        }
        LRESULT result = super.WM_LBUTTONDBLCLK(wParam, lParam);
        if (lpht.hItem != 0 && ((this.style & 0x10000) != 0 || (lpht.flags & 0x46) != 0)) {
            Event event = new Event();
            TVITEM tvItem = new TVITEM();
            tvItem.hItem = lpht.hItem;
            tvItem.mask = 4;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            event.item = this.items[tvItem.lParam];
            this.postEvent(14, event);
        }
        return result;
    }

    LRESULT WM_LBUTTONDOWN(int wParam, int lParam) {
        TVHITTESTINFO lpht = new TVHITTESTINFO();
        lpht.x = (short)(lParam & 0xFFFF);
        lpht.y = (short)(lParam >> 16);
        OS.SendMessage(this.handle, 4369, 0, lpht);
        if (lpht.hItem == 0 || (lpht.flags & 0x10) != 0) {
            TVITEM tvItem;
            int hSelection;
            this.sendMouseEvent(3, 1, this.handle, 513, wParam, lParam);
            boolean fixSelection = false;
            boolean deselected = false;
            if (lpht.hItem != 0 && (this.style & 2) != 0 && (hSelection = OS.SendMessage(this.handle, 4362, 9, 0)) != 0) {
                tvItem = new TVITEM();
                tvItem.mask = 12;
                tvItem.hItem = lpht.hItem;
                OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                if ((tvItem.state & 0x20) != 0) {
                    fixSelection = true;
                    tvItem.stateMask = 2;
                    int hParent = OS.SendMessage(this.handle, 4362, 3, lpht.hItem);
                    int hLast = OS.SendMessage(this.handle, 4362, 10, lpht.hItem);
                    int hNext = OS.SendMessage(this.handle, 4362, 6, lpht.hItem);
                    while (hNext != 0 && hNext != hLast) {
                        tvItem.hItem = hNext;
                        OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                        if ((tvItem.state & 2) != 0) {
                            deselected = true;
                        }
                        tvItem.state = 0;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                        hNext = OS.SendMessage(this.handle, 4362, 6, hNext);
                        if (hNext == 0 || hParent == OS.SendMessage(this.handle, 4362, 3, hNext)) break;
                    }
                }
            }
            this.gestureCompleted = false;
            this.dragStarted = false;
            if (fixSelection) {
                this.lockSelection = true;
                this.ignoreSelect = true;
                this.ignoreDeselect = true;
            }
            int code = this.callWindowProc(this.handle, 513, wParam, lParam);
            if (fixSelection) {
                this.lockSelection = false;
                this.ignoreSelect = false;
                this.ignoreDeselect = false;
            }
            if (this.dragStarted && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            if (deselected) {
                tvItem = new TVITEM();
                tvItem.mask = 4;
                tvItem.hItem = lpht.hItem;
                OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                Event event = new Event();
                event.item = this.items[tvItem.lParam];
                this.postEvent(13, event);
            }
            return new LRESULT(code);
        }
        if ((this.style & 0x20) != 0 && (lpht.flags & 0x40) != 0) {
            this.sendMouseEvent(3, 1, this.handle, 513, wParam, lParam);
            if (OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            TVITEM tvItem = new TVITEM();
            tvItem.hItem = lpht.hItem;
            tvItem.mask = 12;
            tvItem.stateMask = 61440;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            int state = tvItem.state >> 12;
            state = (state & 1) != 0 ? ++state : --state;
            tvItem.state = state << 12;
            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
            if (!OS.IsWinCE) {
                int id = tvItem.hItem;
                if (OS.COMCTL32_MAJOR >= 6) {
                    id = OS.SendMessage(this.handle, 4395, tvItem.hItem, 0);
                }
                OS.NotifyWinEvent(32773, this.handle, -4, id);
            }
            Event event = new Event();
            event.item = this.items[tvItem.lParam];
            event.detail = 32;
            this.postEvent(13, event);
            return LRESULT.ZERO;
        }
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 8;
        tvItem.stateMask = 2;
        boolean hittestSelected = false;
        if ((this.style & 2) != 0) {
            tvItem.hItem = lpht.hItem;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            hittestSelected = (tvItem.state & 2) != 0;
        }
        int hOldItem = OS.SendMessage(this.handle, 4362, 9, 0);
        if ((this.style & 2) != 0) {
            tvItem.hItem = hOldItem;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            if (hittestSelected || (wParam & 8) != 0) {
                if (this.drawCount == 0) {
                    OS.UpdateWindow(this.handle);
                    OS.DefWindowProc(this.handle, 11, 0, 0);
                }
            } else {
                this.deselectAll();
            }
        }
        this.sendMouseEvent(3, 1, this.handle, 513, wParam, lParam);
        this.gestureCompleted = false;
        this.dragStarted = false;
        this.ignoreSelect = true;
        this.ignoreDeselect = true;
        int code = this.callWindowProc(this.handle, 513, wParam, lParam);
        this.ignoreSelect = false;
        this.ignoreDeselect = false;
        if (this.dragStarted && OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        int hNewItem = OS.SendMessage(this.handle, 4362, 9, 0);
        if ((this.style & 4) != 0 && hOldItem == hNewItem) {
            tvItem.mask = 8;
            tvItem.state = 2;
            tvItem.stateMask = 2;
            tvItem.hItem = hNewItem;
            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
        }
        if ((this.style & 2) != 0) {
            if (hittestSelected || (wParam & 8) != 0) {
                if (hOldItem == hNewItem && hOldItem == lpht.hItem) {
                    if ((wParam & 8) != 0) {
                        tvItem.state ^= 2;
                        if (this.dragStarted) {
                            tvItem.state = 2;
                        }
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                    }
                } else {
                    if ((tvItem.state & 2) != 0) {
                        tvItem.state = 2;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                    }
                    if ((wParam & 8) != 0 && !this.dragStarted && hittestSelected) {
                        tvItem.state = 0;
                        tvItem.hItem = lpht.hItem;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                    }
                }
                if (this.drawCount == 0) {
                    RECT rect1 = new RECT();
                    RECT rect2 = new RECT();
                    rect1.left = hOldItem;
                    rect2.left = hNewItem;
                    int bits = OS.GetWindowLong(this.handle, -16);
                    int fItemRect = (bits & 0x1000) != 0 ? 0 : 1;
                    OS.SendMessage(this.handle, 4356, fItemRect, rect1);
                    OS.SendMessage(this.handle, 4356, fItemRect, rect2);
                    OS.DefWindowProc(this.handle, 11, 1, 0);
                    if (OS.IsWinCE) {
                        OS.InvalidateRect(this.handle, rect1, false);
                        OS.InvalidateRect(this.handle, rect2, false);
                        OS.UpdateWindow(this.handle);
                    } else {
                        int flags = 257;
                        OS.RedrawWindow(this.handle, rect1, 0, flags);
                        OS.RedrawWindow(this.handle, rect2, 0, flags);
                    }
                }
            }
            if (!((wParam & 8) != 0 || hittestSelected && this.dragStarted)) {
                tvItem.state = 0;
                int oldProc = OS.GetWindowLong(this.handle, -4);
                OS.SetWindowLong(this.handle, -4, TreeProc);
                int i = 0;
                while (i < this.items.length) {
                    TreeItem item = this.items[i];
                    if (item != null && item.handle != hNewItem) {
                        tvItem.hItem = item.handle;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                    }
                    ++i;
                }
                tvItem.hItem = hNewItem;
                tvItem.state = 2;
                OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                OS.SetWindowLong(this.handle, -4, oldProc);
                if ((wParam & 4) != 0) {
                    RECT rect1 = new RECT();
                    if (this.hAnchor == 0) {
                        this.hAnchor = hNewItem;
                    }
                    rect1.left = this.hAnchor;
                    if (OS.SendMessage(this.handle, 4356, 1, rect1) != 0) {
                        RECT rect2 = new RECT();
                        rect2.left = hNewItem;
                        OS.SendMessage(this.handle, 4356, 1, rect2);
                        int flags = rect1.top < rect2.top ? 6 : 7;
                        tvItem.state = 2;
                        int hItem = tvItem.hItem = this.hAnchor;
                        OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                        while (hItem != hNewItem) {
                            tvItem.hItem = hItem;
                            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                            hItem = OS.SendMessage(this.handle, 4362, flags, hItem);
                        }
                    }
                }
            }
        }
        if ((wParam & 4) == 0) {
            this.hAnchor = hNewItem;
        }
        if (!this.gestureCompleted) {
            tvItem.hItem = hNewItem;
            tvItem.mask = 4;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            Event event = new Event();
            event.item = this.items[tvItem.lParam];
            this.postEvent(13, event);
        }
        this.gestureCompleted = false;
        if (this.dragStarted) {
            Event event = new Event();
            event.x = (short)(lParam & 0xFFFF);
            event.y = (short)(lParam >> 16);
            this.postEvent(29, event);
        } else {
            this.sendMouseEvent(4, 1, this.handle, 514, wParam, lParam);
        }
        this.dragStarted = false;
        return new LRESULT(code);
    }

    LRESULT WM_MOVE(int wParam, int lParam) {
        if (this.ignoreResize) {
            return null;
        }
        return super.WM_MOVE(wParam, lParam);
    }

    LRESULT WM_NOTIFY(int wParam, int lParam) {
        NMHDR hdr = new NMHDR();
        OS.MoveMemory(hdr, lParam, 12);
        if (this.hwndHeader != 0 && hdr.hwndFrom == this.hwndHeader) {
            switch (hdr.code) {
                case -326: 
                case -325: 
                case -306: 
                case -305: {
                    NMHEADER phdn = new NMHEADER();
                    OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                    TreeColumn column = this.columns[phdn.iItem];
                    if (column == null || column.getResizable()) break;
                    return LRESULT.ONE;
                }
                case -320: 
                case -300: {
                    NMHEADER phdn = new NMHEADER();
                    OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                    if (phdn.pitem == 0) break;
                    HDITEM newItem = new HDITEM();
                    OS.MoveMemory(newItem, phdn.pitem, HDITEM.sizeof);
                    if ((newItem.mask & 1) == 0) break;
                    HDITEM oldItem = new HDITEM();
                    oldItem.mask = 1;
                    OS.SendMessage(this.hwndHeader, OS.HDM_GETITEM, phdn.iItem, oldItem);
                    int deltaX = newItem.cxy - oldItem.cxy;
                    RECT rect = new RECT();
                    RECT itemRect = new RECT();
                    OS.GetClientRect(this.handle, rect);
                    OS.SendMessage(this.hwndHeader, 4615, phdn.iItem, itemRect);
                    int gridWidth = this.getLinesVisible() ? 1 : 0;
                    rect.left = itemRect.right - gridWidth;
                    int count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
                    if (phdn.iItem < count - 1) {
                        int i = phdn.iItem;
                        while (i < count) {
                            OS.SendMessage(this.hwndHeader, 4615, i, itemRect);
                            ++i;
                        }
                        rect.right = itemRect.right;
                    }
                    int flags = 6;
                    OS.ScrollWindowEx(this.handle, deltaX, 0, rect, null, 0, null, flags);
                    if (phdn.iItem != 0) {
                        OS.SendMessage(this.hwndHeader, 4615, phdn.iItem, itemRect);
                        rect.left = itemRect.left;
                        rect.right = itemRect.right;
                        OS.InvalidateRect(this.handle, rect, true);
                    }
                    this.setScrollWidth();
                    break;
                }
                case -321: 
                case -301: {
                    TreeColumn column;
                    NMHEADER phdn = new NMHEADER();
                    OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                    if (phdn.pitem == 0) break;
                    HDITEM pitem = new HDITEM();
                    OS.MoveMemory(pitem, phdn.pitem, HDITEM.sizeof);
                    if ((pitem.mask & 1) != 0 && (column = this.columns[phdn.iItem]) != null) {
                        column.sendEvent(11);
                        if (this.isDisposed()) {
                            return LRESULT.ZERO;
                        }
                        int count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
                        TreeColumn[] newColumns = new TreeColumn[count];
                        System.arraycopy(this.columns, 0, newColumns, 0, count);
                        int i = phdn.iItem + 1;
                        while (i < count) {
                            if (!newColumns[i].isDisposed()) {
                                newColumns[i].sendEvent(10);
                            }
                            ++i;
                        }
                    }
                    this.setScrollWidth();
                    break;
                }
                case -322: 
                case -302: {
                    NMHEADER phdn = new NMHEADER();
                    OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                    TreeColumn column = this.columns[phdn.iItem];
                    if (column == null) break;
                    column.postEvent(13);
                    break;
                }
                case -323: 
                case -303: {
                    NMHEADER phdn = new NMHEADER();
                    OS.MoveMemory(phdn, lParam, NMHEADER.sizeof);
                    TreeColumn column = this.columns[phdn.iItem];
                    if (column == null) break;
                    column.postEvent(14);
                }
            }
        }
        return super.WM_NOTIFY(wParam, lParam);
    }

    LRESULT WM_RBUTTONDOWN(int wParam, int lParam) {
        this.sendMouseEvent(3, 3, this.handle, 516, wParam, lParam);
        this.setFocus();
        TVHITTESTINFO lpht = new TVHITTESTINFO();
        lpht.x = (short)(lParam & 0xFFFF);
        lpht.y = (short)(lParam >> 16);
        OS.SendMessage(this.handle, 4369, 0, lpht);
        if (lpht.hItem != 0 && (lpht.flags & 6) != 0 && (wParam & 0xC) == 0) {
            TVITEM tvItem = new TVITEM();
            tvItem.mask = 8;
            tvItem.stateMask = 2;
            tvItem.hItem = lpht.hItem;
            OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
            if ((tvItem.state & 2) == 0) {
                this.ignoreSelect = true;
                OS.SendMessage(this.handle, 4363, 9, 0);
                this.ignoreSelect = false;
                OS.SendMessage(this.handle, 4363, 9, lpht.hItem);
            }
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_PRINTCLIENT(int wParam, int lParam) {
        LRESULT result = super.WM_PRINTCLIENT(wParam, lParam);
        if (result != null) {
            return result;
        }
        this.printClient = true;
        int code = this.callWindowProc(this.handle, 792, wParam, lParam);
        this.printClient = false;
        return new LRESULT(code);
    }

    LRESULT WM_SETFOCUS(int wParam, int lParam) {
        LRESULT result = super.WM_SETFOCUS(wParam, lParam);
        if ((this.style & 4) != 0) {
            return result;
        }
        OS.InvalidateRect(this.handle, null, false);
        return result;
    }

    LRESULT WM_SETFONT(int wParam, int lParam) {
        LRESULT result = super.WM_SETFONT(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (this.hwndHeader != 0) {
            OS.SendMessage(this.hwndHeader, 48, wParam, lParam);
        }
        return result;
    }

    LRESULT WM_SIZE(int wParam, int lParam) {
        if (this.ignoreResize) {
            return null;
        }
        return super.WM_SIZE(wParam, lParam);
    }

    LRESULT WM_SYSCOLORCHANGE(int wParam, int lParam) {
        LRESULT result = super.WM_SYSCOLORCHANGE(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((this.style & 0x20) != 0) {
            this.setCheckboxImageList();
        }
        return result;
    }

    LRESULT wmColorChild(int wParam, int lParam) {
        return null;
    }

    LRESULT wmNotifyChild(int wParam, int lParam) {
        block79: {
            NMHDR hdr = new NMHDR();
            OS.MoveMemory(hdr, lParam, 12);
            block0 : switch (hdr.code) {
                case -452: 
                case -403: {
                    TreeItem item;
                    NMTVDISPINFO lptvdi = new NMTVDISPINFO();
                    OS.MoveMemory(lptvdi, lParam, 52);
                    if (this.items == null || (item = this.items[lptvdi.lParam]) == null) break;
                    if ((lptvdi.mask & 1) != 0) {
                        String string = item.text;
                        TCHAR buffer = new TCHAR(this.getCodePage(), string, false);
                        int byteCount = Math.min(buffer.length(), lptvdi.cchTextMax - 1) * TCHAR.sizeof;
                        OS.MoveMemory(lptvdi.pszText, buffer, byteCount);
                        OS.MoveMemory(lptvdi.pszText + byteCount, new byte[TCHAR.sizeof], TCHAR.sizeof);
                        lptvdi.cchTextMax = Math.min(lptvdi.cchTextMax, string.length() + 1);
                    }
                    if ((lptvdi.mask & 0x22) != 0) {
                        Image image = item.image;
                        lptvdi.iSelectedImage = -2;
                        lptvdi.iImage = -2;
                        if (image != null) {
                            lptvdi.iImage = lptvdi.iSelectedImage = this.imageIndex(image);
                        }
                    }
                    OS.MoveMemory(lParam, lptvdi, 52);
                    break;
                }
                case -12: {
                    if (!this.customDraw) break;
                    NMTVCUSTOMDRAW nmcd = new NMTVCUSTOMDRAW();
                    OS.MoveMemory(nmcd, lParam, NMTVCUSTOMDRAW.sizeof);
                    switch (nmcd.dwDrawStage) {
                        case 1: {
                            return new LRESULT(48);
                        }
                        case 2: {
                            if (this.linesVisible) {
                                int hItem;
                                int hDC = nmcd.hdc;
                                if (this.hwndHeader != 0) {
                                    int x = 0;
                                    RECT rect = new RECT();
                                    HDITEM hdItem = new HDITEM();
                                    hdItem.mask = 1;
                                    int count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
                                    int i = 0;
                                    while (i < count) {
                                        OS.SendMessage(this.hwndHeader, OS.HDM_GETITEM, i, hdItem);
                                        OS.SetRect(rect, x, nmcd.top, x + hdItem.cxy, nmcd.bottom);
                                        OS.DrawEdge(hDC, rect, 8, 4);
                                        x += hdItem.cxy;
                                        ++i;
                                    }
                                }
                                RECT rect = new RECT();
                                rect.left = hItem = OS.SendMessage(this.handle, 4362, 10, 0);
                                if (OS.SendMessage(this.handle, 4356, 0, rect) != 0) {
                                    int height = rect.bottom - rect.top;
                                    while (rect.bottom < nmcd.bottom) {
                                        int top = rect.top + height;
                                        OS.SetRect(rect, rect.left, top, rect.right, top + height);
                                        OS.DrawEdge(hDC, rect, 8, 8);
                                    }
                                }
                            }
                            return new LRESULT(0);
                        }
                        case 65537: {
                            TreeItem item = this.items[nmcd.lItemlParam];
                            if (item == null) break block0;
                            if (nmcd.left < nmcd.right) {
                                int hFont;
                                int count;
                                if (nmcd.top >= nmcd.bottom) break block0;
                                int hDC = nmcd.hdc;
                                OS.SaveDC(hDC);
                                if (this.linesVisible) {
                                    RECT rect = new RECT();
                                    OS.SetRect(rect, nmcd.left, nmcd.top, nmcd.right, nmcd.bottom);
                                    OS.DrawEdge(hDC, rect, 8, 8);
                                }
                                if (!this.printClient && (this.style & 0x10000) == 0 && this.hwndHeader != 0 && (count = OS.SendMessage(this.hwndHeader, 4608, 0, 0)) != 0) {
                                    HDITEM hdItem = new HDITEM();
                                    hdItem.mask = 1;
                                    OS.SendMessage(this.hwndHeader, OS.HDM_GETITEM, 0, hdItem);
                                    int hRgn = OS.CreateRectRgn(nmcd.left, nmcd.top, nmcd.left + hdItem.cxy, nmcd.bottom);
                                    OS.SelectClipRgn(hDC, hRgn);
                                    OS.DeleteObject(hRgn);
                                }
                                if (item.font == -1 && item.foreground == -1 && item.background == -1 && item.cellForeground == null && item.cellBackground == null && item.cellFont == null) {
                                    return new LRESULT(16);
                                }
                                int n = hFont = item.cellFont != null ? item.cellFont[0] : item.font;
                                if (hFont != -1) {
                                    OS.SelectObject(hDC, hFont);
                                }
                                if (OS.IsWindowEnabled(this.handle)) {
                                    TVITEM tvItem = new TVITEM();
                                    tvItem.mask = 8;
                                    tvItem.hItem = item.handle;
                                    OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                                    if ((tvItem.state & 0xA) == 0) {
                                        int clrText = item.cellForeground != null ? item.cellForeground[0] : item.foreground;
                                        nmcd.clrText = clrText == -1 ? this.getForegroundPixel() : clrText;
                                        int clrTextBk = item.cellBackground != null ? item.cellBackground[0] : item.background;
                                        nmcd.clrTextBk = clrTextBk == -1 ? this.getBackgroundPixel() : clrTextBk;
                                        OS.MoveMemory(lParam, nmcd, NMTVCUSTOMDRAW.sizeof);
                                    }
                                }
                                return new LRESULT(18);
                            }
                            break block79;
                        }
                        case 65538: {
                            TreeItem item = this.items[nmcd.lItemlParam];
                            if (item == null) break block0;
                            if (nmcd.left < nmcd.right) {
                                if (nmcd.top >= nmcd.bottom) break block0;
                                int hDC = nmcd.hdc;
                                OS.RestoreDC(hDC, -1);
                                OS.SetBkMode(hDC, 1);
                                boolean useColor = OS.IsWindowEnabled(this.handle);
                                if (useColor) {
                                    if ((this.style & 0x10000) != 0) {
                                        TVITEM tvItem = new TVITEM();
                                        tvItem.mask = 8;
                                        tvItem.hItem = item.handle;
                                        OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                                        if ((tvItem.state & 2) != 0) {
                                            useColor = false;
                                        } else {
                                            int clrBackground;
                                            int clrForeground = OS.GetTextColor(hDC);
                                            if (clrForeground == OS.GetSysColor(OS.COLOR_HIGHLIGHTTEXT) && (clrBackground = OS.GetBkColor(hDC)) == OS.GetSysColor(OS.COLOR_HIGHLIGHT)) {
                                                useColor = false;
                                            }
                                        }
                                    } else {
                                        OS.SetTextColor(hDC, this.getForegroundPixel());
                                    }
                                }
                                if (this.hwndHeader != 0) {
                                    GCData data = new GCData();
                                    data.device = this.display;
                                    GC gc = GC.win32_new(hDC, data);
                                    int x = 0;
                                    int gridWidth = this.linesVisible ? 1 : 0;
                                    Point size = null;
                                    RECT rect = new RECT();
                                    HDITEM hdItem = new HDITEM();
                                    hdItem.mask = 1;
                                    int count = OS.SendMessage(this.hwndHeader, 4608, 0, 0);
                                    int i = 0;
                                    while (i < count) {
                                        OS.SendMessage(this.hwndHeader, OS.HDM_GETITEM, i, hdItem);
                                        if (i > 0) {
                                            Image image;
                                            OS.SetRect(rect, x, nmcd.top, x + hdItem.cxy, nmcd.bottom - gridWidth);
                                            if (this.printClient || (this.style & 0x10000) != 0) {
                                                this.drawBackground(hDC, OS.GetBkColor(hDC), rect);
                                            }
                                            if (useColor) {
                                                int clrTextBk;
                                                int n = clrTextBk = item.cellBackground != null ? item.cellBackground[i] : item.background;
                                                if (clrTextBk != -1) {
                                                    this.drawBackground(hDC, clrTextBk, rect);
                                                }
                                            }
                                            Image image2 = image = item.images != null ? item.images[i] : null;
                                            if (image != null) {
                                                Rectangle bounds = image.getBounds();
                                                if (size == null) {
                                                    size = this.getImageSize();
                                                }
                                                gc.drawImage(image, 0, 0, bounds.width, bounds.height, rect.left, rect.top, size.x, size.y);
                                                OS.SetRect(rect, rect.left + size.x + 3, rect.top, rect.right - 3, rect.bottom);
                                            } else {
                                                OS.SetRect(rect, rect.left + 3, rect.top, rect.right - 3, rect.bottom);
                                            }
                                            if (rect.left < rect.right && item.strings != null && item.strings[i] != null) {
                                                int hFont = item.cellFont != null ? item.cellFont[i] : item.font;
                                                hFont = hFont != -1 ? OS.SelectObject(hDC, hFont) : -1;
                                                int clrText = -1;
                                                if (useColor) {
                                                    clrText = item.cellForeground != null ? item.cellForeground[i] : item.foreground;
                                                    clrText = clrText != -1 ? OS.SetTextColor(hDC, clrText) : -1;
                                                }
                                                int flags = 34852;
                                                TreeColumn column = this.columns[i];
                                                if ((column.style & 0x4000) != 0) {
                                                    flags |= 0;
                                                }
                                                if ((column.style & 0x1000000) != 0) {
                                                    flags |= 1;
                                                }
                                                if ((column.style & 0x20000) != 0) {
                                                    flags |= 2;
                                                }
                                                TCHAR buffer = new TCHAR(this.getCodePage(), item.strings[i], false);
                                                OS.DrawText(hDC, buffer, buffer.length(), rect, flags);
                                                if (hFont != -1) {
                                                    OS.SelectObject(hDC, hFont);
                                                }
                                                if (clrText != -1) {
                                                    OS.SetTextColor(hDC, clrText);
                                                }
                                            }
                                        }
                                        x += hdItem.cxy;
                                        ++i;
                                    }
                                    if (count > 0 && (this.printClient || (this.style & 0x10000) != 0)) {
                                        OS.SetRect(rect, x, nmcd.top, nmcd.right, nmcd.bottom - gridWidth);
                                        this.drawBackground(hDC, OS.GetBkColor(hDC), rect);
                                    }
                                    gc.dispose();
                                }
                                if (this.linesVisible) {
                                    int count;
                                    if (this.printClient && (this.style & 0x10000) == 0 && this.hwndHeader != 0 && (count = OS.SendMessage(this.hwndHeader, 4608, 0, 0)) != 0 && this.printClient) {
                                        HDITEM hdItem = new HDITEM();
                                        hdItem.mask = 1;
                                        OS.SendMessage(this.hwndHeader, OS.HDM_GETITEM, 0, hdItem);
                                        RECT rect = new RECT();
                                        OS.SetRect(rect, nmcd.left + hdItem.cxy, nmcd.top, nmcd.right, nmcd.bottom);
                                        OS.DrawEdge(hDC, rect, 8, 8);
                                    }
                                    RECT rect = new RECT();
                                    if (OS.COMCTL32_MAJOR < 6 || (this.style & 0x10000) != 0) {
                                        OS.SetRect(rect, nmcd.left, nmcd.top, nmcd.right, nmcd.bottom);
                                    } else {
                                        rect.left = item.handle;
                                        if (OS.SendMessage(this.handle, 4356, 1, rect) != 0) {
                                            int hItem = OS.SendMessage(this.handle, 4362, 9, 0);
                                            if (hItem == item.handle) {
                                                OS.SetRect(rect, rect.right, nmcd.top, nmcd.right, nmcd.bottom);
                                            } else {
                                                TVITEM tvItem = new TVITEM();
                                                tvItem.mask = 8;
                                                tvItem.hItem = item.handle;
                                                OS.SendMessage(this.handle, OS.TVM_GETITEM, 0, tvItem);
                                                if ((tvItem.state & 2) != 0) {
                                                    OS.SetRect(rect, rect.right, nmcd.top, nmcd.right, nmcd.bottom);
                                                } else {
                                                    OS.SetRect(rect, rect.left, nmcd.top, nmcd.right, nmcd.bottom);
                                                }
                                            }
                                        } else {
                                            rect.left = 0;
                                        }
                                    }
                                    OS.DrawEdge(hDC, rect, 8, 8);
                                }
                                return new LRESULT(0);
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
                case -3: {
                    if (!this.hooks(14)) break;
                    return LRESULT.ONE;
                }
                case -451: 
                case -402: {
                    int offset;
                    TVITEM tvItem;
                    if ((this.style & 2) != 0 && this.lockSelection) {
                        if (this.oldSelected) {
                            tvItem = new TVITEM();
                            offset = 16;
                            OS.MoveMemory(tvItem, lParam + offset, 40);
                            tvItem.mask = 8;
                            tvItem.stateMask = 2;
                            tvItem.state = 2;
                            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                        }
                        if (!this.newSelected && this.ignoreSelect) {
                            tvItem = new TVITEM();
                            offset = 56;
                            OS.MoveMemory(tvItem, lParam + offset, 40);
                            tvItem.mask = 8;
                            tvItem.stateMask = 2;
                            tvItem.state = 0;
                            OS.SendMessage(this.handle, OS.TVM_SETITEM, 0, tvItem);
                        }
                    }
                    if (!this.ignoreSelect) {
                        tvItem = new TVITEM();
                        offset = 56;
                        OS.MoveMemory(tvItem, lParam + offset, 40);
                        this.hAnchor = tvItem.hItem;
                        Event event = new Event();
                        event.item = this.items[tvItem.lParam];
                        this.postEvent(13, event);
                    }
                    this.updateScrollBar();
                    break;
                }
                case -450: 
                case -401: {
                    if ((this.style & 2) != 0 && this.lockSelection) {
                        TVITEM tvItem = new TVITEM();
                        int offset1 = 16;
                        OS.MoveMemory(tvItem, lParam + offset1, 40);
                        this.oldSelected = (tvItem.state & 2) != 0;
                        int offset2 = 56;
                        OS.MoveMemory(tvItem, lParam + offset2, 40);
                        boolean bl = this.newSelected = (tvItem.state & 2) != 0;
                    }
                    if (this.ignoreSelect || this.ignoreDeselect) break;
                    this.hAnchor = 0;
                    if ((this.style & 2) == 0) break;
                    this.deselectAll();
                    break;
                }
                case -455: 
                case -406: {
                    if (this.hInsert != 0) {
                        OS.SendMessage(this.handle, 4378, this.insertAfter ? 1 : 0, this.hInsert);
                    }
                    this.updateScrollBar();
                    break;
                }
                case -454: 
                case -405: {
                    TreeItem item;
                    if (this.hInsert != 0) {
                        OS.SendMessage(this.handle, 4378, 0, 0);
                    }
                    if (this.ignoreExpand) break;
                    TVITEM tvItem = new TVITEM();
                    int offset = 56;
                    OS.MoveMemory(tvItem, lParam + offset, 40);
                    if (this.items == null || (item = this.items[tvItem.lParam]) == null) break;
                    Event event = new Event();
                    event.item = item;
                    int[] action = new int[1];
                    OS.MoveMemory(action, lParam + 12, 4);
                    switch (action[0]) {
                        case 2: {
                            if ((tvItem.state & 0x20) != 0) break;
                            this.sendEvent(17, event);
                            if (!this.isDisposed()) break;
                            return LRESULT.ZERO;
                        }
                        case 1: {
                            this.sendEvent(18, event);
                            if (!this.isDisposed()) break;
                            return LRESULT.ZERO;
                        }
                    }
                    break;
                }
                case -457: 
                case -456: 
                case -408: 
                case -407: {
                    TVITEM tvItem = new TVITEM();
                    int offset = 56;
                    OS.MoveMemory(tvItem, lParam + offset, 40);
                    if (tvItem.hItem != 0 && (tvItem.state & 2) == 0) {
                        this.ignoreDeselect = true;
                        this.ignoreSelect = true;
                        OS.SendMessage(this.handle, 4363, 9, tvItem.hItem);
                        this.ignoreDeselect = false;
                        this.ignoreSelect = false;
                    }
                    this.dragStarted = true;
                    break;
                }
                case -16: {
                    boolean hasMenu;
                    if (!OS.IsPPC) break;
                    boolean bl = hasMenu = this.menu != null && !this.menu.isDisposed();
                    if (hasMenu || this.hooks(35)) break;
                    return LRESULT.ONE;
                }
                case 1000: {
                    boolean hasMenu;
                    if (!OS.IsPPC) break;
                    boolean bl = hasMenu = this.menu != null && !this.menu.isDisposed();
                    if (!hasMenu && !this.hooks(35)) break;
                    NMRGINFO nmrg = new NMRGINFO();
                    OS.MoveMemory(nmrg, lParam, NMRGINFO.sizeof);
                    this.showMenu(nmrg.x, nmrg.y);
                    this.gestureCompleted = true;
                    return LRESULT.ONE;
                }
            }
        }
        return super.wmNotifyChild(wParam, lParam);
    }
}

