/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.nishiohirokazu.graph.RenderableVertex;
import org.nishiohirokazu.grinEdit.UtilXMLRPC;
import org.nishiohirokazu.swt.ColorHolder;

public class CircleVertex
extends RenderableVertex {
    org.eclipse.swt.graphics.Color bgcolor = ColorHolder.GRINGREEN;
    Point bound;
    org.eclipse.swt.graphics.Color frameColor = ColorHolder.BLACK;
    private int diameter = 15;

    public void rpc_bgcolor(Object rgb) {
        this.bgcolor = ColorHolder.get((Vector)rgb);
    }

    public void rpc_frame_color(Object rgb) {
        this.frameColor = ColorHolder.get((Vector)rgb);
    }

    public void rpc_diameter(Object d) {
        this.diameter = UtilXMLRPC.getIntValue(d);
    }

    public Hashtable rpc_getParams() {
        Hashtable result = super.rpc_getParams();
        result.put("bgcolor", UtilXMLRPC.Color2Vector(this.bgcolor));
        result.put("frame_color", UtilXMLRPC.Color2Vector(this.frameColor));
        result.put("diameter", this.diameter);
        return result;
    }

    public void render(Object target) {
        if (target instanceof GC) {
            GC gc = (GC)target;
            if (this.selected) {
                gc.setBackground(ColorHolder.SELECTED_VERTEX);
            } else {
                gc.setBackground(this.bgcolor);
            }
            gc.fillOval((int)(this.screenPos[0] - (double)(this.diameter / 2)), (int)(this.screenPos[1] - (double)(this.diameter / 2)), this.diameter + 1, this.diameter + 1);
            gc.setForeground(this.frameColor);
            gc.drawOval((int)(this.screenPos[0] - (double)(this.diameter / 2)), (int)(this.screenPos[1] - (double)(this.diameter / 2)), this.diameter, this.diameter);
            gc.setBackground(ColorHolder.WHITE);
        } else if (target instanceof Graphics) {
            Graphics g = (Graphics)target;
            g.setColor(Color.blue);
            g.fillOval((int)(this.screenPos[0] - (double)(this.diameter / 2)), (int)(this.screenPos[1] - (double)(this.diameter / 2)), this.diameter, this.diameter);
            g.setColor(Color.black);
            g.drawOval((int)(this.screenPos[0] - (double)(this.diameter / 2)), (int)(this.screenPos[1] - (double)(this.diameter / 2)), this.diameter, this.diameter);
        }
    }

    public double calcOffset(double[] ndir) {
        Point b = this.bound;
        double offset = b == null || b.x == 0 || b.y == 0 ? 0.0 : (Math.abs((double)b.x * ndir[1]) < Math.abs((double)b.y * ndir[0]) ? Math.abs((double)b.x / ndir[0] / 2.0) : Math.abs((double)b.y / ndir[1] / 2.0));
        return offset;
    }
}

