/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.graph;

import java.util.Hashtable;
import java.util.Vector;
import org.nishiohirokazu.graph.BoxVertex;
import org.nishiohirokazu.graph.CircleVertex;
import org.nishiohirokazu.graph.Graph;
import org.nishiohirokazu.graph.LinearEdge;
import org.nishiohirokazu.graph.RenderableEdge;
import org.nishiohirokazu.graph.RenderableVertex;
import org.nishiohirokazu.grinEdit.Infrastructure;
import org.nishiohirokazu.layout.Aggregator;
import org.nishiohirokazu.layout.Anchor;
import org.nishiohirokazu.layout.Repulsion;
import org.nishiohirokazu.layout.SpringEdge;
import org.nishiohirokazu.swt.ColorHolder;
import org.nishiohirokazu.swt.ViewportTransformer;

public class RenderableGraph
extends Graph {
    public Hashtable anchorTable;
    private boolean isDefaultSetting = true;

    public RenderableGraph() {
        this.vertexList = new Vector();
        this.edgeList = new Vector();
        this.anchorTable = new Hashtable();
        this.aggregator = new Aggregator();
        this.aggregator.addLaw(new SpringEdge(this.edgeList));
        this.aggregator.addLaw(new Repulsion(this.vertexList));
        this.aggregator.addLaw(new Anchor(this.anchorTable));
    }

    public RenderableVertex addVertex() {
        CircleVertex v = new CircleVertex();
        this.vertexList.add(v);
        return v;
    }

    public RenderableVertex addVertex(String label) {
        BoxVertex v = new BoxVertex();
        v.label = label;
        this.vertexList.add(v);
        return v;
    }

    public RenderableVertex addVertex(String name, int r, int gr, int b) {
        BoxVertex v = new BoxVertex();
        v.label = name;
        v.bgcolor = ColorHolder.get(r, gr, b);
        this.vertexList.add(v);
        return v;
    }

    public RenderableEdge addEdge(RenderableVertex v1, RenderableVertex v2) {
        LinearEdge e = new LinearEdge(v1, v2);
        this.edgeList.add(e);
        return e;
    }

    public RenderableEdge addEdge(RenderableVertex v1, RenderableVertex v2, int r, int g, int b) {
        LinearEdge e = new LinearEdge(v1, v2, r, g, b);
        this.edgeList.add(e);
        return e;
    }

    public void layoutStep() {
        this.aggregator.aggregate();
    }

    public void render(Object target) {
        RenderableVertex v;
        int numVtx = this.vertexList.size();
        ViewportTransformer vp = Infrastructure.getViewportTransformer();
        int i = 0;
        while (i < numVtx) {
            v = (RenderableVertex)this.vertexList.get(i);
            v.screenPos = vp.viewportTransform(v.position);
            ++i;
        }
        i = 0;
        while (i < this.edgeList.size()) {
            RenderableEdge e = (RenderableEdge)this.edgeList.get(i);
            e.render(target);
            ++i;
        }
        i = 0;
        while (i < numVtx) {
            v = (RenderableVertex)this.vertexList.get(i);
            v.render(target);
            ++i;
        }
    }

    public Hashtable getAnchorTable() {
        return this.anchorTable;
    }

    public boolean isDefaultSetting() {
        return this.isDefaultSetting;
    }
}

