/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.grinEdit;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.nishiohirokazu.grinEdit.DragDropListener;
import org.nishiohirokazu.grinEdit.Infrastructure;
import org.nishiohirokazu.grinEdit.Mediator;
import org.nishiohirokazu.grinEdit.mouseOperation.MouseMediator;
import org.nishiohirokazu.swt.ColorHolder;
import org.nishiohirokazu.swt.DoubleBufferer;
import org.python.util.PythonInterpreter;

public class GraphVisualizerTest {
    Display display = Infrastructure.getDisplay();
    Shell shell;
    public Mediator med;
    public PythonInterpreter pyi = Infrastructure.getPyi();

    public GraphVisualizerTest() {
        this.shell = Infrastructure.getShell();
        this.med = Mediator.getInstance();
        this.initPythonScript();
        this.setContets(this.shell);
        this.initMenu(this.shell);
        this.shell.pack();
        ColorHolder.initialize(this.display);
        this.shell.setSize(600, 600);
        this.shell.open();
        Infrastructure.getDoubleBufferer();
        Infrastructure.getViewportTransformer();
        Infrastructure.execPythonScript("start.py");
        DropTarget dndtarget = new DropTarget(this.shell, 17);
        FileTransfer transfer = FileTransfer.getInstance();
        Transfer[] types2 = new Transfer[]{transfer};
        dndtarget.setTransfer(types2);
        dndtarget.addDropListener(new DragDropListener());
        Timer t = new Timer();
        TimerTask tt = new TimerTask(){

            public void run() {
                GraphVisualizerTest.this.updateScreen();
            }
        };
        t.schedule(tt, 0L, 10L);
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        t.cancel();
        this.display.dispose();
        if (Infrastructure.server != null) {
            Infrastructure.server.shutdown();
        }
    }

    private void initPythonScript() {
        this.pyi.exec("import sys");
        this.pyi.exec("sys.path.append('pythonScripts')");
    }

    private void initMenu(Shell shell) {
        Mediator med = Mediator.getInstance();
        med.getMenuWrapper();
        Infrastructure.execPythonScript("initMenu.py");
    }

    public void setContets(Shell shell) {
        shell.setLayout(new FillLayout());
        shell.setSize(600, 600);
        Infrastructure.canvas = new Canvas(shell, 2048);
        MouseMediator mm = this.med.getMouseMediator();
        Infrastructure.execPythonScript("initMouseMediator.py");
        Infrastructure.canvas.addMouseListener(mm);
        Infrastructure.canvas.addMouseMoveListener(mm);
    }

    public static void main(String[] args) {
        new GraphVisualizerTest();
    }

    public void updateScreen() {
        if (this.shell.isDisposed()) {
            this.med.pause = true;
            ColorHolder.dispose();
        } else {
            DoubleBufferer dbuf = Infrastructure.getDoubleBufferer();
            if (!this.med.pause) {
                dbuf.clearBG();
                if (Infrastructure.bgImage != null) {
                    dbuf.getBG().drawImage(Infrastructure.bgImage, 0, 0);
                }
                this.med.graph.layoutStep();
                GC bg = dbuf.getBG();
                this.med.graph.render(bg);
            }
            this.med.mouseMed.draw();
            dbuf.draw();
        }
    }
}

