/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.vector;

public class Vec {
    public static double[] scale(double[] v, double s) {
        int N = v.length;
        double[] result = new double[N];
        int i = 0;
        while (i < N) {
            result[i] = v[i] * s;
            ++i;
        }
        return result;
    }

    public static double[] add(double[] v1, double[] v2) {
        int N = v1.length;
        double[] result = new double[N];
        int i = 0;
        while (i < N) {
            result[i] = v1[i] + v2[i];
            ++i;
        }
        return result;
    }

    public static double[] addD(double[] v1, double[] v2) {
        int N = v1.length;
        int i = 0;
        while (i < N) {
            int n = i;
            v1[n] = v1[n] + v2[i];
            ++i;
        }
        return v1;
    }

    public static double[] sub(double[] v1, double[] v2) {
        int N = v1.length;
        double[] result = new double[N];
        int i = 0;
        while (i < N) {
            result[i] = v1[i] - v2[i];
            ++i;
        }
        return result;
    }

    public static double[] inv(double[] v) {
        int N = v.length;
        double[] result = new double[N];
        int i = 0;
        while (i < N) {
            result[i] = -v[i];
            ++i;
        }
        return result;
    }

    public static double distance(double[] v1, double[] v2) {
        int N = v1.length;
        double result = 0.0;
        int i = 0;
        while (i < N) {
            result += (v1[i] - v2[i]) * (v1[i] - v2[i]);
            ++i;
        }
        return Math.sqrt(result);
    }

    public static double sqDistance(double[] v1, double[] v2) {
        int N = v1.length;
        double result = 0.0;
        int i = 0;
        while (i < N) {
            result += (v1[i] - v2[i]) * (v1[i] - v2[i]);
            ++i;
        }
        return result;
    }

    public static double dPro(double[] v1, double[] v2) {
        int N = v1.length;
        double result = 0.0;
        int i = 0;
        while (i < N) {
            result += v1[i] * v2[i];
            ++i;
        }
        return result;
    }

    public static double sqMag(double[] v) {
        int N = v.length;
        double result = 0.0;
        int i = 0;
        while (i < N) {
            result += v[i] * v[i];
            ++i;
        }
        return result;
    }

    public static double mag(double[] v) {
        return Math.sqrt(Vec.sqMag(v));
    }

    public static double[] normalize(double[] v) {
        double m = Vec.mag(v);
        if (m == 0.0) {
            return Vec.normalize(new double[]{Math.random(), Math.random()});
        }
        return Vec.scale(v, 1.0 / m);
    }

    public static double[] translate2DVec(double[] axis1, double v1, double[] axis2, double v2) {
        return Vec.add(Vec.scale(axis1, v1), Vec.scale(axis2, v2));
    }

    public static void println(double[] v) {
        System.out.print("(");
        int i = 0;
        while (i < v.length - 1) {
            System.out.print(v[i]);
            System.out.print(", ");
            ++i;
        }
        System.out.print(v[v.length - 1]);
        System.out.println(")");
    }

    public static double[] rot90(double[] ndir) {
        double[] result = new double[]{-ndir[1], ndir[0]};
        return result;
    }
}

