/*
 * Decompiled with CFR 0.152.
 */
package yaml.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import yaml.parser.ParserEvent;
import yaml.parser.ParserReader;
import yaml.parser.SyntaxException;
import yaml.parser.YamlCharacter;

public final class YamlParser {
    public static final int LIST_OPEN = 91;
    public static final int LIST_CLOSE = 93;
    public static final int MAP_OPEN = 123;
    public static final int MAP_CLOSE = 125;
    public static final int LIST_NO_OPEN = 110;
    public static final int MAP_NO_OPEN = 78;
    public static final int DOCUMENT_HEADER = 72;
    public static final int MAP_SEPARATOR = 58;
    public static final int LIST_ENTRY = 45;
    protected ParserReader r;
    protected int line = 1;
    private ParserEvent event;
    private HashMap props;
    private char pendingEvent;

    public YamlParser(Reader reader, ParserEvent parserEvent) throws Exception {
        this.r = new ParserReader(reader);
        this.event = parserEvent;
        this.props = new HashMap();
    }

    protected String readerString() {
        return this.r.string();
    }

    private void clearEvents() {
        this.props.clear();
    }

    private void sendEvents() {
        if (this.pendingEvent == '[') {
            this.event.event(91);
        }
        if (this.pendingEvent == '{') {
            this.event.event(123);
        }
        this.pendingEvent = '\u0000';
        String string = (String)this.props.get("anchor");
        if (string != null) {
            this.event.property("anchor", string);
        }
        if ((string = (String)this.props.get("transfer")) != null) {
            this.event.property("transfer", string);
        }
        if ((string = (String)this.props.get("alias")) != null) {
            this.event.content("alias", string);
        }
        if ((string = (String)this.props.get("string")) != null) {
            this.event.content("string", string);
        }
        this.props.clear();
    }

    public int indent() throws IOException {
        this.mark();
        int n = 0;
        while (YamlCharacter.is(this.r.read(), 8)) {
            ++n;
        }
        this.reset();
        return n;
    }

    public boolean array(int n) throws IOException {
        this.mark();
        int n2 = 0;
        while (YamlCharacter.is(this.r.read(), n)) {
            ++n2;
        }
        if (n2 != 0) {
            this.r.unread();
            this.unmark();
            return true;
        }
        this.reset();
        return false;
    }

    public boolean space() throws IOException {
        return this.array(5);
    }

    public boolean line() throws IOException {
        return this.array(3);
    }

    public boolean linesp() throws IOException {
        return this.array(4);
    }

    public boolean word() throws IOException {
        return this.array(2);
    }

    public boolean number() throws IOException {
        return this.array(7);
    }

    public boolean indent(int n) throws IOException {
        this.mark();
        while (YamlCharacter.is(this.r.read(), 8) && n-- > 0) {
        }
        if (n == 0) {
            this.r.unread();
            this.unmark();
            return true;
        }
        this.reset();
        return false;
    }

    public boolean newline() throws IOException {
        ++this.line;
        this.mark();
        int n = this.r.read();
        int n2 = this.r.read();
        if (n == -1 || n == 13 && n2 == 10) {
            this.unmark();
            return true;
        }
        if (YamlCharacter.is(n, 6)) {
            this.r.unread();
            this.unmark();
            return true;
        }
        this.reset();
        --this.line;
        return false;
    }

    public boolean end() throws IOException {
        this.mark();
        this.space();
        if (!this.newline()) {
            this.reset();
            return false;
        }
        while (this.comment(-1, false)) {
        }
        this.unmark();
        return true;
    }

    public boolean string_simple() throws Exception {
        int n;
        int n2 = 0;
        this.r.mark();
        boolean bl = false;
        while ((n = this.r.read()) != -1) {
            char c = (char)n;
            if (n2 == 0 && '-' == c) {
                bl = true;
                continue;
            }
            if (n2 == 0 && (YamlCharacter.isSpaceChar(c) || YamlCharacter.isIndicatorNonSpace(c) || YamlCharacter.isIndicatorSpace(c))) break;
            if (bl && (YamlCharacter.isSpaceChar(c) || YamlCharacter.isLineBreakChar(c))) {
                this.unmark();
                return false;
            }
            if (!YamlCharacter.isLineSpChar(c) || YamlCharacter.isIndicatorSimple(c) && this.r.previous() != 92) break;
            ++n2;
        }
        this.r.unread();
        this.r.unmark();
        return n2 != 0;
    }

    public boolean loose_string_simple() throws Exception {
        char c;
        int n;
        int n2 = 0;
        while ((n = this.r.read()) != -1 && YamlCharacter.isLineSpChar(c = (char)n) && (!YamlCharacter.isLooseIndicatorSimple(c) || this.r.previous() == 92)) {
            ++n2;
        }
        this.r.unread();
        return n2 != 0;
    }

    boolean string_q1() throws Exception {
        if (this.r.current() != 39) {
            return false;
        }
        this.r.read();
        int n = 0;
        int n2 = 0;
        while (YamlCharacter.is(n = this.r.read(), 4) && (n != 39 || this.r.previous() == 92)) {
            ++n2;
        }
        if (n != 39) {
            throw new SyntaxException("unterminated string", this.line);
        }
        return true;
    }

    boolean string_q2() throws Exception {
        if (this.r.current() != 34) {
            return false;
        }
        this.r.read();
        int n = 0;
        int n2 = 0;
        while (YamlCharacter.is(n = this.r.read(), 4) && (n != 34 || this.r.previous() == 92)) {
            ++n2;
        }
        if (n != 34) {
            throw new SyntaxException("unterminated string", this.line);
        }
        return true;
    }

    public boolean loose_string() throws Exception {
        this.mark();
        boolean bl = false;
        boolean bl2 = false;
        bl2 = this.string_q1();
        if (bl2 || (bl = this.string_q2()) || this.loose_string_simple()) {
            String string = this.r.string().trim();
            if (bl) {
                string = this.fix_q2(string);
            } else if (bl2) {
                string = this.fix_q1(string);
            }
            this.props.put("string", string);
            this.unmark();
            return true;
        }
        this.reset();
        return false;
    }

    public boolean string() throws Exception {
        this.mark();
        boolean bl = false;
        boolean bl2 = false;
        bl2 = this.string_q1();
        if (bl2 || (bl = this.string_q2()) || this.string_simple()) {
            String string = this.r.string().trim();
            if (bl) {
                string = this.fix_q2(string);
            } else if (bl2) {
                string = this.fix_q1(string);
            }
            this.props.put("string", string);
            this.unmark();
            return true;
        }
        this.reset();
        return false;
    }

    String fix_q2(String string) {
        if (string.length() > 2) {
            return string.substring(1, string.length() - 1).replaceAll("\\\\\\\\", "\\\\");
        }
        return "";
    }

    String fix_q1(String string) {
        if (string.length() > 2) {
            return string.substring(1, string.length() - 1);
        }
        return "";
    }

    public boolean alias() throws IOException {
        this.mark();
        if (this.r.read() != 42) {
            this.r.unread();
            this.unmark();
            return false;
        }
        if (!this.word()) {
            this.reset();
            return false;
        }
        this.unmark();
        this.props.put("alias", this.r.string());
        return true;
    }

    public boolean anchor() throws IOException {
        this.mark();
        if (this.r.read() != 38) {
            this.r.unread();
            this.unmark();
            return false;
        }
        if (!this.word()) {
            this.reset();
            return false;
        }
        this.unmark();
        this.props.put("anchor", this.r.string());
        return true;
    }

    public boolean comment(int n, boolean bl) throws IOException {
        this.mark();
        if (n != -1 && this.indent() >= n) {
            this.reset();
            return false;
        }
        this.space();
        int n2 = this.r.read();
        if (n2 == 35) {
            this.linesp();
        } else {
            if (n2 == -1) {
                this.unmark();
                return false;
            }
            if (bl) {
                this.reset();
                return false;
            }
            this.r.unread();
        }
        boolean bl2 = this.newline();
        if (!bl2) {
            this.reset();
            return false;
        }
        this.unmark();
        return true;
    }

    public boolean header() throws Exception {
        this.mark();
        int n = this.r.read();
        int n2 = this.r.read();
        int n3 = this.r.read();
        if (n != 45 || n2 != 45 || n3 != 45) {
            this.reset();
            return false;
        }
        while (this.space() && this.directive()) {
        }
        this.unmark();
        this.event.event(72);
        return true;
    }

    public boolean directive() throws IOException {
        this.mark();
        if (this.r.read() != 35) {
            this.r.unread();
            this.unmark();
            return false;
        }
        if (!this.word()) {
            this.reset();
            return false;
        }
        if (this.r.read() != 58) {
            this.reset();
            return false;
        }
        if (!this.line()) {
            this.reset();
            return false;
        }
        this.event.content("directive", this.r.string());
        this.unmark();
        return true;
    }

    public boolean transfer() throws IOException {
        this.mark();
        if (this.r.read() != 33) {
            this.r.unread();
            this.unmark();
            return false;
        }
        if (!this.line()) {
            this.reset();
            return false;
        }
        this.props.put("transfer", this.r.string());
        this.unmark();
        return true;
    }

    public boolean properties() throws Exception {
        this.mark();
        if (this.transfer()) {
            this.space();
            this.anchor();
            this.unmark();
            return true;
        }
        if (this.anchor()) {
            this.space();
            this.transfer();
            this.unmark();
            return true;
        }
        this.reset();
        return false;
    }

    public boolean key(int n) throws Exception {
        if (this.r.current() == 63) {
            this.r.read();
            if (!this.value_nested(n + 1)) {
                throw new SyntaxException("'?' key indicator without a nested value", this.line);
            }
            if (!this.indent(n)) {
                throw new SyntaxException("Incorrect indentations after nested key", this.line);
            }
            return true;
        }
        if (!this.value_inline()) {
            return false;
        }
        this.space();
        return true;
    }

    public boolean value(int n) throws Exception {
        if (this.value_nested(n) || this.value_block(n)) {
            return true;
        }
        if (!this.loose_value_inline()) {
            return false;
        }
        if (!this.end()) {
            throw new SyntaxException("Unterminated inline value", this.line);
        }
        return true;
    }

    public boolean loose_value(int n) throws Exception {
        if (this.value_nested(n) || this.value_block(n)) {
            return true;
        }
        if (!this.loose_value_inline()) {
            return false;
        }
        if (!this.end()) {
            throw new SyntaxException("Unterminated inline value", this.line);
        }
        return true;
    }

    public boolean value_na(int n) throws Exception {
        if (this.value_nested(n) || this.value_block(n)) {
            return true;
        }
        if (!this.value_inline_na()) {
            return false;
        }
        if (!this.end()) {
            throw new SyntaxException("Unterminated inline value", this.line);
        }
        return true;
    }

    public boolean value_inline() throws Exception {
        this.mark();
        if (this.properties()) {
            this.space();
        }
        if (this.alias() || this.string()) {
            this.sendEvents();
            this.unmark();
            return true;
        }
        if (this.list() || this.map()) {
            this.unmark();
            return true;
        }
        this.clearEvents();
        this.reset();
        return false;
    }

    public boolean loose_value_inline() throws Exception {
        this.mark();
        if (this.properties()) {
            this.space();
        }
        if (this.alias() || this.loose_string()) {
            this.sendEvents();
            this.unmark();
            return true;
        }
        if (this.list() || this.map()) {
            this.unmark();
            return true;
        }
        this.clearEvents();
        this.reset();
        return false;
    }

    public boolean value_inline_na() throws Exception {
        this.mark();
        if (this.properties()) {
            this.space();
        }
        if (this.string()) {
            this.sendEvents();
            this.unmark();
            return true;
        }
        if (this.list() || this.map()) {
            this.unmark();
            return true;
        }
        this.clearEvents();
        this.reset();
        return false;
    }

    public boolean value_nested(int n) throws Exception {
        this.mark();
        if (this.properties()) {
            this.space();
        }
        if (!this.end()) {
            this.clearEvents();
            this.reset();
            return false;
        }
        this.sendEvents();
        while (this.comment(n, false)) {
        }
        if (this.nlist(n) || this.nmap(n)) {
            this.unmark();
            return true;
        }
        this.reset();
        return false;
    }

    public boolean value_block(int n) throws Exception {
        this.mark();
        if (this.properties()) {
            this.space();
        }
        if (!this.block(n)) {
            this.clearEvents();
            this.reset();
            return false;
        }
        this.sendEvents();
        while (this.comment(n, false)) {
        }
        this.unmark();
        return true;
    }

    public boolean nmap(int n) throws Exception {
        this.mark();
        int n2 = this.indent();
        if (n == -1) {
            n = n2;
        } else if (n2 > n) {
            n = n2;
        }
        this.pendingEvent = (char)123;
        int n3 = 0;
        while (this.indent(n) && this.nmap_entry(n)) {
            ++n3;
        }
        if (n3 > 0) {
            this.event.event(125);
            this.unmark();
            return true;
        }
        this.pendingEvent = '\u0000';
        this.reset();
        return false;
    }

    public boolean nmap_entry(int n) throws Exception {
        if (!this.key(n)) {
            return false;
        }
        if (this.r.current() != 58) {
            return false;
        }
        this.r.read();
        this.event.event(58);
        this.space();
        if (!this.loose_value(n + 1)) {
            throw new SyntaxException("no value after ':'", this.line);
        }
        return true;
    }

    public boolean nlist(int n) throws Exception {
        this.mark();
        int n2 = this.indent();
        if (n == -1) {
            n = n2;
        } else if (n2 > n) {
            n = n2;
        }
        this.pendingEvent = (char)91;
        int n3 = 0;
        while (this.indent(n) && this.nlist_entry(n)) {
            ++n3;
        }
        if (n3 > 0) {
            this.event.event(93);
            this.unmark();
            return true;
        }
        this.pendingEvent = '\u0000';
        this.reset();
        return false;
    }

    boolean start_list() throws Exception {
        this.r.mark();
        if (this.r.read() == 45 && (this.r.current() == 10 || this.space())) {
            this.r.unmark();
            return true;
        }
        this.r.reset();
        return false;
    }

    public boolean nlist_entry(int n) throws Exception {
        if (!this.start_list()) {
            return false;
        }
        this.space();
        if (this.nmap_inlist(n + 1) || this.value(n + 1)) {
            return true;
        }
        throw new SyntaxException("bad nlist", this.line);
    }

    public boolean nmap_inlist(int n) throws Exception {
        this.mark();
        if (!this.string()) {
            this.reset();
            return false;
        }
        this.space();
        if (this.r.read() != 58) {
            this.reset();
            return false;
        }
        if (this.pendingEvent == '[') {
            this.event.event(91);
            this.pendingEvent = '\u0000';
        }
        this.event.event(123);
        this.sendEvents();
        this.event.event(58);
        if (!this.space()) {
            this.reset();
            return false;
        }
        if (!this.value(n + 1)) {
            throw new SyntaxException("No value after ':' in map_in_list", this.line);
        }
        int n2 = this.indent();
        if (++n == -1) {
            n = n2;
        } else if (n2 > n) {
            n = n2;
        }
        int n3 = 0;
        while (this.indent(n) && this.nmap_entry(n)) {
            ++n3;
        }
        if (n3 > 0) {
            this.event.event(125);
            this.unmark();
            return true;
        }
        this.unmark();
        return true;
    }

    public boolean block(int n) throws Exception {
        int n2 = this.r.current();
        if (n2 != 124 && n2 != 93) {
            return false;
        }
        this.r.read();
        if (this.r.current() == 92) {
            this.r.read();
        }
        this.space();
        if (this.number()) {
            this.space();
        }
        if (!this.newline()) {
            throw new SyntaxException("No newline after block definition", this.line);
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (this.block_line(n, stringBuffer, (char)n2)) {
        }
        String string = stringBuffer.toString();
        if (string.charAt(string.length() - 1) == '\n') {
            string = string.substring(0, string.length() - 1);
        }
        this.event.content("string", string);
        return true;
    }

    public boolean block_line(int n, StringBuffer stringBuffer, char c) throws Exception {
        int n2 = this.indent();
        if (n2 < n) {
            return false;
        }
        n = n2;
        this.indent(n);
        if (this.r.current() == -1) {
            return false;
        }
        this.mark();
        this.linesp();
        stringBuffer.append(this.r.string());
        this.unmark();
        if (c == '|') {
            stringBuffer.append('\n');
        } else {
            stringBuffer.append(' ');
        }
        this.newline();
        return true;
    }

    public boolean list() throws Exception {
        int n;
        if (this.r.current() != 91) {
            return false;
        }
        this.r.read();
        this.sendEvents();
        this.event.event(91);
        while (this.list_entry()) {
            n = this.r.current();
            if (n == 93) {
                this.r.read();
                this.event.event(93);
                return true;
            }
            if (n != 44) {
                throw new SyntaxException("inline list error: expecting ','", this.line);
            }
            this.r.read();
        }
        n = this.r.current();
        if (n == 93) {
            this.r.read();
            this.event.event(93);
            return true;
        }
        throw new SyntaxException("inline list error", this.line);
    }

    public boolean list_entry() throws Exception {
        this.space();
        if (!this.loose_value_inline()) {
            return false;
        }
        this.space();
        return true;
    }

    public boolean map() throws Exception {
        int n;
        if (this.r.current() != 123) {
            return false;
        }
        this.r.read();
        this.sendEvents();
        this.event.event(123);
        while (this.map_entry()) {
            n = this.r.current();
            if (n == 125) {
                this.r.read();
                this.event.event(125);
                return true;
            }
            if (n != 44) {
                throw new SyntaxException("inline map error: expecting ','", this.line);
            }
            this.r.read();
        }
        n = this.r.current();
        if (n == 125) {
            this.r.read();
            this.event.event(125);
            return true;
        }
        throw new SyntaxException("inline map error", this.line);
    }

    public boolean map_entry() throws Exception {
        this.space();
        if (!this.value_inline()) {
            return false;
        }
        this.space();
        if (this.r.current() != 58) {
            return false;
        }
        this.r.read();
        this.event.event(58);
        if (!this.space()) {
            throw new SyntaxException("No space after ':'", this.line);
        }
        if (!this.loose_value_inline()) {
            throw new SyntaxException("No value after ':'", this.line);
        }
        this.space();
        return true;
    }

    public boolean document_first() throws Exception {
        boolean bl;
        boolean bl2 = bl = this.nlist(-1) || this.nmap(-1);
        if (!bl) {
            throw new SyntaxException("first document is not a nested list or map", this.line);
        }
        return true;
    }

    public boolean document_next() throws Exception {
        if (!this.header()) {
            return false;
        }
        return this.value_na(-1);
    }

    public void parse() throws Exception {
        try {
            while (this.comment(-1, false)) {
            }
            if (!this.header()) {
                this.document_first();
            } else {
                this.value_na(-1);
            }
            while (this.document_next()) {
            }
        }
        catch (SyntaxException syntaxException) {
            this.event.error(syntaxException, syntaxException.line);
        }
    }

    private void mark() {
        this.r.mark();
    }

    private void reset() {
        this.r.reset();
    }

    private void unmark() {
        this.r.unmark();
    }

    public ParserEvent getEvent() {
        return this.event;
    }

    public void setEvent(ParserEvent parserEvent) {
        this.event = parserEvent;
    }
}

