/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.model;

import com.sdicons.json.model.JSONComplex;
import com.sdicons.json.model.JSONValue;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONArray
extends JSONComplex {
    private List<JSONValue> array = new ArrayList<JSONValue>();

    @Override
    public int size() {
        return this.array.size();
    }

    public List<JSONValue> getValue() {
        return this.array;
    }

    public String toString() {
        StringBuffer lBuf = new StringBuffer();
        lBuf.append("JSONArray(").append(this.getLine()).append(":").append(this.getCol()).append(")[");
        for (int i = 0; i < this.array.size(); ++i) {
            JSONValue jsonValue = this.array.get(i);
            lBuf.append(jsonValue.toString());
            if (i >= this.array.size() - 1) continue;
            lBuf.append(", ");
        }
        lBuf.append("]");
        return lBuf.toString();
    }

    public JSONValue get(int i) {
        return this.array.get(i);
    }

    @Override
    protected String render(boolean aPretty, String aIndent) {
        StringBuffer lBuf = new StringBuffer();
        if (aPretty) {
            lBuf.append(aIndent).append("[\n");
            String lIndent = aIndent + "   ";
            for (int i = 0; i < this.array.size(); ++i) {
                JSONValue jsonValue = this.array.get(i);
                lBuf.append(jsonValue.render(true, lIndent));
                if (i < this.array.size() - 1) {
                    lBuf.append(",\n");
                    continue;
                }
                lBuf.append("\n");
            }
            lBuf.append(aIndent).append("]");
        } else {
            lBuf.append("[");
            for (int i = 0; i < this.array.size(); ++i) {
                JSONValue jsonValue = this.array.get(i);
                lBuf.append(jsonValue.render(false, ""));
                if (i >= this.array.size() - 1) continue;
                lBuf.append(",");
            }
            lBuf.append("]");
        }
        return lBuf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSONArray jsonArray = (JSONArray)o;
        return ((Object)this.array).equals(jsonArray.array);
    }

    public int hashCode() {
        return ((Object)this.array).hashCode();
    }

    @Override
    public Object strip() {
        LinkedList<Object> lResult = new LinkedList<Object>();
        for (JSONValue lVal : this.array) {
            lResult.add(lVal.strip());
        }
        return lResult;
    }
}

