/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Hashtable;
import org.nishiohirokazu.awt.ColorHolder;
import org.nishiohirokazu.graph.RenderableVertex;
import org.nishiohirokazu.grinEdit.UtilCast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircleVertex
extends RenderableVertex {
    Color bgcolor = ColorHolder.GRINGREEN;
    Point bound;
    Color frameColor = ColorHolder.BLACK;
    protected int diameter = 15;

    public void setBgcolor(Object rgb) {
        this.bgcolor = UtilCast.o2awtColor(rgb);
    }

    public void setFrameColor(Object rgb) {
        this.frameColor = UtilCast.o2awtColor(rgb);
    }

    public void setDiameter(Object d) {
        this.diameter = UtilCast.getIntValue(d);
    }

    @Override
    public Hashtable<String, Object> getParams() {
        Hashtable<String, Object> result = super.getParams();
        result.put("bgcolor", UtilCast.Color2Vector(this.bgcolor));
        result.put("frameColor", UtilCast.Color2Vector(this.frameColor));
        result.put("diameter", this.diameter);
        return result;
    }

    @Override
    public double calcOffset(double[] ndir) {
        return this.diameter / 2;
    }

    @Override
    public void render(Object target) {
        Graphics gc = (Graphics)target;
        if (this.selected) {
            gc.setColor(ColorHolder.SELECTED_VERTEX);
        } else {
            gc.setColor(this.bgcolor);
        }
        int left = (int)(this.screenPos[0] - (double)(this.diameter / 2));
        int top = (int)(this.screenPos[1] - (double)(this.diameter / 2));
        gc.fillOval(left, top, this.diameter, this.diameter);
        gc.setColor(this.frameColor);
        gc.drawOval(left, top, this.diameter, this.diameter);
    }
}

