/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.grinEdit;

import java.awt.Canvas;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.text.DecimalFormat;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.nishiohirokazu.awt.DoubleBufferer;
import org.nishiohirokazu.grinEdit.DragDropMediator;
import org.nishiohirokazu.grinEdit.Infrastructure;
import org.nishiohirokazu.grinEdit.Mediator;
import org.nishiohirokazu.grinEdit.mouseOperation.MouseMediator;
import org.nishiohirokazu.swt.ColorHolder;

public class GRINEditDefaultGUI {
    Display display;
    Shell shell;
    private long prevUpdateTime = 0L;
    private long updateTime = 1000L;
    private int fpsCount = 0;
    private DecimalFormat fpsFormat = new DecimalFormat(" 0.00 frames/sec");
    private Timer timer;

    public GRINEditDefaultGUI() {
        this.display = Infrastructure.getDisplay();
        Mediator med = Mediator.getInstance();
        this.shell = med.getShell();
        this.shell.setLayout((Layout)new FillLayout());
        Composite comp = new Composite((Composite)this.shell, 0x1000000);
        Frame frame = SWT_AWT.new_Frame((Composite)comp);
        Canvas canvas = new Canvas();
        frame.add(canvas);
        Infrastructure.canvas = canvas;
        MouseMediator mm = med.getMouseMediator();
        Infrastructure.execPythonScript("initMouseMediator.py");
        canvas.addMouseListener(mm);
        canvas.addMouseMotionListener(mm);
        canvas.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent e) {
                Rectangle b = Infrastructure.getCanvas().getBounds();
                Mediator.getInstance().canvasSize = new int[]{b.width, b.height};
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentHidden(ComponentEvent e) {
            }
        });
        Infrastructure.execPythonScript("initMenu.py");
        this.shell.pack();
        ColorHolder.initialize((Device)this.display);
        Infrastructure.execPythonScript("configDefaultGUI.py");
        this.shell.open();
        this.acceptDragDrop();
        this.timer = new Timer();
        TimerTask tt = new TimerTask(){

            public void run() {
                GRINEditDefaultGUI.this.updateScreen();
            }
        };
        this.updateTime = System.currentTimeMillis();
        this.timer.schedule(tt, 0L, 10L);
    }

    private void acceptDragDrop() {
        DropTarget dndtarget = new DropTarget((Control)this.shell, 17);
        FileTransfer transfer = FileTransfer.getInstance();
        Transfer[] types = new Transfer[]{transfer};
        dndtarget.setTransfer(types);
        dndtarget.addDropListener((DropTargetListener)new DragDropMediator());
    }

    public void start() {
        while (!this.shell.isDisposed()) {
            try {
                this.updateTime = System.currentTimeMillis();
                long diff = this.updateTime - this.prevUpdateTime;
                if (diff > 1000L) {
                    double fps = 1000.0 * (double)this.fpsCount / (double)diff;
                    this.shell.setText(String.valueOf(Mediator.VERSION_STR) + " - " + this.fpsFormat.format(fps));
                    this.prevUpdateTime = this.updateTime;
                    this.fpsCount = 0;
                }
                if (this.display.readAndDispatch()) continue;
                this.display.sleep();
            }
            catch (Exception e) {
                this.showErrorDialog(e);
            }
        }
        this.finish();
    }

    private void showErrorDialog(Exception e) {
        JFrame f = new JFrame("Exception");
        f.setSize(600, 200);
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(2);
        JTextArea textArea = new JTextArea();
        e.printStackTrace();
        String msg = e.getLocalizedMessage();
        if (msg == null) {
            msg = e.getMessage();
        }
        if (msg == null) {
            msg = e.toString();
        }
        textArea.setText(msg);
        f.getContentPane().add(new JScrollPane(textArea));
        f.setVisible(true);
    }

    private void finish() {
        this.timer.cancel();
        this.display.dispose();
    }

    public void updateScreen() {
        Mediator med = Mediator.getInstance();
        if (this.shell.isDisposed()) {
            med.pause = true;
            ColorHolder.dispose();
        } else {
            DoubleBufferer dbuf = Infrastructure.getDoubleBufferer();
            if (!med.pause) {
                if (med.autoLayout) {
                    med.getLayoutEngine().layoutStep(med.getGraph());
                }
                if (med.rendering) {
                    dbuf.clearBG();
                    Graphics bg = dbuf.getBG();
                    med.render(bg);
                    med.mouseMed.draw();
                    dbuf.draw();
                }
            }
        }
        ++this.fpsCount;
    }
}

