/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.grinEdit;

import java.util.Hashtable;
import java.util.Vector;
import org.nishiohirokazu.graph.Graph;
import org.nishiohirokazu.graph.IEdge;
import org.nishiohirokazu.graph.IVertex;
import org.nishiohirokazu.grinEdit.ILayout;
import org.nishiohirokazu.layout.IMassPoint;

public class SeparateComponentLayout
implements ILayout {
    private int width;
    private int x;
    private int y;
    private int phase;
    private int i;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutStep(Graph g) {
        Hashtable<String, IVertex> vertexDict = g.getVertexDict();
        Hashtable<String, IEdge> edgeDict = g.getEdgeDict();
        Hashtable<String, IVertex> hashtable = vertexDict;
        synchronized (hashtable) {
            Hashtable<String, IEdge> hashtable2 = edgeDict;
            synchronized (hashtable2) {
                Hashtable adjDict = new Hashtable();
                for (IVertex v : vertexDict.values()) {
                    adjDict.put(v, new Vector());
                }
                for (IEdge e : edgeDict.values()) {
                    IVertex v1 = e.getV1();
                    IVertex iVertex = e.getV2();
                    ((Vector)adjDict.get(v1)).add(iVertex);
                    ((Vector)adjDict.get(iVertex)).add(v1);
                }
                Vector<IVertex> visited = new Vector<IVertex>();
                Vector components = new Vector();
                for (IVertex v : vertexDict.values()) {
                    if (visited.contains(v)) continue;
                    Vector<IVertex> aComp = new Vector<IVertex>();
                    Vector<IVertex> queue = new Vector<IVertex>();
                    queue.add(v);
                    while (queue.size() > 0) {
                        Vector<IVertex> newQueue = new Vector<IVertex>();
                        for (IVertex current : queue) {
                            visited.add(current);
                            aComp.add(current);
                            Vector neighbors = (Vector)adjDict.get(current);
                            for (IVertex neighbor : neighbors) {
                                if (visited.contains(neighbor) || newQueue.contains(neighbor)) continue;
                                newQueue.add(neighbor);
                            }
                        }
                        queue = newQueue;
                    }
                    components.add(aComp);
                }
                int SCALE = 10;
                this.init();
                for (Vector vector : components) {
                    this.next();
                    for (IVertex v : vector) {
                        IMassPoint mv = (IMassPoint)((Object)v);
                        double[] position = mv.getPosition();
                        position[0] = (double)(this.x * SCALE) + Math.random() - 0.5;
                        position[1] = (double)(this.y * SCALE) + Math.random() - 0.5;
                    }
                }
            }
        }
    }

    private void init() {
        this.phase = 0;
    }

    private void next() {
        if (this.phase == 0) {
            this.x = 0;
            this.y = 0;
            this.phase = 1;
            this.width = 1;
            this.i = 0;
        } else if (this.phase == 1) {
            ++this.x;
            ++this.i;
            if (this.i == this.width) {
                this.phase = 2;
                this.i = 0;
            }
        } else if (this.phase == 2) {
            ++this.y;
            ++this.i;
            if (this.i == this.width) {
                this.phase = 3;
                ++this.width;
                this.i = 0;
            }
        } else if (this.phase == 3) {
            --this.x;
            ++this.i;
            if (this.i == this.width) {
                this.phase = 4;
                this.i = 0;
            }
        } else if (this.phase == 4) {
            --this.y;
            ++this.i;
            if (this.i == this.width) {
                this.phase = 1;
                this.i = 0;
                ++this.width;
            }
        }
    }

    public static void main(String[] args) {
        SeparateComponentLayout s = new SeparateComponentLayout();
        s.init();
        int i = 0;
        while (i < 10) {
            s.next();
            System.out.println(String.valueOf(s.x) + ", " + s.y);
            ++i;
        }
    }
}

