/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.grinEdit;

import java.util.Hashtable;
import java.util.Vector;
import org.nishiohirokazu.graph.Graph;
import org.nishiohirokazu.graph.IEdge;
import org.nishiohirokazu.graph.IVertex;
import org.nishiohirokazu.grinEdit.ILayout;
import org.nishiohirokazu.grinEdit.Mediator;
import org.nishiohirokazu.layout.IMassPoint;
import org.nishiohirokazu.layout.PhysicalLaw;
import org.nishiohirokazu.vector.Vec;

public class SimpleLayout
implements ILayout {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutStep(Graph g) {
        Hashtable<String, IVertex> vertexDict = g.getVertexDict();
        Hashtable<String, IEdge> edgeDict = g.getEdgeDict();
        Hashtable<String, IVertex> hashtable = vertexDict;
        synchronized (hashtable) {
            Hashtable<String, IEdge> hashtable2 = edgeDict;
            synchronized (hashtable2) {
                int MAX_ITER = 10;
                Mediator med = Mediator.getInstance();
                Hashtable<String, IVertex> vs = med.graph.getVertexDict();
                Vector<double[]> oldPos = new Vector<double[]>(vs.size());
                for (IVertex o : vs.values()) {
                    IMassPoint iMassPoint = (IMassPoint)((Object)o);
                    double[] p = (double[])iMassPoint.getPosition().clone();
                    if (p[0] == Double.NaN) {
                        Mediator.getInstance().autoLayout = false;
                        return;
                    }
                    oldPos.add(p);
                }
                int iter = 0;
                while (iter < MAX_ITER) {
                    for (IVertex o : vs.values()) {
                        IMassPoint v = (IMassPoint)((Object)o);
                        v.getDVelList().clear();
                    }
                    boolean isAllSatisfied = true;
                    Hashtable<String, Object> hashtable3 = g.getLawDict();
                    for (PhysicalLaw physicalLaw : hashtable3.values()) {
                        boolean isSatisfied = physicalLaw.apply(iter);
                        if (isSatisfied) continue;
                        isAllSatisfied = false;
                    }
                    for (IMassPoint iMassPoint : vs.values()) {
                        double[] vel = new double[2];
                        int j = 0;
                        while (j < iMassPoint.getDVelList().size()) {
                            double[] f = (double[])iMassPoint.getDVelList().get(j);
                            Vec.addD(vel, f);
                            ++j;
                        }
                        Vec.addD(iMassPoint.getPosition(), vel);
                    }
                    if (isAllSatisfied) break;
                    ++iter;
                }
                int i = 0;
                for (IMassPoint iMassPoint : vs.values()) {
                    iMassPoint.setVelocity(Vec.sub(iMassPoint.getPosition(), (double[])oldPos.get(i)));
                    ++i;
                }
            }
        }
    }
}

