/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.layout;

import java.util.Hashtable;
import org.nishiohirokazu.graph.RenderableVertex;
import org.nishiohirokazu.grinEdit.Infrastructure;
import org.nishiohirokazu.grinEdit.Mediator;
import org.nishiohirokazu.grinEdit.UtilCast;
import org.nishiohirokazu.layout.MassPoint;
import org.nishiohirokazu.layout.PhysicalLaw;
import org.nishiohirokazu.swt.ViewportTransformer;

public abstract class PL_AbstructWall
extends PhysicalLaw {
    protected boolean top = true;
    protected boolean bottom = true;
    protected boolean left = true;
    protected boolean right = true;
    protected int tolerance = 8;
    protected ViewportTransformer vp;
    private String targetName;

    protected abstract boolean wall(double var1, double var3, double var5, int var7, boolean var8, MassPoint var9);

    public Hashtable getParams() {
        Hashtable result = super.getParams();
        result.put("top", new Boolean(this.top));
        result.put("bottom", new Boolean(this.top));
        result.put("left", new Boolean(this.left));
        result.put("right", new Boolean(this.right));
        return result;
    }

    public void setTop(Object o) {
        this.top = UtilCast.o2bool(o);
    }

    public void setBottom(Object o) {
        this.bottom = UtilCast.o2bool(o);
    }

    public void setLeft(Object o) {
        this.left = UtilCast.o2bool(o);
    }

    public void setRight(Object o) {
        this.right = UtilCast.o2bool(o);
    }

    public PL_AbstructWall(String targetName) {
        this.targetName = targetName;
    }

    public boolean apply(int iter) {
        boolean isSatisfied = true;
        if (iter == 0) {
            return false;
        }
        if (iter < this.tolerance) {
            int[] size;
            this.vp = Infrastructure.getViewportTransformer();
            try {
                size = Mediator.getInstance().getCanvasSize();
            }
            catch (Exception e) {
                e.printStackTrace();
                size = new int[]{500, 500};
            }
            int width = size[0];
            int height = size[1];
            Hashtable target = Mediator.getInstance().getNamedDict(this.targetName);
            for (RenderableVertex v : target.values()) {
                double[] screenPos = this.vp.viewportTransform(v.getPosition());
                double x = screenPos[0];
                double y = screenPos[1];
                if (this.left) {
                    isSatisfied = this.wall(x, 0.0, 1.0, 0, isSatisfied, v);
                }
                if (this.right) {
                    isSatisfied = this.wall(x, width, -1.0, 0, isSatisfied, v);
                }
                if (this.top) {
                    isSatisfied = this.wall(y, 0.0, 1.0, 1, isSatisfied, v);
                }
                if (!this.bottom) continue;
                isSatisfied = this.wall(y, height, -1.0, 1, isSatisfied, v);
            }
        }
        return isSatisfied;
    }
}

