/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.grinEdit;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.xmlrpc.WebServer;
import org.eclipse.swt.widgets.Shell;
import org.nishiohirokazu.graph.DefaultGraph;
import org.nishiohirokazu.graph.Graph;
import org.nishiohirokazu.graph.IEdge;
import org.nishiohirokazu.graph.IHasScreenPos;
import org.nishiohirokazu.graph.IVertex;
import org.nishiohirokazu.grinEdit.CommonGateway;
import org.nishiohirokazu.grinEdit.DefaultRenderer;
import org.nishiohirokazu.grinEdit.ILayout;
import org.nishiohirokazu.grinEdit.Infrastructure;
import org.nishiohirokazu.grinEdit.PluginClassLoader;
import org.nishiohirokazu.grinEdit.Selection;
import org.nishiohirokazu.grinEdit.SimpleLayout;
import org.nishiohirokazu.grinEdit.mouseOperation.MouseMediator;
import org.nishiohirokazu.layout.PL_SpringEdge;
import org.nishiohirokazu.vector.Vec;

public class Mediator {
    private static Mediator instance;
    private static ILayout layoutEngine;
    static String VERSION_STR;
    private Shell shell;
    public Selection selection;
    static String[] classPrefix;
    public boolean pause;
    public boolean autoLayout = true;
    public boolean rendering = true;
    public Graph graph;
    public MouseMediator mouseMed;
    private CommonGateway xmlrpc_handler;
    int[] canvasSize = new int[2];
    private ClassLoader pluginClassLoader;
    private DefaultRenderer renderer;

    static {
        VERSION_STR = "GRINEdit alpha 0.20";
        classPrefix = new String[]{"", "org.nishiohirokazu.graph.", "org.nishiohirokazu.layout."};
    }

    public static Mediator getInstance() {
        if (instance == null) {
            instance = new Mediator();
        }
        return instance;
    }

    public void setLayoutEngine(String classname) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        layoutEngine = (ILayout)this.loadClass(classname).newInstance();
    }

    public ILayout getLayoutEngine() {
        if (layoutEngine == null) {
            Mediator.setLayoutEngine(new SimpleLayout());
        }
        return layoutEngine;
    }

    public static void setLayoutEngine(ILayout layoutEngine) {
        Mediator.layoutEngine = layoutEngine;
    }

    public Vector getSelectedEdges() {
        return this.selection.getEdges();
    }

    public List getSelectedVertex() {
        return this.selection.getVertex();
    }

    public Vector getMarginalEdges() {
        return this.selection.getMarginalEdges();
    }

    public void setSelection(Vector vertexes) {
        this.selection.set(vertexes);
    }

    public MouseMediator getMouseMediator() {
        if (this.mouseMed == null) {
            this.mouseMed = new MouseMediator();
        }
        return this.mouseMed;
    }

    private Mediator() {
        this.selection = new Selection(this);
        this.graph = new DefaultGraph();
    }

    public Class loadClass(String classname) throws ClassNotFoundException {
        Class<?> cls = null;
        int i = 0;
        while (i < classPrefix.length) {
            try {
                cls = Class.forName(String.valueOf(classPrefix[i]) + classname);
                break;
            }
            catch (ClassNotFoundException e) {
                ++i;
            }
        }
        if (cls == null) {
            if (this.pluginClassLoader == null) {
                this.pluginClassLoader = new PluginClassLoader();
            }
            if ((cls = this.pluginClassLoader.loadClass(classname)) == null) {
                throw new ClassNotFoundException(classname);
            }
        }
        return cls;
    }

    public void setGraph(Graph g) {
        this.graph = g;
    }

    public Shell getShell() {
        if (this.shell == null) {
            this.shell = new Shell(Infrastructure.getDisplay());
        }
        return this.shell;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Hashtable getEdgeDict() {
        return this.graph.getEdgeDict();
    }

    public Hashtable getVertexDict() {
        return this.graph.getVertexDict();
    }

    public IVertex getVertex(String name) {
        return this.graph.getVertexDict().get(name);
    }

    public IEdge getEdge(String name) {
        return this.graph.getEdgeDict().get(name);
    }

    public Collection getVertexList() {
        return this.graph.getVertexDict().values();
    }

    public List getVertexInRange(int left, int top, int right, int bottom) {
        Vector<IVertex> result = new Vector<IVertex>();
        for (IVertex v : this.graph.getVertexDict().values()) {
            IHasScreenPos sv = (IHasScreenPos)v;
            double[] pos = sv.getScreenPos();
            if (!(((double)left - pos[0]) * ((double)right - pos[0]) < 0.0) || !(((double)top - pos[1]) * ((double)bottom - pos[1]) < 0.0)) continue;
            result.add(v);
        }
        return result;
    }

    public IVertex getNearestVertex(double x, double y) {
        return this.getNearestVertex(x, y, Double.MAX_VALUE);
    }

    public IVertex getNearestVertex(double x, double y, double radius) {
        double[] tpos = new double[]{x, y};
        double minDist = radius;
        IVertex result = null;
        for (IVertex v : this.graph.getVertexDict().values()) {
            double dist;
            IHasScreenPos sv = (IHasScreenPos)v;
            double[] pos = sv.getScreenPos();
            if (pos == null || !((dist = Vec.sqDistance(tpos, pos)) < minDist)) continue;
            minDist = dist;
            result = v;
        }
        return result;
    }

    public int[] getCanvasSize() {
        return this.canvasSize;
    }

    public String[] getMouseOperationNames() {
        String[] result = new String[this.mouseMed.oparations.size()];
        Iterator iter = this.mouseMed.oparations.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            String name;
            result[i] = name = (String)iter.next();
            ++i;
        }
        return result;
    }

    public void setServer(WebServer server) {
        Infrastructure.server = server;
    }

    public CommonGateway getCommonGateway() {
        if (this.xmlrpc_handler == null) {
            this.xmlrpc_handler = CommonGateway.getInstance();
        }
        return this.xmlrpc_handler;
    }

    public void setDefaultSpringStrength(double d) {
        Hashtable law = this.getNamedDict("Law");
        PL_SpringEdge sp = (PL_SpringEdge)law.get("PL_SpringEdge");
        sp.defaultSpringStrength = d;
    }

    public double getDefaultSpringStrength() {
        Hashtable law = this.getNamedDict("Law");
        PL_SpringEdge sp = (PL_SpringEdge)law.get("PL_SpringEdge");
        return sp.defaultSpringStrength;
    }

    public void render(Object bg) {
        if (this.renderer == null) {
            this.renderer = new DefaultRenderer();
        }
        this.renderer.render(bg);
    }

    public void setRenderer(String classname) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.renderer = (DefaultRenderer)this.loadClass(classname).newInstance();
    }

    public Hashtable getNamedDict(String dictName) {
        return this.graph.getNamedDict(dictName);
    }

    public Object getObject(String objName) {
        Hashtable namespace = this.graph.getNamedDict("All");
        Object result = namespace.get(objName);
        if (result == null) {
            throw new RuntimeException(String.valueOf(objName) + "\u3068\u3044\u3046\u540d\u524d\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u3042\u308a\u307e\u305b\u3093");
        }
        return result;
    }

    public Set getDictNames() {
        return this.graph.getDictNames();
    }
}

