/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.layout;

import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.nishiohirokazu.graph.IGRINObject;
import org.nishiohirokazu.graph.IVertex;
import org.nishiohirokazu.graph.RenderableVertex;
import org.nishiohirokazu.grinEdit.Infrastructure;
import org.nishiohirokazu.grinEdit.Mediator;
import org.nishiohirokazu.grinEdit.UtilCast;
import org.nishiohirokazu.layout.IMassPoint;
import org.nishiohirokazu.layout.PhysicalLaw;
import org.nishiohirokazu.swt.ViewportTransformer;
import org.nishiohirokazu.vector.Vec;

public class PL_Anchor
extends PhysicalLaw {
    private int tolerance = 9;
    private Hashtable<IVertex, double[]> target = new Hashtable();

    public boolean apply(int iter) {
        boolean isSatisfied = true;
        if (iter == 0) {
            return false;
        }
        if (iter < this.tolerance) {
            ViewportTransformer vp = Infrastructure.getViewportTransformer();
            for (IVertex _v : this.target.keySet()) {
                IMassPoint v = (IMassPoint)((Object)_v);
                double[] position = this.target.get(v);
                double[] diff = Vec.sub(position, v.getPosition());
                if (!(Vec.mag(vp.scaling(diff)) > 0.1)) continue;
                isSatisfied = false;
                v.getDVelList().add(diff);
            }
        }
        return isSatisfied;
    }

    public Hashtable getParams() {
        Hashtable result = super.getParams();
        Hashtable<String, Vector> target_ = new Hashtable<String, Vector>();
        for (IVertex _v : this.target.keySet()) {
            IGRINObject v = (IGRINObject)((Object)_v);
            target_.put(v.getId(), UtilCast.Vec2Vector(this.target.get(v)));
        }
        result.put("target", target_);
        return result;
    }

    public void putTarget(String name, Object value) {
        this.target.put((RenderableVertex)Mediator.getInstance().getObject(name), UtilCast.o2doubleArray(value));
    }

    public void putTarget(RenderableVertex o, Object value) {
        this.target.put(o, UtilCast.o2doubleArray(value));
    }

    public void removeTarget(String name) {
        this.target.remove(Mediator.getInstance().getObject(name));
    }

    public void setTarget(Object o) {
        this.target = new Hashtable();
        Map map = UtilCast.maplike2map(o);
        Mediator med = Mediator.getInstance();
        for (Object key : map.keySet()) {
            this.target.put(med.getVertex(key.toString()), UtilCast.o2doubleArray(map.get(key)));
        }
    }
}

