/*
 * Decompiled with CFR 0.152.
 */
package org.nishiohirokazu.layout;

import java.util.Hashtable;
import org.nishiohirokazu.grinEdit.Mediator;
import org.nishiohirokazu.grinEdit.UtilCast;
import org.nishiohirokazu.layout.IMassPoint;
import org.nishiohirokazu.layout.PhysicalLaw;

public class PL_Repulsion
extends PhysicalLaw {
    public double repulsionK = 0.02;
    public double repulsionRadius = 3.0;
    private String targetName;

    public PL_Repulsion() {
        this.targetName = "Vertex";
    }

    public PL_Repulsion(String targetName) {
        this.targetName = targetName;
    }

    public boolean apply(int iter) {
        if (iter == 0) {
            Hashtable target = Mediator.getInstance().getNamedDict(this.targetName);
            double SQ_REPULSION_RADIUS = this.repulsionRadius * this.repulsionRadius;
            double INV_SQ_REPULSION_RADIUS = 1.0 / SQ_REPULSION_RADIUS;
            double REPULSION_K = this.repulsionK;
            Object[] vs = target.values().toArray();
            IMassPoint[] mvs = new IMassPoint[vs.length];
            double[][] posList = new double[vs.length][];
            double[][] forceList = new double[vs.length][];
            int i = 0;
            while (i < vs.length) {
                IMassPoint v;
                mvs[i] = v = (IMassPoint)vs[i];
                posList[i] = v.getPosition();
                forceList[i] = new double[]{0.0, 0.0};
                ++i;
            }
            i = 0;
            while (i < vs.length) {
                double[] v1pos = posList[i];
                int j = 0;
                while (j < i) {
                    double dist_sq;
                    double dist_normalize;
                    double[] v2pos = posList[j];
                    double dirx = v2pos[0] - v1pos[0];
                    double diry = v2pos[1] - v1pos[1];
                    if (!(dirx > this.repulsionRadius || dirx < -this.repulsionRadius || diry > this.repulsionRadius || diry < -this.repulsionRadius || !((dist_normalize = (dist_sq = dirx * dirx + diry * diry) * INV_SQ_REPULSION_RADIUS) < 1.0))) {
                        double dist = Math.sqrt(dist_sq);
                        double ndirx = dirx / dist;
                        double ndiry = diry / dist;
                        if (dist_sq == 0.0) {
                            double theta = Math.PI * 2 * Math.random();
                            ndirx = Math.cos(theta);
                            ndiry = Math.sin(theta);
                        }
                        double power = REPULSION_K * (1.0 - dist_normalize);
                        double forcex = ndirx * power;
                        double forcey = ndiry * power;
                        double[] dArray = forceList[j];
                        dArray[0] = dArray[0] + forcex;
                        double[] dArray2 = forceList[j];
                        dArray2[1] = dArray2[1] + forcey;
                        double[] dArray3 = forceList[i];
                        dArray3[0] = dArray3[0] - forcex;
                        double[] dArray4 = forceList[i];
                        dArray4[1] = dArray4[1] - forcey;
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < vs.length) {
                mvs[i].getDVelList().add(forceList[i]);
                ++i;
            }
        }
        return true;
    }

    public void setRepulsionK(Object o) {
        this.repulsionK = UtilCast.o2double(o);
    }

    public void setRepulsionRadius(Object o) {
        this.repulsionRadius = UtilCast.o2double(o);
    }

    public Hashtable getParams() {
        Hashtable result = super.getParams();
        result.put("repulsionK", this.repulsionK);
        result.put("repulsionRadius", this.repulsionRadius);
        return result;
    }
}

