/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.serializer.helper.impl;

import com.sdicons.json.model.JSONArray;
import com.sdicons.json.model.JSONObject;
import com.sdicons.json.model.JSONString;
import com.sdicons.json.model.JSONValue;
import com.sdicons.json.serializer.helper.Helper;
import com.sdicons.json.serializer.marshall.JSONMarshall;
import com.sdicons.json.serializer.marshall.MarshallException;
import java.util.HashMap;
import java.util.Map;

public class MapHelper
implements Helper {
    private static final String ATTR_KEY = "key";
    private static final String ATTR_VALUE = "value";

    public void renderValue(Object aObj, JSONObject aObjectElement, JSONMarshall aMarshall, HashMap aPool) throws MarshallException {
        JSONArray lArray = new JSONArray();
        aObjectElement.getValue().put("=", lArray);
        Map lMap = (Map)aObj;
        for (Object lKey : lMap.keySet()) {
            Object lValue = lMap.get(lKey);
            JSONObject lKeyValuePair = new JSONObject();
            lArray.getValue().add(lKeyValuePair);
            lKeyValuePair.getValue().put(ATTR_KEY, aMarshall.marshallImpl(lKey, aPool));
            lKeyValuePair.getValue().put(ATTR_VALUE, aMarshall.marshallImpl(lValue, aPool));
        }
    }

    public Object parseValue(JSONObject aObjectElement, JSONMarshall aMarshall, HashMap aPool) throws MarshallException {
        JSONArray lArray = (JSONArray)aObjectElement.getValue().get("=");
        JSONMarshall.requireStringAttribute(aObjectElement, "c");
        String lMapClassName = ((JSONString)aObjectElement.get("c")).getValue();
        String lId = null;
        try {
            JSONMarshall.requireStringAttribute(aObjectElement, "&");
            lId = ((JSONString)aObjectElement.get("&")).getValue();
        }
        catch (Exception eIgnore) {
            // empty catch block
        }
        try {
            Class<?> lMapClass = Class.forName(lMapClassName);
            Map lMap = null;
            lMap = (Map)lMapClass.newInstance();
            if (lId != null) {
                aPool.put(lId, lMap);
            }
            for (JSONValue lKeyValue : lArray.getValue()) {
                Object lKey = aMarshall.unmarshallImpl((JSONObject)((JSONObject)lKeyValue).getValue().get(ATTR_KEY), aPool);
                Object lValue = aMarshall.unmarshallImpl((JSONObject)((JSONObject)lKeyValue).getValue().get(ATTR_VALUE), aPool);
                lMap.put(lKey, lValue);
            }
            return lMap;
        }
        catch (IllegalAccessException e) {
            String lMsg = "IllegalAccessException while trying to instantiate map: " + lMapClassName;
            throw new MarshallException(lMsg);
        }
        catch (InstantiationException e) {
            String lMsg = "InstantiationException while trying to instantiate map: " + lMapClassName;
            throw new MarshallException(lMsg);
        }
        catch (ClassNotFoundException e) {
            String lMsg = "ClassNotFoundException while trying to instantiate map: " + lMapClassName;
            throw new MarshallException(lMsg);
        }
    }

    public Class getHelpedClass() {
        return Map.class;
    }
}

