/*
 * Decompiled with CFR 0.152.
 */
package org.ho.yaml;

import java.awt.Color;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ho.yaml.ReflectionUtil;
import org.ho.yaml.YamlEncoder;
import org.ho.yaml.YamlParserException;

class SpecialTreatmentManager {
    Map<String, DefaultSpecialTreatment> treatmentTable = new HashMap<String, DefaultSpecialTreatment>();

    public SpecialTreatmentManager() {
        this.initialize();
    }

    void registerConstructor(String string, String[] stringArray) {
        if (this.treatmentTable.containsKey(string)) {
            this.treatmentTable.get((Object)string).constructorFields = stringArray;
        } else {
            DefaultSpecialTreatment defaultSpecialTreatment = new DefaultSpecialTreatment(string);
            defaultSpecialTreatment.constructorFields = stringArray;
            this.treatmentTable.put(string, defaultSpecialTreatment);
        }
    }

    void registerSpecialTreatment(String string, DefaultSpecialTreatment defaultSpecialTreatment) {
        this.treatmentTable.put(string, defaultSpecialTreatment);
    }

    void removeProperty(String string, String string2) {
        if (this.treatmentTable.containsKey(string)) {
            this.treatmentTable.get((Object)string).removeFields.add(string2);
        } else {
            DefaultSpecialTreatment defaultSpecialTreatment = new DefaultSpecialTreatment(string);
            defaultSpecialTreatment.removeFields.add(string2);
            this.treatmentTable.put(string, defaultSpecialTreatment);
        }
    }

    public boolean needsSpecialTreatment(Object object) {
        if (object instanceof Holder) {
            return this.treatmentTable.containsKey(this.holderKey(object));
        }
        return this.treatmentTable.containsKey(object.getClass().getName());
    }

    public boolean needsSpecialTreatment(String string) {
        return this.treatmentTable.containsKey(string);
    }

    public void encode(Object object, YamlEncoder yamlEncoder, String string) {
        this.treatmentTable.get(object.getClass().getName()).encode(object, yamlEncoder, string);
    }

    public Class getPropertyType(Object object, String string) {
        return this.treatmentTable.get(this.holderKey(object)).getPropertyType(object, string);
    }

    public void setProperty(Object object, String string, Object object2) {
        this.treatmentTable.get(this.holderKey(object)).setProperty(object, string, object2);
    }

    public Object getHolder(String string) {
        return this.treatmentTable.get(string).getHolder();
    }

    public Object getRealObject(Object object) {
        return this.treatmentTable.get(this.holderKey(object)).getRealObject(object);
    }

    public String holderKey(Object object) {
        return ((Holder)object).clazz.getName();
    }

    public void traverseAndCount(Object object, YamlEncoder yamlEncoder) {
        this.treatmentTable.get(object.getClass().getName()).traverseAndCount(object, yamlEncoder);
    }

    void initialize() {
        this.registerConstructor("java.awt.Point", new String[]{"x", "y"});
        this.registerConstructor("java.awt.Dimension", new String[]{"width", "height"});
        this.registerConstructor("java.awt.Rectangle", new String[]{"x", "y", "width", "height"});
        this.registerConstructor("java.awt.Font", new String[]{"name", "style", "size"});
        this.removeProperty("java.awt.Rectangle", "bounds");
        this.removeProperty("java.awt.Dimension", "size");
        this.removeProperty("java.awt.Point", "location");
        this.registerSpecialTreatment("java.awt.Color", new ColorSpecialTreatment("java.awt.Color"));
        this.registerConstructor("java.awt.Color", new String[]{"red", "green", "blue", "alpha"});
        this.registerConstructor("javax.swing.plaf.ColorUIResource", new String[]{"red", "green", "blue"});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ColorSpecialTreatment
    extends DefaultSpecialTreatment {
        public ColorSpecialTreatment(String string) {
            super(string);
        }

        @Override
        public Object decode(Map<String, Object> map) {
            return new Color(((Number)map.get("red")).floatValue() / 256.0f, ((Number)map.get("green")).floatValue() / 256.0f, ((Number)map.get("blue")).floatValue() / 256.0f, ((Number)map.get("alpha")).floatValue() / 256.0f);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultSpecialTreatment {
        Class clazz;
        String[] constructorFields;
        List<String> removeFields = new ArrayList<String>();

        DefaultSpecialTreatment(String string) {
            try {
                this.clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException);
            }
        }

        public Object getHolder() {
            return new Holder(this.clazz);
        }

        public void setProperty(Object object, String string, Object object2) {
            Holder holder = (Holder)object;
            holder.values.put(string, object2);
        }

        public Object getRealObject(Object object) {
            Holder holder = (Holder)object;
            return this.decode(holder.values);
        }

        public Class getPropertyType(Object object, String string) {
            Object object2;
            try {
                object2 = this.clazz.getField(string);
                if (ReflectionUtil.isPublicMemberField((Field)object2)) {
                    return ((Field)object2).getType();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object2 = ReflectionUtil.getPropertyDescriptor(this.clazz, string);
            if (object2 != null) {
                return ((PropertyDescriptor)object2).getPropertyType();
            }
            throw new YamlParserException("No field or property named " + string + " found for class " + this.clazz.getName());
        }

        public Object decode(Map<String, Object> map) {
            ArrayList arrayList = new ArrayList();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            if (this.constructorFields != null) {
                for (String string : this.constructorFields) {
                    Class<?> clazz = null;
                    try {
                        Field exception = this.clazz.getField(string);
                        clazz = exception.getType();
                    }
                    catch (Exception exception) {
                        PropertyDescriptor propertyDescriptor = ReflectionUtil.getPropertyDescriptor(this.clazz, string);
                        clazz = propertyDescriptor.getPropertyType();
                    }
                    arrayList.add(clazz);
                    arrayList2.add(map.get(string));
                }
            }
            Object object = ReflectionUtil.invokeConstructor(this.clazz, arrayList.isEmpty() ? null : arrayList.toArray(new Class[0]), arrayList2.isEmpty() ? null : arrayList2.toArray());
            return object;
        }

        public void encode(Object object, YamlEncoder yamlEncoder, String string) {
            if (!yamlEncoder.isMinimalOutput()) {
                yamlEncoder.out.println("!" + this.clazz.getCanonicalName());
            } else {
                yamlEncoder.out.println();
            }
            for (String string2 : this.constructorFields) {
                try {
                    Object object2;
                    Class<?> clazz = null;
                    Object object3 = null;
                    try {
                        object2 = this.clazz.getField(string2);
                        if (ReflectionUtil.isPublicMemberField((Field)object2)) {
                            clazz = ((Field)object2).getType();
                            object3 = ((Field)object2).get(object);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (clazz == null) {
                        object2 = ReflectionUtil.getPropertyDescriptor(this.clazz, string2);
                        clazz = ((PropertyDescriptor)object2).getPropertyType();
                        object3 = ((PropertyDescriptor)object2).getReadMethod().invoke(object, null);
                    }
                    yamlEncoder.out.print(string + string2 + ": ");
                    if (clazz.isPrimitive()) {
                        yamlEncoder.writeSimpleValue(object3, clazz, yamlEncoder.indent(string));
                        continue;
                    }
                    yamlEncoder.writeObject(object3, yamlEncoder.indent(string), clazz);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }

        public void traverseAndCount(Object object, YamlEncoder yamlEncoder) {
            Object object2;
            List<PropertyDescriptor> list = ReflectionUtil.getPropertiesExcluding(this.removeFields, object);
            List<Field> list2 = ReflectionUtil.getFieldsExcluding(this.removeFields, object);
            ArrayList<Field> arrayList = new ArrayList<Field>(list2);
            for (Field object3 : list2) {
                for (PropertyDescriptor propertyDescriptor : list) {
                    if (!object3.getName().equals(propertyDescriptor.getName())) continue;
                    arrayList.remove(object3);
                }
            }
            for (PropertyDescriptor propertyDescriptor : list) {
                if (propertyDescriptor.getPropertyType().isPrimitive()) continue;
                object2 = propertyDescriptor.getReadMethod();
                try {
                    Object object3 = ((Method)object2).invoke(object, null);
                    yamlEncoder.traverseAndCount(object3);
                }
                catch (Exception exception) {
                    throw new YamlParserException(exception);
                }
            }
            for (Field field : arrayList) {
                if (!ReflectionUtil.isPublicMemberField(field) || field.getType().isPrimitive()) continue;
                object2 = null;
                try {
                    object2 = field.get(object);
                }
                catch (Exception exception) {
                    throw new YamlParserException("This shouldn't happen.");
                }
                yamlEncoder.traverseAndCount(object2);
            }
        }
    }

    static class Holder {
        Class clazz;
        Map<String, Object> values = new HashMap<String, Object>();

        Holder(Class clazz) {
            this.clazz = clazz;
        }
    }
}

