/*
 * Decompiled with CFR 0.152.
 */
package org.ho.yaml;

import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.ho.yaml.ReflectionUtil;
import org.ho.yaml.SpecialTreatmentManager;
import org.ho.yaml.YamlConfig;
import org.ho.yaml.YamlParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlEncoder {
    PrintWriter out;
    Map<Object, ObjectEntry> referenceMap = new IdentityHashMap<Object, ObjectEntry>();
    NameGenerator nameGenerator = new NameGenerator();
    SpecialTreatmentManager stManager = new SpecialTreatmentManager();
    YamlConfig config = YamlConfig.getDefaultConfig();

    public YamlEncoder(OutputStream outputStream) {
        this.out = new PrintWriter(new OutputStreamWriter(outputStream));
    }

    public YamlEncoder(File file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public YamlEncoder(String string) throws FileNotFoundException {
        this(new File(string));
    }

    public String getIndentAmount() {
        return this.config.getIndentAmount();
    }

    public void setIndentAmount(String string) {
        this.config.setIndentAmount(string);
    }

    public boolean isMinimalOutput() {
        return this.config.isMinimalOutput();
    }

    public void setMinimalOutput(boolean bl) {
        this.config.setMinimalOutput(bl);
    }

    void traverseAndCount(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof String) {
            return;
        }
        this.mark(object);
        if (this.refCount(object) > 1) {
            return;
        }
        if (ReflectionUtil.isSimpleType(object.getClass())) {
            return;
        }
        if (this.needSpecialTreatment(object)) {
            this.traverseAndCountSpecialTreatment(object);
        } else if (object instanceof Collection) {
            this.traverseAndCountCollection((Collection)object);
        } else if (object instanceof Map) {
            this.traverseAndCountMap((Map)object);
        } else if (object.getClass().isArray()) {
            this.traverseAndCountArray(object);
        } else {
            this.traverseAndCountJavaBean(object);
        }
    }

    void traverseAndCountCollection(Collection collection) {
        for (Object e : collection) {
            this.traverseAndCount(e);
        }
    }

    void traverseAndCountArray(Object object) {
        if (!object.getClass().getComponentType().isPrimitive()) {
            for (int i = 0; i < Array.getLength(object); ++i) {
                Object object2 = Array.get(object, i);
                this.traverseAndCount(object2);
            }
        }
    }

    void traverseAndCountMap(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.traverseAndCount(entry.getKey());
            this.traverseAndCount(entry.getValue());
        }
    }

    void traverseAndCountJavaBean(Object object) {
        List<PropertyDescriptor> list = ReflectionUtil.getProperties(object);
        for (PropertyDescriptor propertyDescriptor : list) {
            if (propertyDescriptor.getPropertyType().isPrimitive()) continue;
            try {
                Object object2 = propertyDescriptor.getReadMethod().invoke(object, null);
                if (object2 == null) continue;
                this.traverseAndCount(object2);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
    }

    void traverseAndCountSpecialTreatment(Object object) {
    }

    int refCount(Object object) {
        ObjectEntry objectEntry = this.referenceMap.get(object);
        return objectEntry != null ? objectEntry.refs : 0;
    }

    boolean toBeAnchored(Object object) {
        ObjectEntry objectEntry = this.referenceMap.get(object);
        return objectEntry != null && objectEntry.refs > 1 && !objectEntry.anchorDeclared;
    }

    boolean toBeAliased(Object object) {
        ObjectEntry objectEntry = this.referenceMap.get(object);
        return objectEntry != null && objectEntry.refs > 1 && objectEntry.anchorDeclared;
    }

    void mark(Object object) {
        ObjectEntry objectEntry = this.referenceMap.get(object);
        if (objectEntry == null) {
            objectEntry = new ObjectEntry(object);
            this.referenceMap.put(object, objectEntry);
        }
        ++objectEntry.refs;
    }

    void generateNames() {
        for (Map.Entry<Object, ObjectEntry> entry : this.referenceMap.entrySet()) {
            if (entry.getValue().refs < 2) continue;
            entry.getValue().refname = this.generateName(entry.getValue());
        }
    }

    String generateName(Object object) {
        return this.nameGenerator.generate(object);
    }

    public void writeObject(Object object) {
        this.traverseAndCount(object);
        this.generateNames();
        this.out.print("--- ");
        this.writeObject(object, "", object.getClass());
        this.reset();
    }

    void reset() {
        this.referenceMap.clear();
        this.nameGenerator = new NameGenerator();
    }

    String indent(String string) {
        return this.getIndentAmount() + string;
    }

    boolean needSpecialTreatment(Object object) {
        return this.stManager.needsSpecialTreatment(object);
    }

    void writeSpecial(Object object, String string, Class clazz) {
        this.stManager.encode(object, this, string);
    }

    void writeObject(Object object, String string, Class clazz) {
        if (object == null) {
            this.out.println("~");
        } else if (this.toBeAliased(object)) {
            this.writeReference(object);
        } else {
            if (this.toBeAnchored(object)) {
                this.writeAlias(object);
            }
            if (ReflectionUtil.isSimpleType(object.getClass())) {
                this.writeSimpleValue(object, clazz, string);
            } else if (this.needSpecialTreatment(object)) {
                this.writeSpecial(object, string, clazz);
            } else if (object instanceof Collection) {
                this.writeCollection((Collection)object, string);
            } else if (object instanceof Map) {
                this.writeMap((Map)object, string, clazz);
            } else if (object.getClass().isArray()) {
                this.writeArray(object, string, clazz);
            } else {
                this.writeJavaBean(object, string, clazz);
            }
        }
    }

    void writeReference(Object object) {
        ObjectEntry objectEntry = this.referenceMap.get(object);
        this.out.println("*" + objectEntry.refname);
    }

    void writeAlias(Object object) {
        ObjectEntry objectEntry = this.referenceMap.get(object);
        this.out.print("&" + objectEntry.refname + " ");
        objectEntry.anchorDeclared = true;
    }

    void writeSimpleValue(Object object, Class clazz, String string) {
        if (object instanceof String) {
            this.out.println(YamlEncoder.stringify(object, string));
        } else {
            if (!(clazz != null && this.isMinimalOutput() || object.getClass() == Integer.class || object.getClass() == Boolean.class)) {
                this.out.print("!" + this.getTransferName(object.getClass()) + " ");
            }
            if (object instanceof Date) {
                this.out.println("" + ((Date)object).getTime());
            } else if (object instanceof File) {
                this.out.println(object.toString());
            } else if (object.getClass().isEnum()) {
                this.writeEnum(object, clazz);
            } else {
                this.out.println(object.toString());
            }
        }
    }

    void writeEnum(Object object, Class clazz) {
        try {
            this.out.println(object.getClass().getMethod("name", null).invoke(object, null));
        }
        catch (Exception exception) {
            throw new YamlParserException("Cannot invoke name() method of " + object);
        }
    }

    String quote(Object object) {
        return "\"" + object + "\"";
    }

    static String stringify(Object object, String string) {
        String string2 = object.toString();
        if (string2.indexOf(10) != -1) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("|");
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                stringBuffer.append("\n" + string + string3);
            }
            return stringBuffer.toString();
        }
        if ("".equals(string2)) {
            return YamlEncoder.quote(string2);
        }
        String string4 = ":[]{},\"";
        boolean bl = false;
        for (char c : string4.toCharArray()) {
            if (string2.indexOf(c) == -1) continue;
            bl = true;
            break;
        }
        if (bl) {
            string2 = string2.replaceAll("\\\\", "\\\\\\\\");
            string2 = string2.replaceAll("\"", "\\\\\"");
            string2 = YamlEncoder.quote(string2);
        }
        return string2;
    }

    static String quote(String string) {
        return "\"" + string + "\"";
    }

    void writeMap(Map<String, Object> map, String string, Class clazz) {
        if (!(this.isMinimalOutput() || clazz == Map.class && clazz == HashMap.class)) {
            this.out.println("!" + this.getTransferName(map.getClass()));
        } else {
            this.out.println();
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.out.print(string + entry.getKey() + ": ");
            this.writeObject(entry.getValue(), this.indent(string), null);
        }
    }

    void writeCollection(Collection collection, String string) {
        if (collection.size() > 0) {
            if (this.isMinimalOutput() || collection instanceof ArrayList) {
                this.out.println();
            } else {
                this.out.println("!" + this.getTransferName(collection.getClass()));
            }
            for (Object e : collection) {
                this.out.print(string + "- ");
                this.writeObject(e, this.indent(string), null);
            }
        }
    }

    void writeArray(Object object, String string, Class clazz) {
        if (Array.getLength(object) == 0) {
            if (this.isMinimalOutput() && object.getClass() == clazz) {
                this.out.println("[]");
            } else {
                this.out.println("!" + ReflectionUtil.arrayName(object.getClass(), this.config) + " []");
            }
        } else {
            if (this.isMinimalOutput() && object.getClass() == clazz) {
                this.out.println();
            } else {
                this.out.println("!" + ReflectionUtil.arrayName(object.getClass(), this.config));
            }
            for (int i = 0; i < Array.getLength(object); ++i) {
                Object object2 = Array.get(object, i);
                this.out.print(string + "- ");
                if (object.getClass().getComponentType().isPrimitive()) {
                    this.writeSimpleValue(object2, clazz == null ? object.getClass().getComponentType() : clazz.getComponentType(), this.indent(string));
                    continue;
                }
                this.writeObject(object2, this.indent(string), clazz == null ? object.getClass().getComponentType() : clazz.getComponentType());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeJavaBean(Object object, String string, Class clazz) {
        Object object2;
        List<PropertyDescriptor> list = ReflectionUtil.getProperties(object);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List<Field> list2 = ReflectionUtil.getFields(object);
        Object var7_7 = null;
        try {
            var7_7 = object.getClass().newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Field object4 : list2) {
            void var11_16;
            if (!ReflectionUtil.isPublicMemberField(object4)) continue;
            for (PropertyDescriptor propertyDescriptor : list) {
                if (!object4.getName().equals(propertyDescriptor.getName())) continue;
            }
            object2 = null;
            Object var11_19 = null;
            try {
                object2 = object4.get(object);
                if (var7_7 != null) {
                    Object object3 = object4.get(var7_7);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (var7_7 == null || this.same(object2, var11_16)) continue;
            arrayList.add(object4);
        }
        for (PropertyDescriptor propertyDescriptor : list) {
            void var11_24;
            object2 = null;
            Object var11_22 = null;
            try {
                object2 = propertyDescriptor.getReadMethod().invoke(object, (Object[])null);
                if (var7_7 != null) {
                    Object object4 = propertyDescriptor.getReadMethod().invoke(var7_7, (Object[])null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (var7_7 == null || this.same(object2, var11_24)) continue;
            arrayList.add(propertyDescriptor);
        }
        if (arrayList.size() == 0) {
            if (this.isMinimalOutput() && object.getClass() == clazz) {
                this.out.println("{}");
            } else {
                this.out.println("!" + this.getTransferName(object.getClass()) + " {}");
            }
        } else {
            if (this.isMinimalOutput() && object.getClass() == clazz) {
                this.out.println();
            } else {
                this.out.println("!" + this.getTransferName(object.getClass()));
            }
            for (Object object5 : arrayList) {
                void var11_30;
                Object object6;
                object2 = null;
                Object var11_26 = null;
                if (object5 instanceof PropertyDescriptor) {
                    void var11_28;
                    object6 = (PropertyDescriptor)object5;
                    try {
                        object2 = ((PropertyDescriptor)object6).getReadMethod().invoke(object, (Object[])null);
                        if (var7_7 != null) {
                            Object object7 = ((PropertyDescriptor)object6).getReadMethod().invoke(var7_7, (Object[])null);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (var7_7 == null || this.same(object2, var11_28)) continue;
                    this.out.print(string + ((FeatureDescriptor)object6).getName() + ": ");
                    this.writeObject(object2, this.indent(string), ((PropertyDescriptor)object6).getPropertyType());
                    continue;
                }
                object6 = (Field)object5;
                try {
                    object2 = ((Field)object6).get(object);
                    if (var7_7 != null) {
                        Object object8 = ((Field)object6).get(var7_7);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (var7_7 == null || this.same(object2, var11_30)) continue;
                this.out.print(string + ((Field)object6).getName() + ": ");
                this.writeObject(object2, this.indent(string), ((Field)object6).getType());
            }
        }
    }

    boolean same(Object object, Object object2) {
        if (object != null) {
            return object.equals(object2);
        }
        if (object2 != null) {
            return object2.equals(object);
        }
        return true;
    }

    String getTransferName(Class clazz) {
        return ReflectionUtil.className(clazz, this.config);
    }

    public void close() {
        this.out.close();
    }

    public void flush() {
        this.out.flush();
    }

    public YamlConfig getConfig() {
        return this.config;
    }

    public void setConfig(YamlConfig yamlConfig) {
        this.config = yamlConfig;
    }

    class NameGenerator {
        BigInteger i = BigInteger.ONE;

        NameGenerator() {
        }

        String generate(Object object) {
            String string = this.i.toString();
            this.i = this.i.add(BigInteger.ONE);
            return string;
        }
    }

    class ObjectEntry {
        Object target;
        String refname = null;
        int refs = 0;
        boolean anchorDeclared = false;

        ObjectEntry(Object object) {
            this.target = object;
        }

        public String toString() {
            return "{target: " + this.target + ", refname: " + this.refname + ", refs: " + this.refs + "}";
        }
    }
}

