/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.misc;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Locale;
import java.util.ResourceBundle;
import net.morilib.db.jdbc.RelationsJDBCUtils;
import net.morilib.db.misc.RelationsLogger;

public final class ErrorBundle {
    private static RelationsLogger logger = RelationsJDBCUtils.logger;
    private static final ErrorBundle _DEF = ErrorBundle.getInstance(Locale.getDefault());
    private ResourceBundle bundle;

    private ErrorBundle(ResourceBundle b) {
        this.bundle = b;
    }

    public static synchronized ErrorBundle getInstance(Locale locale) {
        ResourceBundle b = ResourceBundle.getBundle("net/morilib/db/misc/relations_errors", locale);
        return new ErrorBundle(b);
    }

    public String getMessage(int code, Object ... mesg) {
        String s = this.bundle.getString(String.valueOf(code));
        return s != null ? String.format(s, mesg) : s;
    }

    public SQLException getException(int code, Object ... mesg) {
        SQLException e;
        String s = this.getMessage(code, mesg);
        StringWriter t = new StringWriter();
        PrintWriter w = new PrintWriter(t);
        if (s != null) {
            s = String.format(s, mesg);
            e = new SQLException(s, null, code);
        } else {
            e = new SQLException("unknown code: " + code, null, 99999);
        }
        e.printStackTrace(w);
        w.flush();
        logger.finer(w.toString());
        return e;
    }

    public SQLException getIOException(Throwable z, Object ... mesg) {
        String s = this.getMessage(10037, new Object[0]);
        StringWriter t = new StringWriter();
        PrintWriter w = new PrintWriter(t);
        s = String.format(s, mesg);
        SQLException e = new SQLException(s, null, 10037, z);
        e.printStackTrace(w);
        w.flush();
        logger.finer(t.toString());
        return e;
    }

    public static String getDefaultMessage(int code, Object ... mesg) {
        return _DEF.getMessage(code, mesg);
    }

    public static SQLException getDefault(int code, Object ... mesg) {
        return _DEF.getException(code, mesg);
    }

    public static SQLException getIODefault(Throwable z, Object ... mesg) {
        return _DEF.getIOException(z, mesg);
    }
}

