/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.relations;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.relations.AbstractRelation;
import net.morilib.db.relations.DefaultRelationTuple;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationCursor;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;

public class ProjectedTableRelation
extends AbstractRelation {
    Relation rel;
    List<String> columnNames;
    Collection<RelationTuple> data;

    public ProjectedTableRelation(Relation r, List<String> names, Collection<RelationTuple> data) {
        this.rel = r;
        this.columnNames = new ArrayList<String>(names);
        this.data = data;
    }

    @Override
    public List<SqlColumnDefinition> getColumnNames() {
        ArrayList<SqlColumnDefinition> l = new ArrayList<SqlColumnDefinition>();
        for (String s : this.columnNames) {
            l.add(this.getDefinition(s));
        }
        return l;
    }

    @Override
    public RelationCursor iterator() {
        final Iterator<RelationTuple> i = this.data.iterator();
        return new RelationCursor(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public RelationTuple next() {
                final RelationTuple t = (RelationTuple)i.next();
                return new RelationTuple(){

                    @Override
                    public Object get(String n) throws SQLException {
                        if ((this).ProjectedTableRelation.this.columnNames.contains(n)) {
                            return t.get(n);
                        }
                        throw ErrorBundle.getDefault(10009, n);
                    }

                    @Override
                    public RelationTuple copy() throws SQLException {
                        return new DefaultRelationTuple(this.toMap());
                    }

                    @Override
                    public Map<String, Object> toMap() throws SQLException {
                        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
                        for (String s : (this).ProjectedTableRelation.this.columnNames) {
                            m.put(s, t.get(s));
                        }
                        return m;
                    }
                };
            }
        };
    }

    @Override
    public SqlColumnDefinition getDefinition(String name) {
        int i = 0;
        while (i < this.columnNames.size()) {
            if (this.columnNames.get(i).equals(name)) {
                return this.rel.getDefinition(this.rel.getColumnNames().get(i).getName());
            }
            ++i;
        }
        return null;
    }
}

