/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.schema;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.morilib.db.fichier.FabriqueDeFichier;
import net.morilib.db.fichier.Fichier;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.misc.HTMLTableHandler;
import net.morilib.db.misc.HTMLTermException;
import net.morilib.db.misc.NullBoolean;
import net.morilib.db.relations.DefaultRelationTuple;
import net.morilib.db.relations.NamedRelation;
import net.morilib.db.relations.Relation;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.relations.SingleTableRelation;
import net.morilib.db.relations.TableRenameRelation;
import net.morilib.db.schema.HTMLTbls;
import net.morilib.db.schema.HTMLWriteTbls;
import net.morilib.db.schema.SqlSchema;
import net.morilib.db.schema.SqlSchemata;
import net.morilib.db.sqlcs.ddl.SqlColumnDefinition;
import net.morilib.db.sqlcs.ddl.SqlCreateTable;
import net.morilib.parser.html.HTMLHandler;
import net.morilib.parser.html.HTMLParseException;
import net.morilib.parser.html.HTMLParser;

public class HTMLSqlSchema
implements SqlSchema {
    private Fichier html;
    private Map<String, Relation> rels;

    public HTMLSqlSchema(Fichier htmlfile) {
        this.html = htmlfile;
    }

    private static void _parse(HTMLHandler h, BufferedReader b) throws IOException, SQLException {
        try {
            HTMLParser.parse(h, b);
        }
        catch (HTMLTermException hTMLTermException) {
        }
        catch (HTMLParseException e) {
            throw (SQLException)e.getCause();
        }
    }

    SqlCreateTable _getCreateTable(String name) throws IOException, SQLException {
        HTMLTableHandler h = new HTMLTableHandler(name);
        BufferedReader b = null;
        try {
            b = new BufferedReader(this.html.openReader());
            HTMLSqlSchema._parse(h, b);
            if (h.getValues().size() == 0) {
                return null;
            }
            SqlCreateTable sqlCreateTable = SqlSchemata.guessTable(name, h.getValues());
            return sqlCreateTable;
        }
        finally {
            if (b != null) {
                b.close();
            }
        }
    }

    @Override
    public NamedRelation readRelation(String name, String as) throws IOException, SQLException {
        HTMLTableHandler h = new HTMLTableHandler(name);
        BufferedReader b = null;
        if (this.rels != null && this.rels.containsKey(name.toUpperCase())) {
            return new TableRenameRelation(this.rels.get(name.toUpperCase()), (as != null ? as : name).toUpperCase());
        }
        try {
            b = new BufferedReader(this.html.openReader());
            HTMLSqlSchema._parse(h, b);
            if (h.getValues().size() == 0) {
                throw ErrorBundle.getDefault(10015, name);
            }
            List<List<String>> l = h.getValues();
            SqlCreateTable t = SqlSchemata.guessTable(name, l);
            ArrayList<RelationTuple> r = new ArrayList<RelationTuple>();
            LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
            List<SqlColumnDefinition> d = t.getColumnDefinitions();
            int i = 1;
            while (i < l.size()) {
                int j = 0;
                while (j < d.size()) {
                    m.put(d.get(j).getName(), d.get(j).getType().cast(l.get(i).get(j)));
                    ++j;
                }
                r.add(new DefaultRelationTuple(m));
                ++i;
            }
            SingleTableRelation singleTableRelation = new SingleTableRelation(t, as != null ? as : name, r);
            return singleTableRelation;
        }
        finally {
            if (b != null) {
                b.close();
            }
        }
    }

    @Override
    public void writeRelation(String name, Collection<RelationTuple> z) throws IOException, SQLException {
        Fichier f;
        char[] a = new char[1024];
        BufferedReader b = null;
        Writer w = null;
        try {
            b = new BufferedReader(this.html.openReader());
            f = this.fabrique().createTempFile("html", ".html.tmp");
            w = f.openWriter();
            HTMLWriteTbls t = new HTMLWriteTbls(w, this.getCreateTable(name), z);
            HTMLSqlSchema._parse(t, b);
        }
        finally {
            if (b != null) {
                b.close();
            }
            if (w != null) {
                w.close();
            }
        }
        try {
            int j;
            b = new BufferedReader(f.openReader());
            w = new BufferedWriter(this.html.openWriter());
            while ((j = b.read(a)) >= 0) {
                w.write(a, 0, j);
            }
        }
        finally {
            if (b != null) {
                b.close();
            }
            if (w != null) {
                w.close();
            }
        }
    }

    @Override
    public SqlCreateTable getCreateTable(String name) throws IOException, SQLException {
        SqlCreateTable t = this._getCreateTable(name);
        if (t == null) {
            throw ErrorBundle.getDefault(10015, name);
        }
        return t;
    }

    @Override
    public Collection<String> getTableNames() throws IOException, SQLException {
        HTMLTbls t = new HTMLTbls();
        BufferedReader b = null;
        try {
            b = new BufferedReader(this.html.openReader());
            HTMLSqlSchema._parse(t, b);
            List<String> list = Collections.unmodifiableList(t.names);
            return list;
        }
        finally {
            if (b != null) {
                b.close();
            }
        }
    }

    @Override
    public boolean isTable(String name) throws IOException, SQLException {
        return this._getCreateTable(name) != null;
    }

    @Override
    public void putCreateTable(String name, SqlCreateTable table) throws IOException, SQLException {
        throw ErrorBundle.getDefault(10017, new Object[0]);
    }

    @Override
    public void alterCreateTable(String name, SqlCreateTable table) throws IOException, SQLException {
        throw ErrorBundle.getDefault(10017, new Object[0]);
    }

    @Override
    public void truncateTable(String name) throws IOException, SQLException {
        throw ErrorBundle.getDefault(10017, new Object[0]);
    }

    @Override
    public void removeCreateTable(String name) throws IOException, SQLException {
        throw ErrorBundle.getDefault(10017, new Object[0]);
    }

    @Override
    public SqlSchema fork() {
        return this;
    }

    @Override
    public NullBoolean isReadonly() {
        return NullBoolean.FALSE;
    }

    @Override
    public NullBoolean usesLocalFiles() {
        return NullBoolean.TRUE;
    }

    @Override
    public NullBoolean usesLocalFilePerTable() {
        return NullBoolean.FALSE;
    }

    @Override
    public FabriqueDeFichier fabrique() {
        return FabriqueDeFichier.getDefault();
    }

    @Override
    public void bindSchema(String name, Relation r) {
        this.rels.put(name, r);
    }

    @Override
    public boolean isAutoCommit() {
        return true;
    }

    @Override
    public boolean isLocked(String name) {
        Fichier f = this.html.getParent();
        f = this.fabrique().newInstance(f, String.valueOf(name) + ".lock");
        return f.isFile();
    }

    @Override
    public boolean isUsed(String name) {
        Fichier f = this.html.getParent();
        f = this.fabrique().newInstance(f, String.valueOf(name) + ".lock");
        return f.isFile();
    }

    @Override
    public void lock(String name) throws IOException {
        Fichier f = this.html.getParent();
        f = this.fabrique().newInstance(f, String.valueOf(name) + ".lock");
        f.createNewFile();
    }

    @Override
    public void unlock(String name) throws IOException {
        Fichier f = this.html.getParent();
        f = this.fabrique().newInstance(f, String.valueOf(name) + ".lock");
        f.delete();
    }
}

