/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.httpd;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.httpd.DynamicEcrire;
import net.morilib.httpd.Ecrire;
import net.morilib.httpd.HTTPDispatch;
import net.morilib.httpd.HTTPLogger;
import net.morilib.httpd.HTTPLoggerFactory;
import net.morilib.httpd.HTTPRequest;
import net.morilib.httpd.HTTPRequestContinuableParser;
import net.morilib.httpd.HTTPUtils;
import net.morilib.httpd.ResourceEcrire;

public class HTTPServer {
    private static final int PORT = 9393;
    private static final int BUFSIZE = 1024;
    private static Pattern PN1 = Pattern.compile("(/([^\\?]+/)*([^/\\.\\?]+(\\.([^/\\.\\?]+))?)?)(\\?.*)?$");
    static HTTPLogger log = new HTTPLoggerFactory.L();
    private Map<SelectionKey, HTTPRequestContinuableParser> wait = new HashMap<SelectionKey, HTTPRequestContinuableParser>();
    private Map<SelectionKey, Ecrire> ecrire = new HashMap<SelectionKey, Ecrire>();
    private Map<String, HTTPDispatch> dispatchers = new HashMap<String, HTTPDispatch>();
    private Charset cset;
    private String root;

    public HTTPServer(String root) {
        this.root = root;
        this.cset = Charset.defaultCharset();
    }

    Ecrire dispatch(SelectionKey k, HTTPRequest q) throws IOException {
        log.finest("method: %s", q.getMethod());
        log.finest("path: %s", q.getPath());
        log.finest("version: %s", q.getVersion());
        try {
            String s = q.getPath();
            Matcher m = PN1.matcher(s);
            if (!m.find()) {
                log.finest("400: %s", s);
                return HTTPUtils.MESSAGE400;
            }
            if (m.group(3) == null) {
                log.finest("directory: %s", s);
                return new ResourceEcrire(String.valueOf(this.root) + s + "index.html");
            }
            if (m.group(4) != null) {
                log.finest("file: %s", s);
                return new ResourceEcrire(String.valueOf(this.root) + s);
            }
            log.finest("dynamic: %s", s);
            s = (String.valueOf(this.root) + s).replace('/', '.');
            Class<?> c = Class.forName(s);
            HTTPDispatch d = this.dispatchers.get(s);
            if (d == null) {
                d = (HTTPDispatch)c.newInstance();
                this.dispatchers.put(s, d);
            }
            return new DynamicEcrire(d, q, c);
        }
        catch (Exception e) {
            log.finest("exception read(): %s", e.toString());
            return HTTPUtils.MESSAGE500;
        }
    }

    void accept(Selector s, ServerSocketChannel c) throws IOException {
        SocketChannel d = c.accept();
        d.configureBlocking(false);
        d.register(s, 1);
    }

    void read(SelectionKey k) throws IOException {
        SocketChannel c = (SocketChannel)k.channel();
        ByteBuffer b = ByteBuffer.allocate(1024);
        HTTPRequestContinuableParser s = null;
        s = this.wait.get(k);
        while (c.read(b) > 0) {
            if (s == null) {
                s = new HTTPRequestContinuableParser(this.cset);
                this.wait.put(k, s);
            }
            b.flip();
            byte[] a = new byte[b.limit()];
            b.get(a);
            log.finest("\"%s\"", new String(a, this.cset));
            s.readPartial(new ByteArrayInputStream(a));
        }
        if (s == null) {
            k.cancel();
            c.close();
        } else {
            log.finest("read end of request", new Object[0]);
            this.wait.remove(k);
            HTTPRequest q = s.getRequest();
            Ecrire w = this.dispatch(k, q);
            k.interestOps(k.interestOps() | 4);
            this.ecrire.put(k, w);
            log.finest("ready to response", new Object[0]);
        }
    }

    void write(SelectionKey k) throws IOException {
        SocketChannel c = (SocketChannel)k.channel();
        try {
            Ecrire w = this.ecrire.get(k);
            if (w != null) {
                log.finest("ecrire found", new Object[0]);
                w.write(c);
            } else {
                log.finest("ecrire not found", new Object[0]);
            }
            log.finest("responded", new Object[0]);
        }
        finally {
            k.cancel();
            c.close();
        }
    }

    public void serve() throws IOException {
        ServerSocketChannel c = null;
        try {
            Selector s = Selector.open();
            c = ServerSocketChannel.open();
            c.configureBlocking(false);
            c.socket().bind(new InetSocketAddress(9393));
            c.register(s, 16);
            while (s.select() > 0) {
                try {
                    Iterator<SelectionKey> i = s.selectedKeys().iterator();
                    while (i.hasNext()) {
                        SelectionKey k = i.next();
                        i.remove();
                        if (!k.isValid()) continue;
                        if (k.isAcceptable()) {
                            this.accept(s, (ServerSocketChannel)k.channel());
                            continue;
                        }
                        if (k.isReadable()) {
                            log.finest("begin to read", new Object[0]);
                            this.read(k);
                            continue;
                        }
                        if (!k.isWritable()) continue;
                        log.finest("begin to write", new Object[0]);
                        this.write(k);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
        finally {
            if (c != null && c.isOpen()) {
                c.close();
            }
        }
    }
}

