/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.expr;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import net.morilib.db.engine.SqlEngine;
import net.morilib.db.misc.DbBool;
import net.morilib.db.misc.ParseDate;
import net.morilib.db.misc.Rational;
import net.morilib.db.relations.RelationAggregate;
import net.morilib.db.relations.RelationTuple;
import net.morilib.db.schema.SqlSchema;

public abstract class RelationExpression {
    public static final Object TRUE = Rational.ONE;
    public static final Object TRUE_OUTER = Rational.ONE.negate();
    public static final Object FALSE = Rational.ZERO;
    public static final Object NULL = "";
    public static final Object NONE = new Serializable(){};

    public static int cmp(Object a, Object b) {
        if (a instanceof Date && b instanceof Date) {
            return ((Date)a).compareTo((Date)b);
        }
        if (a instanceof Date) {
            return ((Date)a).compareTo(ParseDate.getDate(b.toString()));
        }
        if (b instanceof Date) {
            return ParseDate.getDate(a.toString()).compareTo((Date)b);
        }
        if (a instanceof Rational && b instanceof Rational) {
            return ((Rational)a).compareTo((Rational)b);
        }
        return a.toString().compareTo(b.toString());
    }

    public static boolean isNull(Object a) {
        return a == null || a.equals("");
    }

    static DbBool bool(Object o) {
        if (o instanceof DbBool) {
            return (DbBool)((Object)o);
        }
        if (o instanceof Rational) {
            return ((Rational)o).signum() != 0 ? DbBool.TRUE : DbBool.FALSE;
        }
        return !o.equals("") ? DbBool.TRUE : DbBool.FALSE;
    }

    static Object value(DbBool b) {
        switch (b) {
            case FALSE: {
                return FALSE;
            }
            case TRUE_OUTER: {
                return TRUE_OUTER;
            }
            case TRUE: {
                return TRUE;
            }
        }
        throw new RuntimeException();
    }

    static Object value(boolean b) {
        return b ? Rational.ONE : Rational.ZERO;
    }

    public abstract Object eval(SqlEngine var1, SqlSchema var2, RelationTuple var3, RelationAggregate var4, List<String> var5, List<Object> var6) throws IOException, SQLException;

    public abstract Object init(SqlEngine var1, SqlSchema var2) throws SQLException;

    public abstract boolean isAggregate() throws SQLException;

    public DbBool test(SqlEngine v, SqlSchema f, RelationTuple tuple, RelationAggregate m, List<String> group, List<Object> h) throws IOException, SQLException {
        return RelationExpression.bool(this.eval(v, f, tuple, m, group, h));
    }
}

