/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.db.misc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.morilib.db.fichier.Fichier;
import net.morilib.db.misc.ErrorBundle;
import net.morilib.db.relations.RelationTuple;
import net.morilib.parser.html.HTMLHandler;
import net.morilib.parser.html.HTMLParseException;
import net.morilib.parser.html.HTMLParser;

public class XlsxSharedString {
    private static final String META = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>";
    private static final String SSTO = "<sst uniqueCount=\"%d\" count=\"%d\" xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\">";
    private List<String> values;
    private List<String> phonetic;
    private Map<Object, Integer> invert;

    public XlsxSharedString(InputStream ins) throws SQLException, IOException {
        R h = new R();
        this.values = new ArrayList<String>();
        this.phonetic = new ArrayList<String>();
        this.invert = new HashMap<Object, Integer>();
        BufferedReader r = new BufferedReader(new InputStreamReader(ins, "UTF-8"));
        try {
            HTMLParser.parse((HTMLHandler)h, r);
        }
        catch (HTMLParseException e) {
            throw (SQLException)e.getCause();
        }
    }

    public XlsxSharedString() {
        this.values = new ArrayList<String>();
        this.phonetic = new ArrayList<String>();
        this.invert = new HashMap<Object, Integer>();
    }

    public static XlsxSharedString fromXlsx(Fichier f) throws SQLException, IOException {
        ZipInputStream zip = null;
        try {
            ZipEntry ent;
            zip = new ZipInputStream(f.openInputStream());
            while ((ent = zip.getNextEntry()) != null) {
                if (!ent.getName().equals("xl/sharedStrings.xml")) continue;
                XlsxSharedString xlsxSharedString = new XlsxSharedString(zip);
                return xlsxSharedString;
            }
            return null;
        }
        finally {
            if (zip != null) {
                zip.close();
            }
        }
    }

    public static XlsxSharedString fromListOfTuple(Fichier f, Collection<RelationTuple> l) throws SQLException, IOException {
        XlsxSharedString r = XlsxSharedString.fromXlsx(f);
        for (RelationTuple t : l) {
            for (Map.Entry<String, Object> y : t.toMap().entrySet()) {
                if (!(y.getValue() instanceof String)) continue;
                r.addString((String)y.getValue());
            }
        }
        return r;
    }

    public String getString(int ind) {
        return this.values.get(ind);
    }

    public int getNumber(String s) throws SQLException {
        Integer i = this.invert.get(s);
        if (i == null) {
            throw ErrorBundle.getDefault(10046, new Object[0]);
        }
        return i;
    }

    public int addString(String s) {
        int c = this.values.indexOf(s);
        if (c < 0) {
            this.values.add(s);
            this.phonetic.add("1");
            this.invert.put(s, this.values.size() - 1);
            return this.values.size() - 1;
        }
        return c;
    }

    public void write(OutputStream ous) throws IOException {
        PrintWriter w = new PrintWriter(new BufferedWriter(new OutputStreamWriter(ous, "UTF-8")));
        w.println(META);
        w.format(SSTO, this.values.size(), this.values.size());
        int i = 0;
        while (i < this.values.size()) {
            w.println("<si>");
            w.format("<t>%s</t>", this.values.get(i));
            w.format("<phoneticPr fontId=\"%s\"/>", this.phonetic.get(i));
            w.println("</si>");
            ++i;
        }
        w.println("</sst>");
        w.flush();
    }

    private class R
    implements HTMLHandler {
        private int rowno = 0;
        private S stat = S.INIT;

        private R() {
        }

        @Override
        public void string(String s) throws HTMLParseException {
            if (this.stat == S.T && XlsxSharedString.this.values.size() < this.rowno) {
                XlsxSharedString.this.invert.put(s, XlsxSharedString.this.values.size());
                XlsxSharedString.this.values.add(s);
            }
        }

        @Override
        public void startTag(String s) throws HTMLParseException {
            switch (this.stat) {
                case INIT: {
                    if (!s.equals("sst")) break;
                    this.stat = S.SST;
                    break;
                }
                case SST: {
                    if (!s.equals("si")) break;
                    this.stat = S.SI;
                    XlsxSharedString.this.phonetic.add("");
                    ++this.rowno;
                    break;
                }
                case SI: {
                    if (s.equals("t")) {
                        this.stat = S.T;
                        break;
                    }
                    if (!s.equals("phoneticPr")) break;
                    this.stat = S.PHONETIC;
                    break;
                }
            }
        }

        @Override
        public void endTag(String s) throws HTMLParseException {
            switch (this.stat) {
                case INIT: {
                    break;
                }
                case SST: {
                    if (!s.equals("sst")) break;
                    this.stat = S.INIT;
                    break;
                }
                case SI: {
                    if (!s.equals("si")) break;
                    this.stat = S.SST;
                    break;
                }
                case T: {
                    if (!s.equals("t")) break;
                    if (XlsxSharedString.this.values.size() < this.rowno) {
                        XlsxSharedString.this.invert.put("", XlsxSharedString.this.values.size());
                        XlsxSharedString.this.values.add("");
                    }
                    this.stat = S.SI;
                    break;
                }
                case PHONETIC: {
                    if (!s.equals("phoneticPr")) break;
                    this.stat = S.SI;
                }
            }
        }

        @Override
        public void tagAttribute(String k, String v) throws HTMLParseException {
            if (this.stat == S.PHONETIC && k.equals("fontId")) {
                XlsxSharedString.this.phonetic.set(XlsxSharedString.this.values.size() - 1, v);
            }
        }

        @Override
        public void meta(String s) throws HTMLParseException {
        }

        @Override
        public void comment(String s) throws HTMLParseException {
        }
    }

    private static enum S {
        INIT,
        SST,
        SI,
        T,
        PHONETIC;

    }
}

